/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.requirement;

import java.util.List;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class ExperienceLevelRequirement
implements WarpRequirement {
    private int levels;

    public ExperienceLevelRequirement(int levels) {
        this.levels = Math.max(0, levels);
    }

    @Override
    public boolean canAfford(Player player) {
        return player.f_36078_ >= this.levels;
    }

    @Override
    public void consume(Player player) {
        player.m_6749_(-this.levels);
    }

    @Override
    public void rollback(Player player) {
        player.m_6749_(this.levels);
    }

    @Override
    public void appendHoverText(Player player, List<Component> tooltip) {
        if (this.levels > 0) {
            tooltip.add((Component)Component.m_237110_((String)"gui.waystones.waystone_selection.level_requirement", (Object[])new Object[]{this.levels}).m_130940_(ChatFormatting.GREEN));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.levels <= 0;
    }

    public void setLevels(int levels) {
        this.levels = levels;
    }

    public int getLevels() {
        return this.levels;
    }
}

