/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.waystones.block.ModBlocks;
import net.blay09.mods.waystones.recipe.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WaystoneRecipe
implements Recipe<Container> {
    private final ItemStack resultItem;
    private final Ingredient primaryIngredient;
    private final NonNullList<Ingredient> secondaryIngredients;
    private final NonNullList<Ingredient> combinedIngredients;

    public WaystoneRecipe(ItemStack resultItem, Ingredient primaryIngredient, NonNullList<Ingredient> secondaryIngredients) {
        this.resultItem = resultItem;
        this.primaryIngredient = primaryIngredient;
        this.secondaryIngredients = secondaryIngredients;
        this.combinedIngredients = NonNullList.m_182647_((int)5);
        this.combinedIngredients.add((Object)primaryIngredient);
        this.combinedIngredients.addAll(secondaryIngredients);
    }

    public boolean m_5818_(Container inventory, Level level) {
        if (!this.primaryIngredient.test(inventory.m_8020_(0))) {
            return false;
        }
        StackedContents stackedContents = new StackedContents();
        int foundInputs = 0;
        for (int i = 0; i < this.combinedIngredients.size(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            ++foundInputs;
            stackedContents.m_36468_(itemStack, 1);
        }
        return foundInputs == this.combinedIngredients.size() && stackedContents.m_36475_((Recipe)this, null);
    }

    public ItemStack m_5874_(Container inventory, RegistryAccess registryAccess) {
        return this.resultItem.m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.resultItem;
    }

    public ItemStack getOutputItem() {
        return this.resultItem;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.combinedIngredients;
    }

    public boolean m_5598_() {
        return true;
    }

    public String m_6076_() {
        return "waystone";
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)ModBlocks.warpPlate);
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.waystoneRecipeSerializer;
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.waystoneRecipeType;
    }

    static class Serializer
    implements RecipeSerializer<WaystoneRecipe> {
        private static final Codec<WaystoneRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_302323_.fieldOf("result").forGetter(recipe -> recipe.resultItem), (App)Ingredient.f_291570_.fieldOf("primary").forGetter(recipe -> recipe.primaryIngredient), (App)Ingredient.f_291570_.listOf().fieldOf("secondary").flatXmap(secondary -> {
            Object[] ingredients = (Ingredient[])secondary.stream().filter(ingredient -> !ingredient.m_43947_()).toArray(Ingredient[]::new);
            return ingredients.length > 4 ? DataResult.error(() -> "Too many secondary ingredients for warp plate recipe") : DataResult.success((Object)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])ingredients));
        }, DataResult::success).forGetter(recipe -> recipe.secondaryIngredients)).apply((Applicative)instance, WaystoneRecipe::new));

        Serializer() {
        }

        public Codec<WaystoneRecipe> m_292673_() {
            return CODEC;
        }

        public WaystoneRecipe fromNetwork(FriendlyByteBuf buf) {
            ItemStack resultItem = buf.m_130267_();
            Ingredient primaryIngredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            int secondaryCount = buf.m_130242_();
            NonNullList secondaryIngredients = NonNullList.m_182647_((int)secondaryCount);
            for (int i = 0; i < secondaryCount; ++i) {
                secondaryIngredients.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            }
            return new WaystoneRecipe(resultItem, primaryIngredient, (NonNullList<Ingredient>)secondaryIngredients);
        }

        public void toNetwork(FriendlyByteBuf buf, WaystoneRecipe recipe) {
            buf.m_130055_(recipe.resultItem);
            recipe.primaryIngredient.m_43923_(buf);
            buf.m_130130_(recipe.secondaryIngredients.size());
            for (Ingredient ingredient : recipe.secondaryIngredients) {
                ingredient.m_43923_(buf);
            }
        }
    }
}

