/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystoneManagerImpl;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.menu.WaystoneMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class EditWaystoneMessage {
    private final UUID waystoneUid;
    private final String name;
    private final WaystoneVisibility visibility;

    public EditWaystoneMessage(UUID waystoneUid, String name, WaystoneVisibility visibility) {
        this.waystoneUid = waystoneUid;
        this.name = name;
        this.visibility = visibility;
    }

    public static void encode(EditWaystoneMessage message, FriendlyByteBuf buf) {
        buf.m_130077_(message.waystoneUid);
        buf.m_130070_(message.name);
        buf.m_130068_((Enum)message.visibility);
    }

    public static EditWaystoneMessage decode(FriendlyByteBuf buf) {
        UUID waystoneUid = buf.m_130259_();
        String name = buf.m_130136_(255);
        WaystoneVisibility visibility = (WaystoneVisibility)buf.m_130066_(WaystoneVisibility.class);
        return new EditWaystoneMessage(waystoneUid, name, visibility);
    }

    public static void handle(ServerPlayer player, EditWaystoneMessage message) {
        WaystoneProxy waystone = new WaystoneProxy(player.f_8924_, message.waystoneUid);
        Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone((Player)player, player.m_9236_(), waystone);
        if (error.isPresent()) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (!(abstractContainerMenu instanceof WaystoneMenu)) {
            return;
        }
        WaystoneMenu settingsMenu = (WaystoneMenu)abstractContainerMenu;
        WaystoneVisibility visibility = message.visibility;
        if (!settingsMenu.getVisibilityOptions().contains((Object)message.visibility)) {
            Waystones.logger.warn("{} tried to edit a waystone with an invalid visibility {}", (Object)player.m_7755_().getString(), (Object)message.visibility);
            visibility = settingsMenu.getVisibilityOptions().get(0);
        }
        if (!WaystonePermissionManager.isAllowedVisibility(visibility) && !WaystonePermissionManager.skipsPermissions((Player)player)) {
            Waystones.logger.warn("{} tried to edit a restricted waystone without permission", (Object)player.m_7755_().getString());
            return;
        }
        BlockPos pos = waystone.getPos();
        if (player.m_20275_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f)) > 64.0) {
            return;
        }
        WaystoneImpl backingWaystone = (WaystoneImpl)waystone.getBackingWaystone();
        Component legalName = EditWaystoneMessage.makeNameLegal(player.f_8924_, message.name);
        backingWaystone.setName(legalName);
        if (visibility == WaystoneVisibility.GLOBAL && (WaystonePermissionManager.isAllowedVisibility(visibility) || WaystonePermissionManager.skipsPermissions((Player)player)) && backingWaystone.getVisibility() != WaystoneVisibility.GLOBAL) {
            PlayerWaystoneManager.activeWaystoneForEveryone(player.f_8924_, backingWaystone);
        }
        backingWaystone.setVisibility(visibility);
        WaystoneManagerImpl.get(player.f_8924_).m_77762_();
        WaystoneSyncManager.sendWaystoneUpdateToAll(player.f_8924_, backingWaystone);
        player.m_6915_();
    }

    private static Component makeNameLegal(MinecraftServer server, String input) {
        if (input.trim().isEmpty()) {
            return Component.m_237115_((String)"waystones.untitled_waystone");
        }
        String inventoryButtonMode = WaystonesConfig.getActive().inventoryButton.inventoryButton;
        if (inventoryButtonMode.equals(input) && WaystoneManagerImpl.get(server).findWaystoneByName(input).isPresent()) {
            return Component.m_237113_((String)(input + "*"));
        }
        return Component.m_237113_((String)input);
    }
}

