/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.trait.IAttunementItem;
import net.blay09.mods.waystones.api.trait.IFOVOnUse;
import net.blay09.mods.waystones.api.trait.IResetUseOnDamage;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.WaystoneProxy;
import net.blay09.mods.waystones.item.ScrollItemBase;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BoundScrollItem
extends ScrollItemBase
implements IResetUseOnDamage,
IFOVOnUse,
IAttunementItem {
    public BoundScrollItem(Item.Properties properties) {
        super(properties);
    }

    public int m_8105_(ItemStack itemStack) {
        return WaystonesConfig.getActive().general.scrollUseTime;
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity entity) {
        if (!world.f_46443_ && entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            Optional<Waystone> boundTo = this.getWaystoneAttunedTo(player.m_20194_(), (Player)player, stack);
            boundTo.ifPresent(targetWaystone -> WaystonesAPI.createDefaultTeleportContext((Entity)player, targetWaystone, it -> it.setWarpItem(stack)).mapLeft(WaystonesAPI::tryTeleport).ifLeft(it -> {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
            }));
        }
        return stack;
    }

    @Override
    public Optional<Waystone> getWaystoneAttunedTo(MinecraftServer server, Player player, ItemStack itemStack) {
        CompoundTag compound = itemStack.m_41783_();
        if (compound != null && compound.m_128425_("AttunedToWaystone", 11)) {
            return Optional.of(new WaystoneProxy(server, NbtUtils.m_129233_((Tag)Objects.requireNonNull(compound.m_128423_("AttunedToWaystone")))));
        }
        return Optional.empty();
    }

    @Override
    public void setWaystoneAttunedTo(ItemStack itemStack, @Nullable Waystone waystone) {
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound == null) {
            tagCompound = new CompoundTag();
            itemStack.m_41751_(tagCompound);
        }
        if (waystone != null) {
            tagCompound.m_128365_("AttunedToWaystone", (Tag)NbtUtils.m_129226_((UUID)waystone.getWaystoneUid()));
        } else {
            tagCompound.m_128473_("AttunedToWaystone");
        }
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        Player player = Balm.getProxy().getClientPlayer();
        if (player == null) {
            return;
        }
        Optional<Waystone> boundTo = this.getWaystoneAttunedTo(player.m_20194_(), player, itemStack);
        boundTo.ifPresent(it -> {
            MutableComponent boundToValueComponent = it.getName().m_6881_().m_130940_(ChatFormatting.AQUA);
            list.add((Component)Component.m_237110_((String)"tooltip.waystones.bound_to", (Object[])new Object[]{boundToValueComponent}).m_130940_(ChatFormatting.GRAY));
        });
    }

    public boolean m_5812_(ItemStack itemStack) {
        return true;
    }
}

