/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class WaystoneVisbilityButton
extends Button
implements ITooltipProvider {
    private static final ResourceLocation WAYSTONE_GUI_TEXTURES = new ResourceLocation("waystones", "textures/gui/menu/waystone.png");
    private final List<WaystoneVisibility> options;
    private final boolean canEdit;
    private WaystoneVisibility visibility;

    public WaystoneVisbilityButton(int x, int y, WaystoneVisibility visibility, List<WaystoneVisibility> options, boolean canEdit) {
        super(x, y, 18, 18, (Component)Component.m_237119_(), button -> {}, Button.f_252438_);
        this.options = options;
        this.visibility = visibility;
        this.canEdit = canEdit;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        guiGraphics.m_280218_(WAYSTONE_GUI_TEXTURES, this.m_252754_(), this.m_252907_(), 176 + (this.f_93622_ ? 18 : 0), 14, 18, 18);
        guiGraphics.m_280218_(WAYSTONE_GUI_TEXTURES, this.m_252754_(), this.m_252907_(), 176, 32 + this.visibility.ordinal() * 18, 18, 18);
    }

    @Override
    public boolean shouldShowTooltip() {
        return this.f_93622_;
    }

    @Override
    public List<Component> getTooltipComponents() {
        MutableComponent visibilityValueComponent = Component.m_237115_((String)("tooltip.waystones.visibility." + this.visibility.name().toLowerCase(Locale.ROOT))).m_130940_(ChatFormatting.WHITE);
        ArrayList<Component> result = new ArrayList<Component>();
        result.add((Component)Component.m_237110_((String)"tooltip.waystones.visibility", (Object[])new Object[]{visibilityValueComponent}).m_130940_(ChatFormatting.YELLOW));
        if (!this.canEdit) {
            result.add((Component)Component.m_237110_((String)"tooltip.waystones.edit_restricted", (Object[])new Object[]{visibilityValueComponent}).m_130940_(ChatFormatting.RED));
        }
        return result;
    }

    public WaystoneVisibility getVisibility() {
        return this.visibility;
    }

    public void m_5691_() {
        if (this.canEdit) {
            int index = this.options.indexOf((Object)this.visibility);
            this.visibility = this.options.get((index + 1) % this.options.size());
        }
    }
}

