/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneVisibility;
import net.blay09.mods.waystones.client.gui.widget.ITooltipProvider;
import net.blay09.mods.waystones.client.gui.widget.WaystoneVisbilityButton;
import net.blay09.mods.waystones.menu.WaystoneMenu;
import net.blay09.mods.waystones.network.message.EditWaystoneMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class WaystoneScreen
extends AbstractContainerScreen<WaystoneMenu> {
    private static final ResourceLocation WAYSTONE_GUI_TEXTURES = new ResourceLocation("waystones", "textures/gui/menu/waystone.png");
    private final List<ITooltipProvider> tooltipProviders = new ArrayList<ITooltipProvider>();
    private EditBox textField;
    private WaystoneVisbilityButton visibilityButton;

    public WaystoneScreen(WaystoneMenu container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title);
        this.f_97727_ = 210;
        this.f_97731_ = this.f_97727_ - 94;
    }

    public void m_7856_() {
        super.m_7856_();
        Waystone waystone = ((WaystoneMenu)this.f_97732_).getWaystone();
        String oldText = waystone.getName().getString();
        if (this.textField != null) {
            oldText = this.textField.m_94155_();
        }
        WaystoneVisibility oldVisibility = waystone.getVisibility();
        if (this.visibilityButton != null) {
            oldVisibility = this.visibilityButton.getVisibility();
        }
        this.tooltipProviders.clear();
        this.textField = new EditBox(Minecraft.m_91087_().f_91062_, this.f_97735_ + 33, this.f_97736_ + 9, 110, 16, this.textField, (Component)Component.m_237119_());
        this.textField.m_94199_(128);
        this.textField.m_94144_(oldText);
        this.textField.m_94186_(((WaystoneMenu)this.f_97732_).canEdit());
        this.m_142416_(this.textField);
        if (((WaystoneMenu)this.f_97732_).canEdit() && oldText.isEmpty()) {
            this.m_264313_((GuiEventListener)this.textField);
        }
        this.visibilityButton = new WaystoneVisbilityButton(this.f_97735_ + 9, this.f_97736_ + 8, oldVisibility, ((WaystoneMenu)this.f_97732_).getVisibilityOptions(), ((WaystoneMenu)this.f_97732_).canEdit());
        this.m_142416_(this.visibilityButton);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (((WaystoneMenu)this.f_97732_).canEdit() && this.textField.m_5953_(mouseX, mouseY) && button == 1) {
            this.textField.m_94144_("");
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.textField.m_7933_(keyCode, scanCode, modifiers) || this.textField.m_93696_()) {
            if (keyCode == 256 || keyCode == 257) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        for (ITooltipProvider tooltipProvider : this.tooltipProviders) {
            if (!tooltipProvider.shouldShowTooltip()) continue;
            guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltipProvider.getTooltipComponents(), Optional.empty(), mouseX, mouseY);
        }
        if (this.textField != null && this.textField.m_94155_().isEmpty()) {
            guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"waystones.untitled_waystone"), this.textField.m_252754_() + 4, this.textField.m_252907_() + 4, 0x808080);
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280218_(WAYSTONE_GUI_TEXTURES, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        guiGraphics.m_280218_(WAYSTONE_GUI_TEXTURES, this.f_97735_ + 86, this.f_97736_ + 53, 176, 4, 4, (int)(10.0f * ((WaystoneMenu)this.f_97732_).getAttunementProgress()));
        guiGraphics.m_280218_(WAYSTONE_GUI_TEXTURES, this.f_97735_ + 107 - (int)(10.0f * ((WaystoneMenu)this.f_97732_).getAttunementProgress()), this.f_97736_ + 70, 176, 0, (int)(10.0f * ((WaystoneMenu)this.f_97732_).getAttunementProgress()), 4);
        guiGraphics.m_280218_(WAYSTONE_GUI_TEXTURES, this.f_97735_ + 86, this.f_97736_ + 91 - (int)(10.0f * ((WaystoneMenu)this.f_97732_).getAttunementProgress()), 176, 4, 4, (int)(10.0f * ((WaystoneMenu)this.f_97732_).getAttunementProgress()));
        guiGraphics.m_280218_(WAYSTONE_GUI_TEXTURES, this.f_97735_ + 69, this.f_97736_ + 70, 176, 0, (int)(10.0f * ((WaystoneMenu)this.f_97732_).getAttunementProgress()), 4);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, 0x404040, false);
    }

    public void m_7379_() {
        if (this.textField != null && this.visibilityButton != null) {
            Balm.getNetworking().sendToServer((Object)new EditWaystoneMessage(((WaystoneMenu)this.f_97732_).getWaystone().getWaystoneUid(), this.textField.m_94155_(), this.visibilityButton.getVisibility()));
        }
        super.m_7379_();
    }

    protected <T extends GuiEventListener & Renderable> T m_142416_(T widget) {
        if (widget instanceof ITooltipProvider) {
            this.tooltipProviders.add((ITooltipProvider)widget);
        }
        return (T)super.m_142416_(widget);
    }
}

