/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.screen.ScreenDrawEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.waystones.api.TeleportFlags;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneCooldowns;
import net.blay09.mods.waystones.api.WaystoneTeleportContext;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.api.requirement.WarpRequirement;
import net.blay09.mods.waystones.client.gui.screen.InventoryButtonReturnConfirmScreen;
import net.blay09.mods.waystones.client.gui.widget.WaystoneInventoryButton;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.InvalidWaystone;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.network.message.InventoryButtonMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class InventoryButtonGuiHandler {
    private static WaystoneInventoryButton warpButton;

    public static void initialize() {
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, event -> {
            Screen screen = event.getScreen();
            if (!(screen instanceof InventoryScreen) && !(screen instanceof CreativeModeInventoryScreen)) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (screen != mc.f_91080_) {
                return;
            }
            InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
            if (!inventoryButtonMode.isEnabled()) {
                return;
            }
            Supplier<Integer> xPosition = screen instanceof CreativeModeInventoryScreen ? () -> WaystonesConfig.getActive().inventoryButton.creativeInventoryButtonX : () -> WaystonesConfig.getActive().inventoryButton.inventoryButtonX;
            Supplier<Integer> yPosition = screen instanceof CreativeModeInventoryScreen ? () -> WaystonesConfig.getActive().inventoryButton.creativeInventoryButtonY : () -> WaystonesConfig.getActive().inventoryButton.inventoryButtonY;
            warpButton = new WaystoneInventoryButton((AbstractContainerScreen)screen, button -> {
                WarpRequirement requirements;
                LocalPlayer player = mc.f_91074_;
                if (player.m_150110_().f_35937_) {
                    PlayerWaystoneManager.resetCooldowns((Player)player);
                }
                if ((requirements = WaystonesAPI.resolveRequirements(WaystonesAPI.createUnboundTeleportContext((Entity)player).addFlag(TeleportFlags.INVENTORY_BUTTON))).canAfford((Player)player)) {
                    if (inventoryButtonMode.hasNamedTarget()) {
                        mc.m_91152_((Screen)new InventoryButtonReturnConfirmScreen(inventoryButtonMode.getNamedTarget()));
                    } else if (inventoryButtonMode.isReturnToNearest()) {
                        if (PlayerWaystoneManager.getNearestWaystone((Player)player).isPresent()) {
                            mc.m_91152_((Screen)new InventoryButtonReturnConfirmScreen());
                        }
                    } else if (inventoryButtonMode.isReturnToAny()) {
                        Balm.getNetworking().sendToServer((Object)new InventoryButtonMessage());
                    }
                } else {
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)0.5f));
                }
            }, () -> {
                if (screen instanceof CreativeModeInventoryScreen) {
                    CreativeModeInventoryScreen creativeModeInventoryScreen = (CreativeModeInventoryScreen)screen;
                    return creativeModeInventoryScreen.m_258017_();
                }
                return true;
            }, xPosition, yPosition);
            BalmClient.getScreens().addRenderableWidget(screen, (AbstractWidget)warpButton);
        });
        Balm.getEvents().onEvent(ScreenDrawEvent.Post.class, event -> {
            Screen screen = event.getScreen();
            GuiGraphics guiGraphics = event.getGuiGraphics();
            int mouseX = event.getMouseX();
            int mouseY = event.getMouseY();
            if ((screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) && warpButton != null && warpButton.m_198029_()) {
                InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
                ArrayList<Component> tooltip = new ArrayList<Component>();
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return;
                }
                long millisLeft = PlayerWaystoneManager.getCooldownMillisLeft((Player)player, WaystoneCooldowns.INVENTORY_BUTTON);
                Waystone waystone = PlayerWaystoneManager.getInventoryButtonTarget((Player)player).orElse(InvalidWaystone.INSTANCE);
                WaystoneTeleportContext context = WaystonesAPI.createUnboundTeleportContext((Entity)player, waystone).addFlag(TeleportFlags.INVENTORY_BUTTON);
                WarpRequirement requirements = WaystonesAPI.resolveRequirements(context);
                int secondsLeft = (int)(millisLeft / 1000L);
                if (inventoryButtonMode.hasNamedTarget()) {
                    tooltip.add((Component)Component.m_237115_((String)"gui.waystones.inventory.return_to_waystone").m_130940_(ChatFormatting.YELLOW));
                    MutableComponent targetComponent = Component.m_237113_((String)inventoryButtonMode.getNamedTarget()).m_130940_(ChatFormatting.DARK_AQUA);
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.waystones.bound_to", (Object[])new Object[]{targetComponent}).m_130940_(ChatFormatting.GRAY));
                    if (secondsLeft > 0) {
                        tooltip.add((Component)Component.m_237119_());
                    }
                } else if (inventoryButtonMode.isReturnToNearest()) {
                    tooltip.add((Component)Component.m_237115_((String)"gui.waystones.inventory.return_to_nearest_waystone").m_130940_(ChatFormatting.YELLOW));
                    Optional<Waystone> nearestWaystone = PlayerWaystoneManager.getNearestWaystone((Player)player);
                    tooltip.add((Component)nearestWaystone.map(it -> it.getName().m_6881_().m_130940_(ChatFormatting.DARK_AQUA)).map(it -> Component.m_237110_((String)"tooltip.waystones.bound_to", (Object[])new Object[]{it}).m_130940_(ChatFormatting.GRAY)).orElseGet(() -> Component.m_237115_((String)"gui.waystones.inventory.no_waystones_activated").m_130940_(ChatFormatting.RED)));
                    if (secondsLeft > 0) {
                        tooltip.add((Component)Component.m_237119_());
                    }
                } else if (inventoryButtonMode.isReturnToAny()) {
                    tooltip.add((Component)Component.m_237115_((String)"gui.waystones.inventory.return_to_waystone").m_130940_(ChatFormatting.YELLOW));
                    if (PlayerWaystoneManager.getActivatedWaystones((Player)player).isEmpty()) {
                        tooltip.add((Component)Component.m_237115_((String)"gui.waystones.inventory.no_waystones_activated").m_130940_(ChatFormatting.RED));
                    }
                }
                if (!requirements.canAfford((Player)player)) {
                    requirements.appendHoverText((Player)player, tooltip);
                }
                if (secondsLeft > 0) {
                    tooltip.add((Component)Component.m_237110_((String)"tooltip.waystones.cooldown_left", (Object[])new Object[]{secondsLeft}).m_130940_(ChatFormatting.GOLD));
                }
                guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, tooltip, Optional.empty(), mouseX, mouseY);
            }
        });
    }
}

