/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block.entity;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.error.WaystoneEditError;
import net.blay09.mods.waystones.block.entity.ModBlockEntities;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WaystoneImpl;
import net.blay09.mods.waystones.core.WaystonePermissionManager;
import net.blay09.mods.waystones.menu.ModMenus;
import net.blay09.mods.waystones.menu.WaystoneMenu;
import net.blay09.mods.waystones.menu.WaystoneSelectionMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class WaystoneBlockEntity
extends WaystoneBlockEntityBase {
    public WaystoneBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.waystone.get(), blockPos, blockState);
    }

    @Override
    protected ResourceLocation getWaystoneType() {
        return WaystoneTypes.WAYSTONE;
    }

    public BalmMenuProvider getMenuProvider() {
        return new BalmMenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"container.waystones.waystone_selection");
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
                Collection<Waystone> waystones = PlayerWaystoneManager.getTargetsForWaystone(player, WaystoneBlockEntity.this.getWaystone());
                PlayerWaystoneManager.ensureSortingIndex(player, waystones);
                return new WaystoneSelectionMenu((MenuType<WaystoneSelectionMenu>)((MenuType)ModMenus.waystoneSelection.get()), WaystoneBlockEntity.this.getWaystone(), windowId, waystones, Collections.emptySet());
            }

            public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                buf.m_130064_(WaystoneBlockEntity.this.f_58858_);
                Collection<Waystone> waystones = PlayerWaystoneManager.getTargetsForWaystone((Player)player, WaystoneBlockEntity.this.getWaystone());
                WaystoneImpl.writeList(buf, waystones);
            }
        };
    }

    public BalmMenuProvider getSettingsMenuProvider() {
        return new BalmMenuProvider(){

            public Component m_5446_() {
                return Component.m_237115_((String)"container.waystones.waystone");
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone(player, player.m_9236_(), WaystoneBlockEntity.this.getWaystone());
                return new WaystoneMenu(windowId, WaystoneBlockEntity.this.getWaystone(), WaystoneBlockEntity.this, WaystoneBlockEntity.this.dataAccess, inventory, error.isEmpty());
            }

            public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                buf.m_130064_(WaystoneBlockEntity.this.f_58858_);
                WaystoneImpl.write(buf, WaystoneBlockEntity.this.getWaystone());
                Optional<WaystoneEditError> error = WaystonePermissionManager.mayEditWaystone((Player)player, player.m_9236_(), WaystoneBlockEntity.this.getWaystone());
                buf.writeBoolean(error.isEmpty());
            }
        };
    }
}

