/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class ShapelessBackpackRecipe
extends ShapelessRecipe {
    public ShapelessBackpackRecipe(String groupIn, CraftingBookCategory category, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(groupIn, category, recipeOutputIn, recipeItemsIn);
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack output = super.m_5874_(inv, registryAccess);
        if (!output.m_41619_()) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack ingredient = inv.m_8020_(i);
                if (ingredient.m_41619_() || !(ingredient.m_41720_() instanceof TravelersBackpackItem)) continue;
                CompoundTag compound = ingredient.m_41783_();
                output.m_41751_(compound);
                break;
            }
        }
        return output;
    }

    private ItemStack damageShears(ItemStack stack) {
        Player craftingPlayer = ForgeHooks.getCraftingPlayer();
        if (stack.m_220157_(1, craftingPlayer == null ? RandomSource.m_216327_() : craftingPlayer.m_9236_().f_46441_, craftingPlayer instanceof ServerPlayer ? (ServerPlayer)craftingPlayer : null)) {
            ForgeEventFactory.onPlayerDestroyItem((Player)craftingPlayer, (ItemStack)stack, null);
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventoryCrafting) {
        NonNullList remainingItems = NonNullList.m_122780_((int)inventoryCrafting.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack itemstack = inventoryCrafting.m_8020_(i);
            if (!itemstack.m_41619_() && itemstack.m_41720_() instanceof ShearsItem) {
                remainingItems.set(i, (Object)this.damageShears(itemstack.m_41777_()));
                continue;
            }
            remainingItems.set(i, (Object)ForgeHooks.getCraftingRemainingItem((ItemStack)itemstack));
        }
        return remainingItems;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessBackpackRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final Codec<ShapelessBackpackRecipe> f_290581_ = RecordCodecBuilder.create(p_300970_ -> p_300970_.group((App)ExtraCodecs.m_295827_((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(p_299460_ -> p_299460_.m_6076_()), (App)CraftingBookCategory.f_244644_.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_297437_ -> p_297437_.m_245232_()), (App)ItemStack.f_302323_.fieldOf("result").forGetter(p_300770_ -> p_300770_.f_44243_), (App)Ingredient.f_290991_.listOf().fieldOf("ingredients").flatXmap(p_297969_ -> {
            Object[] aingredient = (Ingredient[])p_297969_.stream().filter(p_298915_ -> !p_298915_.m_43947_()).toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])aingredient));
        }, DataResult::success).forGetter(p_298509_ -> p_298509_.m_7527_())).apply((Applicative)p_300970_, ShapelessBackpackRecipe::new));

        public Codec<ShapelessBackpackRecipe> m_292673_() {
            return f_290581_;
        }

        @Nullable
        public ShapelessBackpackRecipe fromNetwork(FriendlyByteBuf pBuffer) {
            String s = pBuffer.m_130277_();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)pBuffer.m_130066_(CraftingBookCategory.class);
            int i = pBuffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack itemstack = pBuffer.m_130267_();
            return new ShapelessBackpackRecipe(s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessBackpackRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.f_44243_);
        }
    }
}

