/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.realisticbees_common_neoforge.mixin;

import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.realisticbees_common_neoforge.config.ConfigHandler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Bee.class}, priority=1001)
public abstract class BeeMixin
extends Animal {
    protected BeeMixin(EntityType<? extends Animal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    public void Bee(EntityType<? extends Bee> beeEntityType, Level level, CallbackInfo ci) {
        Bee bee = (Bee)this;
        EntityFunctions.setEntitySize((Entity)bee, (EntityDimensions)new EntityDimensions(0.7f, 0.6f, false).scale((float)ConfigHandler.beeSizeModifier), (float)bee.getEyeHeight(Pose.STANDING));
    }

    @Inject(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void hurt(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        Bee bee = (Bee)this;
        if (ConfigHandler.preventBeeSuffocationDamage && damageSource.equals(bee.level().damageSources().inWall())) {
            cir.setReturnValue((Object)false);
        }
    }

    @NotNull
    public EntityDimensions getDimensions(@NotNull Pose pose) {
        EntityDimensions defaultDimensions = pose == Pose.SLEEPING ? SLEEPING_DIMENSIONS : super.getDimensions(pose).scale(this.getScale());
        return defaultDimensions.scale((float)ConfigHandler.beeSizeModifier);
    }
}

