/*
 * Decompiled with CFR 0.152.
 */
package forge.io.github.akashiikun.mavapi.v1.mixin;

import forge.io.github.akashiikun.mavapi.v1.impl.AxolotlTypeExtension;
import forge.io.github.akashiikun.mavapi.v1.impl.MoreAxolotlVariant;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MobBucketItem.class})
public abstract class MobBucketItemMixin {
    private EntityType<?> entityType;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onInit(EntityType<?> entityType, Fluid fluid, SoundEvent soundEvent, Item.Properties properties, CallbackInfo ci) {
        this.entityType = entityType;
    }

    @Inject(method={"appendHoverText"}, at={@At(value="HEAD")})
    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context, CallbackInfo ci) {
        CompoundTag nbtCompound;
        if (this.entityType == EntityType.f_147039_ && (nbtCompound = stack.m_41783_()) != null && nbtCompound.m_128425_("Variant", 8)) {
            String variantIdentifier = nbtCompound.m_128461_("Variant");
            for (Axolotl.Variant variant : Axolotl.Variant.values()) {
                MoreAxolotlVariant metadata = ((AxolotlTypeExtension)variant).mavapi$metadata();
                ResourceLocation id = metadata.getId();
                if (!id.equals((Object)new ResourceLocation(variantIdentifier))) continue;
                int age = nbtCompound.m_128451_("Age");
                MutableComponent component = Component.m_237110_((String)"mavapi.bucket.format", (Object[])new Object[]{age < 0 ? Component.m_237115_((String)"mavapi.bucket.translation.baby") : Component.m_237115_((String)"mavapi.bucket.translation.adult"), this.translateOrFormat(String.format("mavapi.variant.%s.%s", id.m_135827_(), id.m_135815_()), id.m_135815_()), this.translateOrFormat(String.format("mavapi.mod.%s", id.m_135827_()), id.m_135827_())});
                component.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
                tooltip.add((Component)component);
                break;
            }
        }
    }

    private MutableComponent translateOrFormat(String translation, String toFormat) {
        MutableComponent component = Component.m_237115_((String)translation);
        if (!I18n.m_118936_((String)translation)) {
            component = Component.m_237113_((String)this.formatName(toFormat));
        }
        return component;
    }

    private String formatName(String s) {
        s = ((String)s).replace("_", " ");
        s = String.valueOf(((String)s).charAt(0)).toUpperCase(Locale.ROOT) + ((String)s).substring(1);
        return s;
    }
}

