/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.respawningshulkers.neoforge.events;

import com.natamus.respawningshulkers_common_neoforge.events.ShulkerEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;

@Mod.EventBusSubscriber
public class NeoForgeShulkerEvent {
    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent e) {
        Level level = e.level;
        if (level.isClientSide || !e.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        ShulkerEvent.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onShulkerDeath(LivingDeathEvent e) {
        LivingEntity entity = e.getEntity();
        ShulkerEvent.onShulkerDeath(entity.level(), (Entity)entity, e.getSource());
    }

    @SubscribeEvent
    public static void onServerShutdown(ServerStoppingEvent e) {
        ShulkerEvent.onServerShutdown(e.getServer());
    }
}

