/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.doubledoors_common_neoforge.util;

import com.natamus.collective_common_neoforge.functions.BlockPosFunctions;
import com.natamus.doubledoors_common_neoforge.config.ConfigHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class Util {
    public static boolean isDoorBlock(BlockState blockstate) {
        Block block = blockstate.getBlock();
        return block instanceof DoorBlock && ConfigHandler.enableDoors || block instanceof TrapDoorBlock && ConfigHandler.enableTrapdoors || block instanceof FenceGateBlock && ConfigHandler.enableFenceGates;
    }

    public static boolean isPressureBlock(BlockState blockstate) {
        Block block = blockstate.getBlock();
        if (block instanceof WeightedPressurePlateBlock) {
            return (Integer)blockstate.getValue((Property)BlockStateProperties.POWER) > 0;
        }
        if (block instanceof PressurePlateBlock || block instanceof ButtonBlock) {
            return (Boolean)blockstate.getValue((Property)BlockStateProperties.POWERED);
        }
        return false;
    }

    public static boolean processDoor(Player player, Level level, BlockPos pos, BlockState state, Boolean isopen, boolean playsound) {
        List<BlockPos> postoopen;
        Block block = state.getBlock();
        if (block instanceof DoorBlock && ((DoubleBlockHalf)state.getValue((Property)DoorBlock.HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            pos = pos.below().immutable();
            state = level.getBlockState(pos);
        }
        if (isopen == null) {
            isopen = (Boolean)state.getValue((Property)BlockStateProperties.OPEN) == false;
        }
        int yoffset = 0;
        if (!(block instanceof DoorBlock)) {
            yoffset = 1;
        }
        if ((postoopen = Util.recursivelyOpenDoors(new ArrayList<BlockPos>(Arrays.asList(pos.immutable())), new ArrayList<BlockPos>(), level, pos, pos, block, yoffset)).size() <= 1) {
            return false;
        }
        for (BlockPos toopen : postoopen) {
            BlockState ostate = level.getBlockState(toopen);
            Block oblock = ostate.getBlock();
            if (block instanceof DoorBlock) {
                if (!ConfigHandler.enableDoors) continue;
                DoorBlock door = (DoorBlock)oblock;
                if (playsound) {
                    level.playSound(null, pos, isopen != false ? SoundEvents.WOODEN_DOOR_OPEN : SoundEvents.WOODEN_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
                    playsound = false;
                }
                level.setBlock(toopen, (BlockState)ostate.setValue((Property)DoorBlock.OPEN, (Comparable)isopen), 10);
                continue;
            }
            if (block instanceof TrapDoorBlock) {
                if (!ConfigHandler.enableTrapdoors) continue;
                if (playsound) {
                    if (isopen.booleanValue()) {
                        int i = ostate.getMapColor((BlockGetter)level, toopen) == MapColor.METAL ? 1037 : 1007;
                        level.levelEvent(null, i, pos, 0);
                    } else {
                        int j = ostate.getMapColor((BlockGetter)level, toopen) == MapColor.METAL ? 1036 : 1013;
                        level.levelEvent(null, j, pos, 0);
                    }
                    playsound = false;
                }
                level.setBlock(toopen, (BlockState)ostate.setValue((Property)BlockStateProperties.OPEN, (Comparable)isopen), 10);
                continue;
            }
            if (!(block instanceof FenceGateBlock) || !ConfigHandler.enableFenceGates) continue;
            if (playsound) {
                level.playSound(null, pos, isopen != false ? SoundEvents.FENCE_GATE_OPEN : SoundEvents.FENCE_GATE_CLOSE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
                playsound = false;
            }
            level.setBlock(toopen, (BlockState)ostate.setValue((Property)DoorBlock.OPEN, (Comparable)isopen), 10);
        }
        if (player != null) {
            player.swing(InteractionHand.MAIN_HAND);
        }
        return postoopen.size() > 1;
    }

    private static List<BlockPos> recursivelyOpenDoors(List<BlockPos> postoopen, List<BlockPos> ignoreoopen, Level level, BlockPos originalpos, BlockPos pos, Block block, int yoffset) {
        Iterator blocksaround = BlockPos.betweenClosedStream((int)(pos.getX() - 1), (int)(pos.getY() - yoffset), (int)(pos.getZ() - 1), (int)(pos.getX() + 1), (int)(pos.getY() + yoffset), (int)(pos.getZ() + 1)).iterator();
        while (blocksaround.hasNext()) {
            BlockPos bpa = (BlockPos)blocksaround.next();
            if (postoopen.contains(bpa) || !BlockPosFunctions.withinDistance((BlockPos)originalpos, (BlockPos)bpa, (int)ConfigHandler.recursiveOpeningMaxBlocksDistance).booleanValue()) continue;
            BlockState ostate = level.getBlockState(bpa);
            Block oblock = ostate.getBlock();
            if (Util.isDoorBlock(ostate) && oblock.getName().equals((Object)block.getName())) {
                postoopen.add(bpa.immutable());
                if (!ConfigHandler.enableRecursiveOpening) continue;
                Util.recursivelyOpenDoors(postoopen, ignoreoopen, level, originalpos, bpa, block, yoffset);
                continue;
            }
            ignoreoopen.add(bpa.immutable());
        }
        return postoopen;
    }
}

