/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.doubledoors_common_neoforge.events;

import com.natamus.doubledoors_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.WeightedPressurePlateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class DoorEvent {
    private static final List<BlockPos> prevpoweredpos = new ArrayList<BlockPos>();
    private static final HashMap<BlockPos, Integer> prevbuttonpos = new HashMap();

    public static void onNeighbourNotice(Level world, BlockPos pos, BlockState state, EnumSet<Direction> notifiedSides, boolean forceRedstoneUpdate) {
        if (world.isClientSide) {
            return;
        }
        BooleanProperty proppowered = BlockStateProperties.POWERED;
        IntegerProperty weightedpower = BlockStateProperties.POWER;
        pos = pos.immutable();
        Block block = state.getBlock();
        if (!(block instanceof PressurePlateBlock) && !(block instanceof WeightedPressurePlateBlock)) {
            if (!(block instanceof ButtonBlock)) {
                return;
            }
            if (!prevbuttonpos.containsKey(pos)) {
                prevbuttonpos.put(pos, 1);
                return;
            }
            prevbuttonpos.remove(pos);
            if (!((Boolean)state.getValue((Property)proppowered)).booleanValue()) {
                if (!prevpoweredpos.contains(pos)) {
                    return;
                }
                prevpoweredpos.remove(pos);
            }
        } else if (block instanceof WeightedPressurePlateBlock ? (Integer)state.getValue((Property)weightedpower) == 0 && !prevpoweredpos.contains(pos) : (Boolean)state.getValue((Property)proppowered) == false && !prevpoweredpos.contains(pos)) {
            return;
        }
        boolean stateprop = block instanceof WeightedPressurePlateBlock ? (Integer)state.getValue((Property)weightedpower) > 0 : (Boolean)state.getValue((Property)proppowered);
        int radius = block instanceof ButtonBlock ? 2 : 1;
        BlockPos doorpos = null;
        for (BlockPos npos : BlockPos.betweenClosed((int)(pos.getX() - radius), (int)(pos.getY() - 1), (int)(pos.getZ() - radius), (int)(pos.getX() + radius), (int)(pos.getY() + 1), (int)(pos.getZ() + radius))) {
            BlockState ostate = world.getBlockState(npos);
            if (!Util.isDoorBlock(ostate)) continue;
            doorpos = npos;
            break;
        }
        if (doorpos != null && Util.processDoor(null, world, doorpos, world.getBlockState(doorpos), stateprop, true) && stateprop) {
            prevpoweredpos.add(pos);
        }
    }

    public static boolean onDoorClick(Level level, Player player, InteractionHand hand, BlockPos cpos, BlockHitResult hitVec) {
        if (level.isClientSide) {
            return true;
        }
        if (!hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return true;
        }
        if (player.isShiftKeyDown()) {
            return true;
        }
        BlockState clickstate = level.getBlockState(cpos);
        if (!Util.isDoorBlock(clickstate)) {
            return true;
        }
        if (clickstate.getMapColor((BlockGetter)level, cpos).equals(MapColor.METAL)) {
            return true;
        }
        return !Util.processDoor(player, level, cpos, clickstate, null, false);
    }
}

