/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.mixin.patches.entity;

import net.darkhax.bookshelf.api.block.ILightningConductive;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LightningBolt.class})
public class MixinLightningBolt {
    @Inject(method={"powerLightningRod()V"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onStrikeBlock(CallbackInfo callback, BlockPos strikePos, BlockState strikeState) {
        LightningBolt self = (LightningBolt)this;
        Block strikeBlock = strikeState.m_60734_();
        if (strikeBlock instanceof ILightningConductive) {
            ILightningConductive extended = (ILightningConductive)strikeBlock;
            extended.onDirectLightningStrike(self.m_9236_(), strikePos, strikeState, self);
        }
        if (MixinLightningBolt.canRedirect(self.m_9236_(), strikePos, strikeState)) {
            for (Direction direction : MixinLightningBolt.getRedirectionSides(self.m_9236_(), strikePos, strikeState)) {
                BlockPos indirectPos = strikePos.m_121945_(direction);
                BlockState indirectState = self.m_9236_().m_8055_(indirectPos);
                Block block = indirectState.m_60734_();
                if (!(block instanceof ILightningConductive)) continue;
                ILightningConductive extended = (ILightningConductive)block;
                extended.onIndirectLightingStrike(self.m_9236_(), strikePos, strikeState, indirectPos, indirectState, self);
            }
        }
    }

    @Unique
    private static boolean canRedirect(Level world, BlockPos pos, BlockState state) {
        ILightningConductive extended;
        Block block;
        return state.m_60713_(Blocks.f_152587_) || (block = state.m_60734_()) instanceof ILightningConductive && (extended = (ILightningConductive)block).canRedirectLightning(world, pos, state);
    }

    @Unique
    private static Direction[] getRedirectionSides(Level world, BlockPos pos, BlockState state) {
        if (state.m_60713_(Blocks.f_152587_)) {
            return ILightningConductive.LIGHTNING_REDIRECTION_FACES;
        }
        Block block = state.m_60734_();
        if (block instanceof ILightningConductive) {
            ILightningConductive extended = (ILightningConductive)block;
            return extended.getLightningRedirectionFaces(world, pos, state);
        }
        return ILightningConductive.NO_REDIRECTION_FACES;
    }
}

