/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest.tests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.impl.gametest.tests.CodecTests;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ItemStackTests
implements ITestable {
    @Override
    public String getDefaultBatch() {
        return "bookshelf.itemstack_tests";
    }

    @GameTest
    public void test_stack(GameTestHelper helper) {
        JsonObject object = new JsonObject();
        object.addProperty("item", "minecraft:stone");
        ItemStackTests.assertStackIsBasic(helper, CodecTests.fromJson(helper, BookshelfCodecs.ITEM_STACK.get(), (JsonElement)object));
        ItemStackTests.assertStackIsBasic(helper, CodecTests.fromJson(helper, BookshelfCodecs.ITEM_STACK_FLEXIBLE.get(), (JsonElement)object));
        ItemStackTests.assertStackIsBasic(helper, CodecTests.fromJson(helper, BookshelfCodecs.ITEM_STACK_FLEXIBLE.get(), (JsonElement)new JsonPrimitive("minecraft:stone")));
    }

    @GameTest
    public void test_stack_tag(GameTestHelper helper) {
        JsonObject object = new JsonObject();
        object.addProperty("item", "minecraft:stone");
        JsonObject nbt = new JsonObject();
        nbt.addProperty("test", "hello_world");
        object.add("nbt", (JsonElement)nbt);
        ItemStack readStack = CodecTests.fromJson(helper, BookshelfCodecs.ITEM_STACK.get(), (JsonElement)object);
        if (readStack == null || readStack.m_41619_() || !readStack.m_150930_(Items.f_41905_) || readStack.m_41613_() != 1 || !readStack.m_41782_() || !readStack.m_41783_().m_128425_("test", 8)) {
            helper.m_177284_("Unexpected ItemStack read! " + readStack);
        } else {
            helper.m_177412_();
        }
    }

    private static void assertStackIsBasic(GameTestHelper helper, ItemStack stack) {
        if (stack == null || stack.m_41619_() || !stack.m_150930_(Items.f_41905_) || stack.m_41782_() || stack.m_41613_() != 1) {
            helper.m_177284_("Unexpected ItemStack read! " + stack);
        } else {
            helper.m_177412_();
        }
    }
}

