/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest;

import com.google.common.collect.Iterables;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.darkhax.bookshelf.api.util.ItemStackHelper;
import net.darkhax.bookshelf.mixin.accessors.util.random.AccessorWeightedRandomList;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class TestHelper {
    public static <T> void assertEqual(GameTestHelper helper, Optional<T> a, Optional<T> b, BiPredicate<T, T> equality) {
        if (a.isPresent() != b.isPresent()) {
            helper.m_177284_("Optional values inconsistent. Original=" + a.isPresent() + " Result=" + b.isPresent());
            return;
        }
        if (a.isPresent() && b.isPresent() && !equality.test(a.get(), b.get())) {
            helper.m_177284_("Optional values do not match. Original=" + a.get() + " Result=" + b.get());
            return;
        }
        helper.m_177412_();
    }

    public static <T> void assertEqual(GameTestHelper helper, T[] a, T[] b, BiPredicate<T, T> equality) {
        if (a.length != b.length) {
            helper.m_177284_("Arrays do not have the same size. Original=" + a.length + " Result=" + b.length);
        } else {
            for (int index = 0; index < a.length; ++index) {
                if (equality.test(a[index], b[index])) continue;
                helper.m_177284_("List entry does not match! index=" + index + " a=" + a + " b=" + b);
                return;
            }
            helper.m_177412_();
        }
    }

    public static boolean assertEqual(EnchantmentInstance a, EnchantmentInstance b) {
        return Objects.equals(a, b) || a.f_44947_ == b.f_44947_ && a.f_44948_ == b.f_44948_;
    }

    public static <T> boolean assertEqual(TagKey<T> a, TagKey<T> b) {
        return Objects.equals(a, b) || Objects.equals(a.f_203868_(), b.f_203868_());
    }

    public static boolean assertEqual(Ingredient original, Ingredient result) {
        ItemStack[] resultStacks;
        if (Objects.equals(original, result)) {
            return true;
        }
        ItemStack[] originalStacks = original.m_43908_();
        if (originalStacks.length != (resultStacks = result.m_43908_()).length) {
            return false;
        }
        for (int index = 0; index < originalStacks.length; ++index) {
            if (ItemStackHelper.areStacksEquivalent(originalStacks[index], resultStacks[index])) continue;
            return false;
        }
        return true;
    }

    public static <T> void assertEqual(GameTestHelper helper, WeightedEntry.Wrapper<T> original, WeightedEntry.Wrapper<T> result, BiPredicate<T, T> equality) {
        if (Objects.equals(original, result)) {
            helper.m_177412_();
        } else if (original.m_142631_().m_146281_() != result.m_142631_().m_146281_()) {
            helper.m_177284_("Weights do not match. a=" + original.m_142631_() + " b=" + result.m_142631_());
        } else if (!equality.test(original.m_146310_(), result.m_146310_())) {
            helper.m_177284_("Weighted entries do not match. a=" + original.m_146310_() + " b=" + result.m_146310_());
        } else {
            helper.m_177412_();
        }
    }

    public static <T> void assertEqual(GameTestHelper helper, SimpleWeightedRandomList<T> original, SimpleWeightedRandomList<T> result) {
        TestHelper.assertEqual(helper, original, result, Objects::equals);
    }

    public static <T> void assertEqual(GameTestHelper helper, SimpleWeightedRandomList<T> original, SimpleWeightedRandomList<T> result, BiPredicate<T, T> equality) {
        AccessorWeightedRandomList accessOriginal = (AccessorWeightedRandomList)original;
        AccessorWeightedRandomList accessResult = (AccessorWeightedRandomList)result;
        if (accessOriginal.bookshelf$getEntries().size() != accessResult.bookshelf$getEntries().size()) {
            helper.m_177284_("Weighted lists do not have the same size. Original=" + accessOriginal.bookshelf$getEntries().size() + " Result=" + accessResult.bookshelf$getEntries().size());
        } else {
            for (int index = 0; index < accessOriginal.bookshelf$getEntries().size(); ++index) {
                WeightedEntry.Wrapper a = (WeightedEntry.Wrapper)accessOriginal.bookshelf$getEntries().get(index);
                WeightedEntry.Wrapper b = (WeightedEntry.Wrapper)accessResult.bookshelf$getEntries().get(index);
                if (a.m_142631_().m_146281_() != b.m_142631_().m_146281_()) {
                    helper.m_177284_("Weighted list entry weights do not match! index=" + index + " a=" + a.m_142631_().m_146281_() + " b=" + b.m_142631_().m_146281_());
                    return;
                }
                if (equality.test(a.m_146310_(), b.m_146310_())) continue;
                helper.m_177284_("Weighted list entry values do not match! index=" + index + " a=" + a.m_146310_() + " b=" + b.m_146310_());
                return;
            }
            helper.m_177412_();
        }
    }

    public static <T> void assertEqual(GameTestHelper helper, Iterable<T> original, Iterable<T> result) {
        TestHelper.assertEqual(helper, original, result, Objects::equals);
    }

    public static <T> void assertEqual(GameTestHelper helper, Iterable<T> original, Iterable<T> result, BiPredicate<T, T> equality) {
        int resultSize;
        int originalSize = Iterables.size(original);
        if (originalSize != (resultSize = Iterables.size(result))) {
            helper.m_177284_("Lists do not have the same size. Original=" + originalSize + " Result=" + resultSize);
        } else {
            for (int index = 0; index < originalSize; ++index) {
                Object b;
                Object a = Iterables.get(original, (int)index);
                if (equality.test(a, b = Iterables.get(result, (int)index))) continue;
                helper.m_177284_("List entry does not match! index=" + index + " a=" + a + " b=" + b);
                return;
            }
            helper.m_177412_();
        }
    }
}

