/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ShapelessDurabilityRecipe
extends ShapelessRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final ItemStack output;
    private final int damageAmount;

    public ShapelessDurabilityRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients, int damageAmount) {
        super(group, category, result, ingredients);
        this.damageAmount = damageAmount;
        this.output = result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList keptItems = super.m_7457_((Container)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (NonNullList<ItemStack>)keptItems, this.damageAmount);
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getDamageAmount() {
        return this.damageAmount;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessDurabilityRecipe> {
        private static final Codec<ShapelessDurabilityRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.m_295827_((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(ShapelessRecipe::m_6076_), (App)CraftingBookCategory.f_244644_.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapelessRecipe::m_245232_), (App)ItemStack.f_302323_.fieldOf("result").forGetter(ShapelessDurabilityRecipe::getOutput), (App)Ingredient.f_290991_.listOf().fieldOf("ingredients").flatXmap(ingredients -> {
            Object[] nonEmptyIngredients = (Ingredient[])ingredients.stream().filter(ingredient -> !ingredient.m_43947_()).toArray(Ingredient[]::new);
            if (nonEmptyIngredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return nonEmptyIngredients.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe") : DataResult.success((Object)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])nonEmptyIngredients));
        }, DataResult::success).forGetter(ShapelessRecipe::m_7527_), BookshelfCodecs.INT.get("damageAmount", ShapelessDurabilityRecipe::getDamageAmount)).apply((Applicative)instance, ShapelessDurabilityRecipe::new));

        public Codec<ShapelessDurabilityRecipe> m_292673_() {
            return CODEC;
        }

        public ShapelessDurabilityRecipe fromNetwork(FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            int ingredientSize = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientSize, (Object)Ingredient.f_43901_);
            for (int index = 0; index < ingredients.size(); ++index) {
                ingredients.set(index, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            int damageAmount = buffer.m_130242_();
            return new ShapelessDurabilityRecipe(group, category, output, (NonNullList<Ingredient>)ingredients, damageAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessDurabilityRecipe toWrite) {
            buffer.m_130070_(toWrite.m_6076_());
            buffer.m_130068_((Enum)toWrite.m_245232_());
            buffer.m_130130_(toWrite.m_7527_().size());
            for (Ingredient ingredient : toWrite.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(toWrite.output);
            buffer.m_130130_(toWrite.damageAmount);
        }
    }
}

