/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public final class ShapedDurabilityRecipe
extends ShapedRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final ShapedRecipePattern pattern;
    private final int damageAmount;
    private final ItemStack output;

    public ShapedDurabilityRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean notify, int damageAmount) {
        super(group, category, pattern, result, notify);
        this.pattern = pattern;
        this.damageAmount = damageAmount;
        this.output = result;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList keptItems = super.m_7457_((Container)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (NonNullList<ItemStack>)keptItems, this.damageAmount);
    }

    private ShapedRecipePattern getPattern() {
        return this.pattern;
    }

    private ItemStack getRecipeOutput() {
        return this.output;
    }

    private int getDamageAmount() {
        return this.damageAmount;
    }

    public static final class Serializer
    implements RecipeSerializer<ShapedDurabilityRecipe> {
        public static final Codec<ShapedDurabilityRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.m_295827_((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(ShapedRecipe::m_6076_), (App)CraftingBookCategory.f_244644_.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::m_245232_), (App)ShapedRecipePattern.f_302908_.forGetter(ShapedDurabilityRecipe::getPattern), (App)ItemStack.f_302323_.fieldOf("result").forGetter(ShapedDurabilityRecipe::getRecipeOutput), (App)ExtraCodecs.m_295827_((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(ShapedRecipe::m_271738_), BookshelfCodecs.INT.get("damageAmount", ShapedDurabilityRecipe::getDamageAmount)).apply((Applicative)instance, ShapedDurabilityRecipe::new));

        public Codec<ShapedDurabilityRecipe> m_292673_() {
            return CODEC;
        }

        public ShapedDurabilityRecipe fromNetwork(FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            ShapedRecipePattern pattern = ShapedRecipePattern.m_306640_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            boolean showNotif = buffer.readBoolean();
            int damageAmount = buffer.readInt();
            return new ShapedDurabilityRecipe(group, category, pattern, output, showNotif, damageAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedDurabilityRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            recipe.pattern.m_307574_(buffer);
            buffer.m_130055_(recipe.output);
            buffer.writeBoolean(recipe.m_271738_());
            buffer.writeInt(recipe.damageAmount);
        }
    }
}

