/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.data.conditions;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.api.data.codecs.CodecHelper;
import net.darkhax.bookshelf.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.api.data.conditions.impl.And;
import net.darkhax.bookshelf.api.data.conditions.impl.ModLoaded;
import net.darkhax.bookshelf.api.data.conditions.impl.Not;
import net.darkhax.bookshelf.api.data.conditions.impl.OnPlatform;
import net.darkhax.bookshelf.api.data.conditions.impl.Or;
import net.darkhax.bookshelf.api.data.conditions.impl.SpecificRegistryContains;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public class LoadConditions {
    private static final Map<ResourceLocation, ConditionType> CONDITION_TYPES = new HashMap<ResourceLocation, ConditionType>();
    private static final Codec<ConditionType> CONDITION_TYPE_CODEC = ResourceLocation.f_135803_.xmap(CONDITION_TYPES::get, ConditionType::id);
    public static final Codec<ILoadCondition> CONDITION_CODEC = CONDITION_TYPE_CODEC.dispatch(ILoadCondition::getType, ConditionType::codec);
    public static final CodecHelper<ILoadCondition> CODEC_HELPER = new CodecHelper<ILoadCondition>(CONDITION_CODEC, new ILoadCondition[0]);
    public static final ConditionType AND = LoadConditions.register(Constants.id("and"), And.CODEC);
    public static final ConditionType NOT = LoadConditions.register(Constants.id("not"), Not.CODEC);
    public static final ConditionType OR = LoadConditions.register(Constants.id("or"), Or.CODEC);
    public static final ConditionType ON_PLATFORM = LoadConditions.register(Constants.id("on_platform"), OnPlatform.CODEC);
    public static final ConditionType MOD_LOADED = LoadConditions.register(Constants.id("mod_loaded"), ModLoaded.CODEC);
    public static final ConditionType BLOCK_EXISTS = SpecificRegistryContains.of("block_exists", BuiltInRegistries.f_256975_);
    public static final ConditionType ITEM_EXISTS = SpecificRegistryContains.of("item_exists", BuiltInRegistries.f_257033_);
    public static final ConditionType ENCHANTMENT_EXISTS = SpecificRegistryContains.of("enchantment_exists", BuiltInRegistries.f_256876_);
    public static final ConditionType PAINTING_EXISTS = SpecificRegistryContains.of("painting_exists", BuiltInRegistries.f_257051_);
    public static final ConditionType MOB_EFFECT_EXISTS = SpecificRegistryContains.of("mob_effect_exists", BuiltInRegistries.f_256974_);
    public static final ConditionType POTION_EXISTS = SpecificRegistryContains.of("potion_exists", BuiltInRegistries.f_256980_);
    public static final ConditionType ATTRIBUTE_EXISTS = SpecificRegistryContains.of("attribute_exists", BuiltInRegistries.f_256951_);
    public static final ConditionType ENTITY_EXISTS = SpecificRegistryContains.of("entity_exists", BuiltInRegistries.f_256780_);
    public static final ConditionType BLOCK_ENTITY_EXISTS = SpecificRegistryContains.of("block_entity_exists", BuiltInRegistries.f_257049_);

    @Nullable
    public static ConditionType getType(ResourceLocation id) {
        return CONDITION_TYPES.get(id);
    }

    public static <T extends ILoadCondition> ConditionType register(ResourceLocation id, Codec<T> codec) {
        if (CONDITION_TYPES.containsKey(id)) {
            Constants.LOG.warn("JSON Load Serializer ID {} has already been assigned to {}. Replacing with {}.", new Object[]{id, CONDITION_TYPES.get(id).codec(), codec});
        }
        ConditionType type = new ConditionType(id, codec);
        CONDITION_TYPES.put(id, type);
        return type;
    }

    public static ILoadCondition[] getConditions(JsonElement conditionData) {
        return (ILoadCondition[])((Pair)BookshelfCodecs.LOAD_CONDITION.getArray().decode((DynamicOps)JsonOps.INSTANCE, (Object)conditionData).getOrThrow(false, error -> Constants.LOG.error("Failed to load conditions. Error: {}", error))).getFirst();
    }

    public static boolean canLoad(JsonObject rawJson) {
        if (rawJson.has("bookshelf:load_conditions")) {
            JsonElement conditionData = rawJson.get("bookshelf:load_conditions");
            for (ILoadCondition condition : LoadConditions.getConditions(conditionData)) {
                if (condition.allowLoading()) continue;
                return false;
            }
        }
        return true;
    }

    public record ConditionType(ResourceLocation id, Codec<? extends ILoadCondition> codec) {
    }
}

