/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.data.codecs;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.data.codecs.CodecHelper;
import net.darkhax.bookshelf.api.data.codecs.RegistryCodecHelper;
import net.darkhax.bookshelf.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.api.data.conditions.LoadConditions;
import net.darkhax.bookshelf.api.data.sound.Sound;
import net.darkhax.bookshelf.api.util.TextHelper;
import net.darkhax.bookshelf.mixin.accessors.effect.AccessorMobEffectInstance;
import net.minecraft.Optionull;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatType;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import org.apache.commons.lang3.EnumUtils;
import org.joml.Vector3f;

public class BookshelfCodecs {
    public static final CodecHelper<Boolean> BOOLEAN = new CodecHelper<Boolean>((Codec<Boolean>)Codec.BOOL, (T[])new Boolean[0]);
    public static final CodecHelper<Byte> BYTE = new CodecHelper<Byte>((Codec<Byte>)Codec.BYTE, (T[])new Byte[0]);
    public static final CodecHelper<Short> SHORT = new CodecHelper<Short>((Codec<Short>)Codec.SHORT, (T[])new Short[0]);
    public static final CodecHelper<Integer> INT = new CodecHelper<Integer>((Codec<Integer>)Codec.INT, (T[])new Integer[0]);
    public static final CodecHelper<Float> FLOAT = new CodecHelper<Float>((Codec<Float>)Codec.FLOAT, (T[])new Float[0]);
    public static final CodecHelper<Long> LONG = new CodecHelper<Long>((Codec<Long>)Codec.LONG, (T[])new Long[0]);
    public static final CodecHelper<Double> DOUBLE = new CodecHelper<Double>((Codec<Double>)Codec.DOUBLE, (T[])new Double[0]);
    public static final CodecHelper<String> STRING = new CodecHelper<String>((Codec<String>)Codec.STRING, (T[])new String[0]);
    public static final CodecHelper<UUID> UUID = new CodecHelper<UUID>(UUIDUtil.f_235867_, new UUID[0]);
    public static final RegistryCodecHelper<GameEvent> GAME_EVENT = new RegistryCodecHelper(BuiltInRegistries.f_256726_);
    public static final RegistryCodecHelper<SoundEvent> SOUND_EVENT = new RegistryCodecHelper(BuiltInRegistries.f_256894_);
    public static final RegistryCodecHelper<Fluid> FLUID = new RegistryCodecHelper(BuiltInRegistries.f_257020_);
    public static final RegistryCodecHelper<MobEffect> MOB_EFFECT = new RegistryCodecHelper(BuiltInRegistries.f_256974_);
    public static final RegistryCodecHelper<Block> BLOCK = new RegistryCodecHelper(BuiltInRegistries.f_256975_);
    public static final RegistryCodecHelper<Enchantment> ENCHANTMENT = new RegistryCodecHelper(BuiltInRegistries.f_256876_);
    public static final RegistryCodecHelper<EntityType<?>> ENTITY_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256780_);
    public static final RegistryCodecHelper<Item> ITEM = new RegistryCodecHelper(BuiltInRegistries.f_257033_);
    public static final RegistryCodecHelper<Potion> POTION = new RegistryCodecHelper(BuiltInRegistries.f_256980_);
    public static final RegistryCodecHelper<ParticleType<?>> PARTICLE_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_257034_);
    public static final RegistryCodecHelper<BlockEntityType<?>> BLOCK_ENTITY_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_257049_);
    public static final RegistryCodecHelper<PaintingVariant> PAINTING_VARIANT = new RegistryCodecHelper(BuiltInRegistries.f_257051_);
    public static final RegistryCodecHelper<ResourceLocation> CUSTOM_STAT = new RegistryCodecHelper(BuiltInRegistries.f_256771_);
    public static final RegistryCodecHelper<ChunkStatus> CHUNK_STATUS = new RegistryCodecHelper(BuiltInRegistries.f_256940_);
    public static final RegistryCodecHelper<RuleTestType<?>> RULE_TEST = new RegistryCodecHelper(BuiltInRegistries.f_256978_);
    public static final RegistryCodecHelper<RuleBlockEntityModifierType<?>> RULE_BLOCK_ENTITY_MODIFIER = new RegistryCodecHelper(BuiltInRegistries.f_276464_);
    public static final RegistryCodecHelper<PosRuleTestType<?>> POS_RULE_TEST = new RegistryCodecHelper(BuiltInRegistries.f_256957_);
    public static final RegistryCodecHelper<MenuType<?>> MENU = new RegistryCodecHelper(BuiltInRegistries.f_256818_);
    public static final RegistryCodecHelper<RecipeType<?>> RECIPE_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256990_);
    public static final RegistryCodecHelper<RecipeSerializer<?>> RECIPE_SERIALIZER = new RegistryCodecHelper(BuiltInRegistries.f_256769_);
    public static final RegistryCodecHelper<Attribute> ATTRIBUTE = new RegistryCodecHelper(BuiltInRegistries.f_256951_);
    public static final RegistryCodecHelper<PositionSourceType<?>> POSITION_SOURCE_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256972_);
    public static final RegistryCodecHelper<ArgumentTypeInfo<?, ?>> ARGUMENT_TYPE_INFO_CODEC_HELPER = new RegistryCodecHelper(BuiltInRegistries.f_256979_);
    public static final RegistryCodecHelper<StatType<?>> STAT_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256899_);
    public static final RegistryCodecHelper<VillagerType> VILLAGER_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256934_);
    public static final RegistryCodecHelper<VillagerProfession> VILLAGER_PROFESSION = new RegistryCodecHelper(BuiltInRegistries.f_256735_);
    public static final RegistryCodecHelper<PoiType> POINT_OF_INTEREST_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256941_);
    public static final RegistryCodecHelper<MemoryModuleType<?>> MEMORY_MODULE_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256784_);
    public static final RegistryCodecHelper<SensorType<?>> SENSOR_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256733_);
    public static final RegistryCodecHelper<Schedule> SCHEDULE = new RegistryCodecHelper(BuiltInRegistries.f_256962_);
    public static final RegistryCodecHelper<Activity> ACTIVITY = new RegistryCodecHelper(BuiltInRegistries.f_256785_);
    public static final RegistryCodecHelper<LootPoolEntryType> LOOT_POOL_ENTRY_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_257035_);
    public static final RegistryCodecHelper<LootItemFunctionType> LOOT_FUNCTION_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256753_);
    public static final RegistryCodecHelper<LootItemConditionType> LOOT_CONDITION_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256991_);
    public static final RegistryCodecHelper<LootNumberProviderType> LOOT_NUMBER_PROVIDER_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_257029_);
    public static final RegistryCodecHelper<LootNbtProviderType> LOOT_NBT_PROVIDER_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256736_);
    public static final RegistryCodecHelper<LootScoreProviderType> LOOT_SCORE_PROVIDER_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256719_);
    public static final RegistryCodecHelper<FloatProviderType<?>> FLOAT_PROVIDER_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256926_);
    public static final RegistryCodecHelper<IntProviderType<?>> INT_PROVIDER_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256942_);
    public static final RegistryCodecHelper<HeightProviderType<?>> HEIGHT_PROVIDER_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256870_);
    public static final RegistryCodecHelper<BlockPredicateType<?>> BLOCK_PREDICATE_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256906_);
    public static final RegistryCodecHelper<WorldCarver<?>> CARVER = new RegistryCodecHelper(BuiltInRegistries.f_257001_);
    public static final RegistryCodecHelper<Feature<?>> FEATURE = new RegistryCodecHelper(BuiltInRegistries.f_256810_);
    public static final RegistryCodecHelper<StructurePlacementType<?>> STRUCTURE_PLACEMENT = new RegistryCodecHelper(BuiltInRegistries.f_256950_);
    public static final RegistryCodecHelper<StructurePieceType> STRUCTURE_PIECE = new RegistryCodecHelper(BuiltInRegistries.f_257014_);
    public static final RegistryCodecHelper<StructureType<?>> STRUCTURE_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256763_);
    public static final RegistryCodecHelper<PlacementModifierType<?>> PLACEMENT_MODIFIER_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256986_);
    public static final RegistryCodecHelper<BlockStateProviderType<?>> BLOCKSTATE_PROVIDER_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256760_);
    public static final RegistryCodecHelper<FoliagePlacerType<?>> FOLIAGE_PLACER_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256861_);
    public static final RegistryCodecHelper<TrunkPlacerType<?>> TRUNK_PLACER_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256920_);
    public static final RegistryCodecHelper<RootPlacerType<?>> ROOT_PLACER_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256742_);
    public static final RegistryCodecHelper<TreeDecoratorType<?>> TREE_DECORATOR_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256987_);
    public static final RegistryCodecHelper<FeatureSizeType<?>> FEATURE_SIZE_TYPE = new RegistryCodecHelper(BuiltInRegistries.f_256958_);
    public static final RegistryCodecHelper<StructureProcessorType<?>> STRUCTURE_PROCESSOR = new RegistryCodecHelper(BuiltInRegistries.f_256897_);
    public static final RegistryCodecHelper<StructurePoolElementType<?>> STRUCTURE_POOL_ELEMENT = new RegistryCodecHelper(BuiltInRegistries.f_256846_);
    public static final RegistryCodecHelper<CatVariant> CAT_VARIANT = new RegistryCodecHelper(BuiltInRegistries.f_256754_);
    public static final RegistryCodecHelper<FrogVariant> FROG_VARIANT = new RegistryCodecHelper(BuiltInRegistries.f_256770_);
    public static final RegistryCodecHelper<BannerPattern> BANNER_PATTERN = new RegistryCodecHelper(BuiltInRegistries.f_256878_);
    public static final RegistryCodecHelper<Instrument> INSTRUMENT = new RegistryCodecHelper(BuiltInRegistries.f_256896_);
    public static final RegistryCodecHelper<String> DECORATED_POT_PATTERNS = new RegistryCodecHelper(BuiltInRegistries.f_271353_);
    public static final RegistryCodecHelper<CreativeModeTab> CREATIVE_MODE_TAB = new RegistryCodecHelper(BuiltInRegistries.f_279662_);
    public static final CodecHelper<Rarity> ITEM_RARITY = new CodecHelper<Rarity>(BookshelfCodecs.enumerable(Rarity.class), new Rarity[0]);
    public static final CodecHelper<Enchantment.Rarity> ENCHANTMENT_RARITY = new CodecHelper<Enchantment.Rarity>(BookshelfCodecs.enumerable(Enchantment.Rarity.class), new Enchantment.Rarity[0]);
    public static final CodecHelper<AttributeModifier.Operation> ATTRIBUTE_OPERATION = new CodecHelper<AttributeModifier.Operation>(AttributeModifier.Operation.f_290595_, new AttributeModifier.Operation[0]);
    public static final CodecHelper<Direction> DIRECTION = new CodecHelper<Direction>(BookshelfCodecs.enumerable(Direction.class), new Direction[0]);
    public static final CodecHelper<Direction.Axis> AXIS = new CodecHelper<Direction.Axis>(BookshelfCodecs.enumerable(Direction.Axis.class), new Direction.Axis[0]);
    public static final CodecHelper<Direction.Plane> PLANE = new CodecHelper<Direction.Plane>(BookshelfCodecs.enumerable(Direction.Plane.class), new Direction.Plane[0]);
    public static final CodecHelper<MobCategory> MOB_CATEGORY = new CodecHelper<MobCategory>(BookshelfCodecs.enumerable(MobCategory.class), new MobCategory[0]);
    public static final CodecHelper<EnchantmentCategory> ENCHANTMENT_CATEGORY = new CodecHelper<EnchantmentCategory>(BookshelfCodecs.enumerable(EnchantmentCategory.class), new EnchantmentCategory[0]);
    public static final CodecHelper<DyeColor> DYE_COLOR = new CodecHelper<DyeColor>(BookshelfCodecs.enumerable(DyeColor.class), new DyeColor[0]);
    public static final CodecHelper<SoundSource> SOUND_SOURCE = new CodecHelper<SoundSource>(BookshelfCodecs.enumerable(SoundSource.class), new SoundSource[0]);
    public static final CodecHelper<ArmorMaterials> ARMOR_MATERIAL = new CodecHelper<ArmorMaterials>(BookshelfCodecs.enumerable(ArmorMaterials.class), new ArmorMaterials[0]);
    public static final CodecHelper<Difficulty> DIFFICULTY = new CodecHelper<Difficulty>(BookshelfCodecs.enumerable(Difficulty.class), new Difficulty[0]);
    public static final CodecHelper<EquipmentSlot> EQUIPMENT_SLOT = new CodecHelper<EquipmentSlot>(BookshelfCodecs.enumerable(EquipmentSlot.class), new EquipmentSlot[0]);
    public static final CodecHelper<Mirror> MIRROR = new CodecHelper<Mirror>(BookshelfCodecs.enumerable(Mirror.class), new Mirror[0]);
    public static final CodecHelper<Rotation> ROTATION = new CodecHelper<Rotation>(BookshelfCodecs.enumerable(Rotation.class), new Rotation[0]);
    public static final CodecHelper<ResourceLocation> RESOURCE_LOCATION = new CodecHelper<ResourceLocation>(ResourceLocation.f_135803_, new ResourceLocation[0]);
    public static final CodecHelper<CompoundTag> COMPOUND_TAG = new CodecHelper<CompoundTag>(CompoundTag.f_128325_, new CompoundTag[0]);
    public static final CodecHelper<ItemStack> ITEM_STACK = new CodecHelper<ItemStack>(RecordCodecBuilder.create(instance -> instance.group(ITEM.get("item", ItemStack::m_41720_), INT.get("count", ItemStack::m_41613_, 1), COMPOUND_TAG.getOptional("nbt", stack -> stack.m_41782_() ? Optional.ofNullable(stack.m_41783_()) : Optional.empty())).apply((Applicative)instance, (item, count, nbt) -> {
        ItemStack stack = new ItemStack((ItemLike)item, count.intValue());
        nbt.ifPresent(arg_0 -> ((ItemStack)stack).m_41751_(arg_0));
        return stack;
    })), new ItemStack[0]);
    public static final CodecHelper<ItemStack> ITEM_STACK_FLEXIBLE = new CodecHelper<ItemStack>(BookshelfCodecs.alternatives(ITEM.get().xmap(Item::m_7968_, ItemStack::m_41720_), ITEM_STACK.get(), stack -> stack.m_41782_() || stack.m_41613_() != 1 ? Either.right((Object)stack) : Either.left((Object)stack)), new ItemStack[0]);
    public static final CodecHelper<Component> TEXT = new CodecHelper<Component>(ComponentSerialization.f_303288_, new Component[0]);
    public static final CodecHelper<BlockPos> BLOCK_POS = new CodecHelper<BlockPos>(BlockPos.f_121852_, new BlockPos[0]);
    public static final CodecHelper<Ingredient> INGREDIENT = new CodecHelper<Ingredient>(Ingredient.f_291570_, new Ingredient[0]);
    public static final CodecHelper<Ingredient> INGREDIENT_NONEMPTY = new CodecHelper<Ingredient>(Ingredient.f_290991_, new Ingredient[0]);
    public static final MapCodec<BlockState> BLOCK_STATE_MAP_CODEC = Codec.mapPair((MapCodec)BLOCK.get().fieldOf("block"), (MapCodec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("properties")).flatXmap(BookshelfCodecs::decodeBlockState, BookshelfCodecs::encodeBlockState);
    public static final CodecHelper<BlockState> BLOCK_STATE = new CodecHelper<BlockState>(BLOCK_STATE_MAP_CODEC.codec(), new BlockState[0]);
    public static final CodecHelper<AttributeModifier> ATTRIBUTE_MODIFIER = new CodecHelper<AttributeModifier>(AttributeModifier.f_303618_, new AttributeModifier[0]);
    public static final CodecHelper<MobEffectInstance> EFFECT_INSTANCE = new CodecHelper<MobEffectInstance>(RecordCodecBuilder.create(instance -> instance.group(MOB_EFFECT.get("effect", MobEffectInstance::m_19544_), INT.get("duration", MobEffectInstance::m_19557_, 20), INT.get("amplifier", MobEffectInstance::m_19564_, 0), BOOLEAN.get("ambient", MobEffectInstance::m_19571_, false), BOOLEAN.get("visible", MobEffectInstance::m_19572_, true), BOOLEAN.get("showIcon", MobEffectInstance::m_19575_, true)).apply((Applicative)instance, MobEffectInstance::new)), new MobEffectInstance[0]);
    public static final CodecHelper<MobEffectInstance> EFFECT_INSTANCE_WITH_HIDDEN = new CodecHelper<MobEffectInstance>(RecordCodecBuilder.create(instance -> instance.group(MOB_EFFECT.get("effect", MobEffectInstance::m_19544_), INT.get("duration", MobEffectInstance::m_19557_, 20), INT.get("amplifier", MobEffectInstance::m_19564_, 0), BOOLEAN.get("ambient", MobEffectInstance::m_19571_, false), BOOLEAN.get("visible", MobEffectInstance::m_19572_, true), BOOLEAN.get("showIcon", MobEffectInstance::m_19575_, true), EFFECT_INSTANCE.getOptional("hiddenEffect", toWrite -> Optional.ofNullable(((AccessorMobEffectInstance)toWrite).bookshelf$getHiddenEffect()))).apply((Applicative)instance, (effect, duration, amplifier, ambient, visible, showIcon, hidden) -> new MobEffectInstance(effect, duration.intValue(), amplifier.intValue(), ambient.booleanValue(), visible.booleanValue(), showIcon.booleanValue(), (MobEffectInstance)hidden.orElse(null), effect.m_216881_()))), new MobEffectInstance[0]);
    public static final CodecHelper<EnchantmentInstance> ENCHANTMENT_INSTANCE = new CodecHelper<EnchantmentInstance>(RecordCodecBuilder.create(instance -> instance.group(ENCHANTMENT.get("enchantment", enchInst -> enchInst.f_44947_), INT.get("level", enchInst -> enchInst.f_44948_, 1)).apply((Applicative)instance, EnchantmentInstance::new)), new EnchantmentInstance[0]);
    public static CodecHelper<Vector3f> VECTOR_3F = new CodecHelper<Vector3f>(ExtraCodecs.f_252432_, new Vector3f[0]);
    public static CodecHelper<ILoadCondition> LOAD_CONDITION = LoadConditions.CODEC_HELPER;
    public static CodecHelper<Sound> SOUND = new CodecHelper<Sound>(Sound.CODEC, new Sound[0]);

    public static <T> Codec<T> registry(Registry<T> registry) {
        return ResourceLocation.f_135803_.flatXmap(id -> Optional.ofNullable(registry.m_7804_(id) ? registry.m_7745_(id) : null).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in " + registry.m_123023_() + ": " + id)), value -> registry.m_7854_(value).map(ResourceKey::m_135782_).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry element in " + registry.m_123023_() + ": " + value)));
    }

    public static <T> Codec<List<T>> flexibleList(Codec<T> codec) {
        return ExtraCodecs.m_294448_((Codec)codec.listOf(), codec).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right(list.get(0)) : Either.left((Object)list));
    }

    public static <T> Codec<Set<T>> flexibleSet(Codec<T> codec) {
        return BookshelfCodecs.flexibleList(codec).xmap(LinkedHashSet::new, ArrayList::new);
    }

    public static <T> Codec<T[]> flexibleArray(Codec<T> codec, IntFunction<T[]> arrayBuilder) {
        return BookshelfCodecs.flexibleList(codec).xmap(list -> list.toArray((Object[])arrayBuilder.apply(list.size())), List::of);
    }

    public static <T> MapCodec<T> fallback(Codec<T> codec, String name, Supplier<T> fallbackSupplier) {
        return BookshelfCodecs.fallback(codec, name, fallbackSupplier, true);
    }

    public static <T> MapCodec<Optional<T>> optional(Codec<T> codec, String name, Optional<T> fallback, boolean writesDefault) {
        return Codec.optionalField((String)name, codec).xmap(o -> o.isPresent() ? o : fallback, a -> a.isEmpty() || Objects.equals(a.get(), fallback.orElse(null)) && !writesDefault ? Optional.empty() : a);
    }

    public static <T> MapCodec<T> nullable(Codec<T> codec, String fieldName) {
        return Codec.optionalField((String)fieldName, codec).xmap(optional -> optional.orElse(null), Optional::ofNullable);
    }

    public static <T> MapCodec<T> fallback(Codec<T> codec, String name, Supplier<T> fallbackSupplier, boolean writesDefault) {
        return Codec.optionalField((String)name, codec).xmap(value -> value.orElse(fallbackSupplier.get()), value -> {
            Object fallback = fallbackSupplier.get();
            return Objects.equals(value, fallback) && !writesDefault ? Optional.empty() : Optional.of(value);
        });
    }

    public static <T extends Enum<T>> Codec<T> enumerable(Class<T> enumClass) {
        Map enumValues = EnumUtils.getEnumMap(enumClass);
        Function<String, Enum> fromString = name -> {
            Enum value = (Enum)enumValues.get(name);
            if (value == null) {
                value = (Enum)enumValues.get(name.toUpperCase(Locale.ROOT));
            }
            return value;
        };
        UnaryOperator errorMessage = name -> {
            StringJoiner message = new StringJoiner(" ");
            message.add("Unable to find " + enumClass.getSimpleName() + " entry \"" + name + "\".");
            Set<String> similarMatches = TextHelper.getPossibleMatches(name, enumValues.keySet(), 2);
            if (!similarMatches.isEmpty()) {
                message.add("Did you mean \"" + (String)similarMatches.stream().findFirst().get() + "\"?");
            }
            message.add("Available Options are " + TextHelper.formatCollection(enumValues.keySet()));
            return message.toString();
        };
        return Codec.STRING.flatXmap(string -> (DataResult)Optionull.m_269543_((Object)((Enum)fromString.apply((String)string)), DataResult::success, () -> DataResult.error(() -> (String)errorMessage.apply(string))), object -> DataResult.success((Object)object.name()));
    }

    public static <T, V> Codec<V> dispatchFallback(Codec<T> typeCodec, Function<V, T> getSerializer, Function<T, Codec<V>> getCodec, Supplier<Codec<V>> fallbackCodec) {
        return ExtraCodecs.m_184415_(() -> ExtraCodecs.m_294448_((Codec)typeCodec.dispatch(getSerializer, getCodec), (Codec)((Codec)fallbackCodec.get())).flatComapMap(resultingCodec -> resultingCodec.left().isPresent() ? resultingCodec.left().get() : resultingCodec.right().get(), resultingValue -> DataResult.success((Object)Either.left((Object)resultingValue))));
    }

    public static <T> Codec<T> alternatives(Codec<T> first, Codec<T> second, Function<T, Either<T, T>> encodeLogic) {
        return ExtraCodecs.m_294448_(first, second).flatComapMap(decodeResults -> decodeResults.left().isPresent() ? decodeResults.left().get() : decodeResults.right().get(), toEncode -> DataResult.success((Object)((Either)encodeLogic.apply(toEncode))));
    }

    private static DataResult<BlockState> decodeBlockState(Pair<Block, Optional<Map<String, String>>> props) {
        Block block = (Block)props.getFirst();
        Map properties = ((Optional)props.getSecond()).orElse(new HashMap());
        BlockState state = block.m_49966_();
        if (!properties.isEmpty()) {
            StateDefinition definition = block.m_49965_();
            for (Map.Entry entry : properties.entrySet()) {
                Property property = definition.m_61081_((String)entry.getKey());
                if (property != null) {
                    Optional value = property.m_6215_((String)entry.getValue());
                    if (value.isPresent()) {
                        try {
                            state = (BlockState)state.m_61124_(property, (Comparable)value.get());
                            continue;
                        }
                        catch (Exception e) {
                            Constants.LOG.error("Failed to update state for block {} with valid value {}={}. The mod that adds this block may have a serious issue.", new Object[]{BuiltInRegistries.f_256975_.m_7981_((Object)block), entry.getKey(), entry.getValue()});
                            return DataResult.error(e::getMessage);
                        }
                    }
                    return DataResult.error(() -> "\"" + (String)entry.getValue() + "\" is not a valid value for property \"" + property.m_61708_() + "\" on block \"" + BuiltInRegistries.f_256975_.m_7981_((Object)block) + "\". Available values: " + property.m_61702_().map(propVal -> property.m_6940_(propVal.f_61713_())).collect(Collectors.joining()));
                }
                return DataResult.error(() -> "The property \"" + (String)entry.getKey() + "\" is not valid for block \"" + BuiltInRegistries.f_256975_.m_7981_((Object)block) + "\". Available properties: " + definition.m_61092_().stream().map(Property::m_61708_).collect(Collectors.joining()));
            }
        }
        return DataResult.success((Object)state);
    }

    private static DataResult<Pair<Block, Optional<Map<String, String>>>> encodeBlockState(BlockState state) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (Map.Entry entry : state.m_61148_().entrySet()) {
            propertyMap.put(((Property)entry.getKey()).m_61708_(), ((Property)entry.getKey()).m_6940_((Comparable)entry.getValue()));
        }
        return DataResult.success((Object)new Pair((Object)state.m_60734_(), Optional.ofNullable(propertyMap.isEmpty() ? null : propertyMap)));
    }
}

