/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.data.bytebuf;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.mixin.accessors.util.random.AccessorWeightedRandomList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;

public class ByteBufHelper<T> {
    private final Function<FriendlyByteBuf, T> fromBytes;
    private final BiConsumer<FriendlyByteBuf, T> toBytes;
    private final IntFunction<T[]> arrayBuilder;

    public ByteBufHelper(Function<FriendlyByteBuf, T> reader, BiConsumer<FriendlyByteBuf, T> writer, T ... vargs) {
        this.fromBytes = reader;
        this.toBytes = writer;
        this.arrayBuilder = size -> (Object[])Array.newInstance(vargs.getClass().getComponentType(), size);
    }

    public T read(FriendlyByteBuf buffer) {
        return this.fromBytes.apply(buffer);
    }

    public void write(FriendlyByteBuf buffer, T toWrite) {
        this.toBytes.accept(buffer, (FriendlyByteBuf)toWrite);
    }

    public T[] readArray(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        T[] array = this.arrayBuilder.apply(size);
        for (int i = 0; i < size; ++i) {
            array[i] = this.read(buffer);
        }
        return array;
    }

    public void writeArray(FriendlyByteBuf buffer, T[] array) {
        buffer.writeInt(array.length);
        for (T value : array) {
            this.write(buffer, value);
        }
    }

    public <C extends Collection<T>> C readCollection(FriendlyByteBuf buffer, Supplier<C> collectionSupplier) {
        int size = buffer.readInt();
        Collection elements = (Collection)collectionSupplier.get();
        for (int i = 0; i < size; ++i) {
            elements.add(this.read(buffer));
        }
        return (C)elements;
    }

    public void writeCollection(FriendlyByteBuf buffer, Collection<T> collection) {
        buffer.writeInt(collection.size());
        collection.forEach(entry -> this.write(buffer, entry));
    }

    public List<T> readList(FriendlyByteBuf buffer) {
        return this.readCollection(buffer, ArrayList::new);
    }

    public void writeList(FriendlyByteBuf buffer, List<T> toWrite) {
        this.writeCollection(buffer, toWrite);
    }

    public Set<T> readSet(FriendlyByteBuf buffer) {
        return this.readCollection(buffer, LinkedHashSet::new);
    }

    public void writeSet(FriendlyByteBuf buffer, Set<T> toWrite) {
        this.writeCollection(buffer, toWrite);
    }

    public Optional<T> readOptional(FriendlyByteBuf buffer) {
        return buffer.readBoolean() ? Optional.of(this.read(buffer)) : Optional.empty();
    }

    public void writeOptional(FriendlyByteBuf buffer, Optional<T> optional) {
        boolean isPresent = optional.isPresent();
        buffer.writeBoolean(isPresent);
        if (isPresent) {
            this.write(buffer, optional.get());
        }
    }

    @Nullable
    public T readNullable(FriendlyByteBuf buffer) {
        return buffer.readBoolean() ? (T)this.read(buffer) : null;
    }

    public void writeNullable(FriendlyByteBuf buffer, @Nullable T value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            this.write(buffer, value);
        }
    }

    public WeightedEntry.Wrapper<T> readWeighted(FriendlyByteBuf buffer) {
        T value = this.read(buffer);
        int weight = BookshelfByteBufs.INT.read(buffer);
        return WeightedEntry.m_146290_(value, (int)weight);
    }

    public void writeWeighted(FriendlyByteBuf buffer, WeightedEntry.Wrapper<T> toWrite) {
        this.write(buffer, toWrite.m_146310_());
        BookshelfByteBufs.INT.write(buffer, toWrite.m_142631_().m_146281_());
    }

    public SimpleWeightedRandomList<T> readWeightedList(FriendlyByteBuf buffer) {
        SimpleWeightedRandomList.Builder list = SimpleWeightedRandomList.m_146263_();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            WeightedEntry.Wrapper<T> wrapped = this.readWeighted(buffer);
            list.m_146271_(wrapped.m_146310_(), wrapped.m_142631_().m_146281_());
        }
        return list.m_146270_();
    }

    public void writeWeightedList(FriendlyByteBuf buffer, SimpleWeightedRandomList<T> list) {
        AccessorWeightedRandomList accessor = (AccessorWeightedRandomList)list;
        buffer.writeInt(accessor.bookshelf$getEntries().size());
        for (WeightedEntry.Wrapper entry : accessor.bookshelf$getEntries()) {
            this.writeWeighted(buffer, entry);
        }
    }
}

