/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.packedup.BackpackContainer;
import com.supermartijn642.packedup.BackpackInventory;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackStorageManager;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.PackedUpConfig;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PackedUpCommon {
    public static void openBackpackInventory(ItemStack stack, Player player, int bagSlot) {
        BackpackType type = ((BackpackItem)stack.m_41720_()).type;
        MutableComponent name = TextComponents.itemStack((ItemStack)stack).get();
        CompoundTag compound = stack.m_41784_();
        if (!compound.m_128441_("packedup:invIndex") || BackpackStorageManager.getInventory(compound.m_128451_("packedup:invIndex")) == null) {
            compound.m_128405_("packedup:invIndex", BackpackStorageManager.createInventoryIndex(type));
            stack.m_41751_(compound);
        } else {
            BackpackStorageManager.getInventory(compound.m_128451_("packedup:invIndex")).adjustSize(type);
        }
        int inventoryIndex = compound.m_128451_("packedup:invIndex");
        BackpackInventory inventory = BackpackStorageManager.getInventory(inventoryIndex);
        CommonUtils.openContainer((BaseContainer)new BackpackContainer(player, bagSlot, (Component)name, inventoryIndex, type, inventory.bagsInThisBag, inventory.bagsThisBagIsIn, inventory.layer));
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDropsEvent e) {
        List<ItemEntity> stacksToBeSaved;
        if (e.getEntity() instanceof Player && PackedUpConfig.keepBackpacksOnDeath.get().booleanValue() && !e.isCanceled() && !(stacksToBeSaved = e.getDrops().stream().filter(itemEntity -> itemEntity.m_6084_() && !itemEntity.m_32055_().m_41619_() && itemEntity.m_32055_().m_41720_() instanceof BackpackItem).collect(Collectors.toList())).isEmpty()) {
            stacksToBeSaved.forEach(e.getDrops()::remove);
            ListTag itemData = new ListTag();
            stacksToBeSaved.stream().map(ItemEntity::m_32055_).forEach(stack -> itemData.add((Object)stack.serializeNBT()));
            e.getEntity().getPersistentData().m_128365_("packedup:backpacks", (Tag)itemData);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone e) {
        if (e.getOriginal().getPersistentData().m_128425_("packedup:backpacks", 9)) {
            ListTag itemData = e.getOriginal().getPersistentData().m_128437_("packedup:backpacks", 10);
            itemData.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).map(ItemStack::m_41712_).forEach(stack -> e.getEntity().m_150109_().m_150079_(stack));
        }
    }
}

