/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.packedup.BackpackInventory;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackStorageManager;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.PackedUp;
import com.supermartijn642.packedup.PackedUpCommon;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class BackpackContainer
extends BaseContainer {
    public final BackpackType type;
    public final int bagSlot;
    public final Component bagName;
    public final BackpackInventory inventory;

    public BackpackContainer(Player player, int bagSlot, Component bagName, int inventoryIndex, BackpackType type, Set<Integer> bagsInThisBag, Set<Integer> bagsThisBagIsIn, int layer) {
        super(PackedUp.container, player);
        this.bagSlot = bagSlot;
        this.bagName = bagName;
        this.type = type;
        this.inventory = player.m_9236_().f_46443_ ? new BackpackInventory(true, inventoryIndex, type.getSlots(), bagsInThisBag, bagsThisBagIsIn, layer) : BackpackStorageManager.getInventory(inventoryIndex);
        this.addSlots();
    }

    protected void addSlots(Player player) {
        int startX = Math.max(0, 9 - this.type.getColumns()) * 18 / 2 + 8;
        int startY = 17;
        for (int row = 0; row < this.type.getRows(); ++row) {
            for (int column = 0; column < this.type.getColumns(); ++column) {
                int x = startX + 18 * column;
                int y = startY + 18 * row;
                int index = row * this.type.getColumns() + column;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, index, x, y));
            }
        }
        startX = Math.max(0, this.type.getColumns() - 9) * 18 / 2 + 8;
        this.addPlayerSlots(startX, startY += this.type.getRows() * 18 + 13);
    }

    protected void addPlayerSlots(int x, int y) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                if (this.bagSlot == row * 9 + column + 9) {
                    this.m_38897_(new Slot((Container)this.player.m_150109_(), row * 9 + column + 9, x + 18 * column, y + 18 * row){

                        public boolean m_8010_(Player player) {
                            return false;
                        }
                    });
                    continue;
                }
                this.m_38897_(new Slot((Container)this.player.m_150109_(), row * 9 + column + 9, x + 18 * column, y + 18 * row));
            }
        }
        for (int column = 0; column < 9; ++column) {
            if (this.bagSlot == column) {
                this.m_38897_(new Slot((Container)this.player.m_150109_(), column, x + 18 * column, y + 58){

                    public boolean m_8010_(Player player) {
                        return false;
                    }
                });
                continue;
            }
            this.m_38897_(new Slot((Container)this.player.m_150109_(), column, x + 18 * column, y + 58));
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack returnStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            returnStack = slotStack.m_41777_();
            if (index < this.type.getSlots() ? !this.m_38903_(slotStack, this.type.getSlots(), this.f_38839_.size(), true) : !this.m_38903_(slotStack, 0, this.type.getSlots(), false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return returnStack;
    }

    public void m_150399_(int index, int dragType, ClickType clickType, Player player) {
        ItemStack stack;
        if (clickType == ClickType.SWAP && dragType == this.bagSlot) {
            return;
        }
        if (clickType == ClickType.PICKUP && dragType == 1 && index >= 0 && (stack = this.m_38853_(index).m_7993_()).m_41720_() instanceof BackpackItem) {
            int playerSlot = index - this.type.getSlots();
            if (playerSlot >= 0) {
                playerSlot += playerSlot < 27 ? 9 : -27;
            }
            if (!player.m_9236_().f_46443_) {
                PackedUpCommon.openBackpackInventory(stack, player, playerSlot < 0 ? this.bagSlot : playerSlot);
            }
            return;
        }
        super.m_150399_(index, dragType, clickType, player);
    }
}

