/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.iceberg.mixin;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import net.minecraft.network.chat.TextColor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TextColor.class})
public class TextColorMixin {
    @Shadow
    @Final
    @Mutable
    private int f_131257_;

    @Inject(method={"<init>(ILjava/lang/String;)V"}, at={@At(value="TAIL")}, require=0)
    private void icebergConstructor1(int originalValue, String originalName, CallbackInfo info) {
        this.f_131257_ = originalValue & 0xFFFFFFFF;
    }

    @Inject(method={"<init>(I)V"}, at={@At(value="TAIL")}, require=0)
    private void icebergConstructor2(int originalValue, CallbackInfo info) {
        this.f_131257_ = originalValue & 0xFFFFFFFF;
    }

    @Inject(method={"parseColor"}, at={@At(value="HEAD")}, cancellable=true, require=0)
    private static void icebergParseColor(String colorString, CallbackInfoReturnable<DataResult<TextColor>> info) {
        if (!colorString.startsWith("#")) {
            return;
        }
        try {
            int i = Integer.parseUnsignedInt(colorString.substring(1), 16);
            if (Integer.compareUnsigned(i, 0) >= 0 && Integer.compareUnsigned(i, -1) <= 0) {
                info.setReturnValue((Object)DataResult.success((Object)TextColor.m_131266_((int)i), (Lifecycle)Lifecycle.stable()));
            } else {
                info.setReturnValue((Object)DataResult.error(() -> "Color value out of range: " + colorString));
            }
        }
        catch (NumberFormatException numberformatexception) {
            info.setReturnValue((Object)DataResult.error(() -> "Invalid color value: " + colorString));
        }
    }
}

