/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.supermartijn642.configlib.ConfigLibClient;
import com.supermartijn642.configlib.ConfigSyncPacket;
import com.supermartijn642.configlib.ModConfig;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="supermartijn642configlib")
public class ConfigLib {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"configlib");
    protected static final ResourceLocation CHANNEL_ID = new ResourceLocation("supermartijn642configlib", "sync_configs");
    private static SimpleChannel channel;
    private static final List<ModConfig<?>> CONFIGS;
    private static final Set<String> CONFIG_NAMES;
    private static final List<ModConfig<?>> SYNCABLE_CONFIGS;
    private static final Map<String, ModConfig<?>> SYNCABLE_CONFIGS_BY_IDENTIFIER;

    public ConfigLib() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(ConfigLib::getModVersion, (remoteVersion, isFromServer) -> ConfigLib.canConnectWith(remoteVersion.hashCode())));
        MinecraftForge.EVENT_BUS.addListener(e -> ConfigLib.onLoadGame());
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.getEntity() instanceof ServerPlayer) {
                ConfigLib.onPlayerJoinServer((ServerPlayer)e.getEntity());
            }
        });
        if (ConfigLib.isClientEnvironment()) {
            ConfigLibClient.registerEventListeners();
        }
        channel = ChannelBuilder.named((ResourceLocation)CHANNEL_ID).networkProtocolVersion(ConfigLib.getModVersion().hashCode()).acceptedVersions((status, version) -> ConfigLib.canConnectWith(version)).simpleChannel();
        channel.messageBuilder(ConfigSyncPacket.class, 0).encoder(ConfigLib::createSyncedEntriesPacket).decoder(ConfigLib::handleSyncConfigPacket).consumerNetworkThread((packet, context) -> context.setPacketHandled(true)).add();
    }

    public static boolean isClientEnvironment() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public static boolean isServerEnvironment() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static String getModVersion() {
        return ((ModContainer)ModList.get().getModContainerById("supermartijn642configlib").orElseThrow()).getModInfo().getVersion().toString();
    }

    public static boolean canConnectWith(int remoteVersion) {
        return SYNCABLE_CONFIGS.isEmpty() || ConfigLib.getModVersion().hashCode() == remoteVersion;
    }

    public static File getConfigFolder() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    protected static synchronized void addConfig(ModConfig<?> config) {
        if (CONFIG_NAMES.contains(config.getIdentifier())) {
            throw new IllegalStateException("Config '" + config.getIdentifier() + "' for mod '" + config.getModid() + "' already exists!");
        }
        CONFIGS.add(config);
        CONFIG_NAMES.add(config.getIdentifier());
        if (config.hasSyncableEntries()) {
            SYNCABLE_CONFIGS.add(config);
            SYNCABLE_CONFIGS_BY_IDENTIFIER.put(config.getIdentifier(), config);
        }
        config.initialize();
    }

    protected static void onLoadGame() {
        CONFIGS.forEach(ModConfig::onJoinGame);
    }

    protected static void onLeaveGame() {
        CONFIGS.forEach(ModConfig::onLeaveGame);
    }

    protected static void onPlayerJoinServer(ServerPlayer sender) {
        ConfigLib.sendSyncConfigPackets(sender);
    }

    private static void sendSyncConfigPackets(ServerPlayer sender) {
        for (ModConfig<?> config : SYNCABLE_CONFIGS) {
            channel.send((Object)new ConfigSyncPacket(config), PacketDistributor.PLAYER.with((Object)sender));
        }
    }

    private static void createSyncedEntriesPacket(ConfigSyncPacket packet, FriendlyByteBuf buffer) {
        ModConfig<?> config = packet.config;
        buffer.m_130070_(config.getIdentifier());
        try {
            config.writeSyncableEntries((ByteBuf)buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write syncable config entries for config '" + config.getIdentifier() + "' from mod '" + config.getModid() + "'!", e);
        }
    }

    protected static ConfigSyncPacket handleSyncConfigPacket(FriendlyByteBuf buffer) {
        String identifier = buffer.m_130277_();
        ModConfig<?> config = SYNCABLE_CONFIGS_BY_IDENTIFIER.get(identifier);
        if (config == null) {
            LOGGER.error("Received config sync packet for unknown config '" + identifier + "'!");
            return null;
        }
        try {
            config.readSyncableValues((ByteBuf)buffer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read syncable config entries for config '" + config.getIdentifier() + "' from mod '" + config.getModid() + "'!", (Throwable)e);
        }
        return new ConfigSyncPacket();
    }

    static {
        CONFIGS = new ArrayList();
        CONFIG_NAMES = new HashSet<String>();
        SYNCABLE_CONFIGS = new ArrayList();
        SYNCABLE_CONFIGS_BY_IDENTIFIER = new HashMap();
    }
}

