/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.block.StringyCobwebBlock;
import biomesoplenty.block.properties.ConnectedProperty;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class StringyCobwebFeature
extends Feature<NoneFeatureConfiguration> {
    private static final int MIN_DISTANCE = 2;
    private static final int MAX_DISTANCE = 32;

    public StringyCobwebFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean canPlace(WorldGenLevel world, BlockPos pos, int length, Direction dir) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = world.m_8055_(belowPos);
        if (!(world.m_8055_(pos).m_60795_() && belowState.m_60783_((BlockGetter)world, belowPos, Direction.UP) && this.respectsCutoff((WorldGenRegion)world, pos))) {
            return false;
        }
        BlockPos nextStringPos = pos;
        for (int i = 0; i < length; ++i) {
            BlockState nextStringState = world.m_8055_(nextStringPos = nextStringPos.m_5484_(dir, 1).m_6630_(1));
            if (nextStringState.m_60795_() && this.respectsCutoff((WorldGenRegion)world, nextStringPos)) continue;
            return false;
        }
        BlockPos abovePos = nextStringPos.m_7494_();
        BlockState aboveState = world.m_8055_(abovePos);
        return aboveState.m_60783_((BlockGetter)world, abovePos, Direction.DOWN) && this.respectsCutoff((WorldGenRegion)world, nextStringPos);
    }

    public void placeCobweb(WorldGenLevel world, BlockPos pos, int length, Direction dir) {
        if (this.respectsCutoff((WorldGenRegion)world, pos)) {
            world.m_7731_(pos, (BlockState)((BlockState)BOPBlocks.STRINGY_COBWEB.m_49966_().m_61124_((Property)StringyCobwebBlock.FACING, (Comparable)dir)).m_61124_(StringyCobwebBlock.CONNECTED, (Comparable)((Object)ConnectedProperty.BOTTOM)), 2);
        }
        BlockPos nextStringPos = pos;
        for (int i = 0; i < length; ++i) {
            if (!this.respectsCutoff((WorldGenRegion)world, nextStringPos = nextStringPos.m_5484_(dir, 1).m_6630_(1))) continue;
            world.m_7731_(nextStringPos, (BlockState)((BlockState)BOPBlocks.STRINGY_COBWEB.m_49966_().m_61124_((Property)StringyCobwebBlock.FACING, (Comparable)dir)).m_61124_(StringyCobwebBlock.CONNECTED, (Comparable)((Object)ConnectedProperty.MIDDLE)), 2);
        }
        if (this.respectsCutoff((WorldGenRegion)world, nextStringPos)) {
            world.m_7731_(nextStringPos, (BlockState)((BlockState)BOPBlocks.STRINGY_COBWEB.m_49966_().m_61124_((Property)StringyCobwebBlock.FACING, (Comparable)dir)).m_61124_(StringyCobwebBlock.CONNECTED, (Comparable)((Object)ConnectedProperty.TOP)), 2);
        }
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.m_159774_();
        RandomSource rand = featurePlaceContext.m_225041_();
        BlockPos pos = featurePlaceContext.m_159777_();
        int k = 0;
        for (int j = 0; j < 128; ++j) {
            int length = 2 + rand.m_188503_(30);
            Direction dir = Direction.Plane.HORIZONTAL.m_235690_(rand);
            BlockPos blockPos = pos.m_7918_(rand.m_188503_(8) - rand.m_188503_(8), rand.m_188503_(4) - rand.m_188503_(4), rand.m_188503_(8) - rand.m_188503_(8));
            if (!this.canPlace(world, blockPos, length, dir)) continue;
            this.placeCobweb(world, blockPos, length, dir);
            ++k;
        }
        return k > 0;
    }

    private boolean respectsCutoff(WorldGenRegion region, BlockPos pos) {
        int i = SectionPos.m_123171_((int)pos.m_123341_());
        int j = SectionPos.m_123171_((int)pos.m_123343_());
        ChunkPos chunkpos = region.m_143488_();
        int k = Math.abs(chunkpos.f_45578_ - i);
        int l = Math.abs(chunkpos.f_45579_ - j);
        return k <= region.f_143481_ && l <= region.f_143481_;
    }
}

