/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.init;

import biomesoplenty.api.block.BOPBlockEntities;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.block.BOPFluids;
import biomesoplenty.api.block.BOPWoodTypes;
import biomesoplenty.api.entity.BOPEntities;
import biomesoplenty.client.renderer.AnomalyRenderer;
import biomesoplenty.client.renderer.BoatRendererBOP;
import biomesoplenty.entity.BoatBOP;
import biomesoplenty.init.ModParticles;
import biomesoplenty.particle.BinaryParticle;
import biomesoplenty.particle.DripParticleBOP;
import biomesoplenty.particle.EndSporeParticle;
import biomesoplenty.particle.GlowwormParticle;
import biomesoplenty.particle.LargeLeafParticle;
import biomesoplenty.particle.LeafParticle;
import biomesoplenty.particle.NullParticle;
import biomesoplenty.particle.PusParticle;
import biomesoplenty.particle.SteamParticle;
import biomesoplenty.particle.WispBubbleParticle;
import glitchcore.event.EventManager;
import glitchcore.event.client.RegisterColorsEvent;
import glitchcore.event.client.RegisterParticleSpritesEvent;
import glitchcore.util.RenderHelper;
import glitchcore.util.SheetHelper;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;

public class ModClient {
    public static void setup() {
        ModClient.setupRenderTypes();
        ModClient.registerRenderers();
        ModClient.registerWoodTypes();
    }

    public static void addClientHandlers() {
        EventManager.addListener(ModClient::registerBlockColors);
        EventManager.addListener(ModClient::registerItemColors);
        EventManager.addListener(ModClient::registerParticleSprites);
    }

    public static void setupRenderTypes() {
        RenderType transparentRenderType = RenderType.m_110457_();
        RenderType cutoutRenderType = RenderType.m_110463_();
        RenderType translucentRenderType = RenderType.m_110466_();
        RenderHelper.setRenderType((Block)BOPBlocks.MOSSY_BLACK_SAND, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.WISPJELLY, (RenderType)translucentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.NULL_END_STONE, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.NULL_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.NULL_PLANT, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.ORIGIN_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.FLOWERING_OAK_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.SNOWBLOSSOM_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.RAINBOW_BIRCH_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.FIR_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.PINE_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.RED_MAPLE_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.ORANGE_MAPLE_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.YELLOW_MAPLE_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.REDWOOD_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.MAHOGANY_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.JACARANDA_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.PALM_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.WILLOW_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.DEAD_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.MAGIC_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.UMBRAN_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.HELLBARK_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.EMPYREAL_LEAVES, (RenderType)transparentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.ORIGIN_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.FLOWERING_OAK_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.SNOWBLOSSOM_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.RAINBOW_BIRCH_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.FIR_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.PINE_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.RED_MAPLE_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.ORANGE_MAPLE_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.YELLOW_MAPLE_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.REDWOOD_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.MAHOGANY_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.JACARANDA_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.PALM_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.WILLOW_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.DEAD_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.MAGIC_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.UMBRAN_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.HELLBARK_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.EMPYREAL_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.ROSE, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.VIOLET, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.LAVENDER, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.WILDFLOWER, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.ORANGE_COSMOS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.PINK_DAFFODIL, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.PINK_HIBISCUS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.WATERLILY, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.WHITE_PETALS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.GLOWFLOWER, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.WILTED_LILY, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.BURNING_BLOSSOM, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.TALL_LAVENDER, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.BLUE_HYDRANGEA, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.GOLDENROD, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.ICY_IRIS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.WILLOW_VINE, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.SPANISH_MOSS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.SPANISH_MOSS_PLANT, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.GLOWWORM_SILK, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.GLOWWORM_SILK_STRAND, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.HANGING_COBWEB, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.HANGING_COBWEB_STRAND, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.STRINGY_COBWEB, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.WEBBING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.SPROUT, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.BUSH, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.HIGH_GRASS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.HIGH_GRASS_PLANT, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.CLOVER, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.HUGE_CLOVER_PETAL, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.HUGE_LILY_PAD, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.RED_MAPLE_LEAF_PILE, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.ORANGE_MAPLE_LEAF_PILE, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.YELLOW_MAPLE_LEAF_PILE, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.DUNE_GRASS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.DESERT_GRASS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.DEAD_GRASS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.TUNDRA_SHRUB, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.CATTAIL, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.BARLEY, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.SEA_OATS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.REED, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.WATERGRASS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.DEAD_BRANCH, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.TINY_CACTUS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.BRAMBLE, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.BRAMBLE_LEAVES, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.TOADSTOOL, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.GLOWSHROOM, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.PUS_BUBBLE, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.FLESH_TENDONS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.FLESH_TENDONS_STRAND, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.EYEBULB, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.HAIR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.BRIMSTONE_BUD, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.BRIMSTONE_CLUSTER, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.ROSE_QUARTZ_CLUSTER, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.LARGE_ROSE_QUARTZ_BUD, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.MEDIUM_ROSE_QUARTZ_BUD, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.SMALL_ROSE_QUARTZ_BUD, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.BLACKSTONE_SPINES, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.BLACKSTONE_BULB, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.ENDBLOOM, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.ENDERPHYTE, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.RADIANT_HANDS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.RADIANT_HANDS_PLANT, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.SPIDER_EGG, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.FIR_DOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.PINE_DOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.MAPLE_DOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.REDWOOD_DOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.MAHOGANY_DOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.JACARANDA_DOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.PALM_DOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.WILLOW_DOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.DEAD_DOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.MAGIC_DOOR, (RenderType)translucentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.UMBRAN_DOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.HELLBARK_DOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.EMPYREAL_DOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.FIR_TRAPDOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.PINE_TRAPDOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.MAPLE_TRAPDOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.REDWOOD_TRAPDOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.MAHOGANY_TRAPDOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.JACARANDA_TRAPDOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.PALM_TRAPDOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.WILLOW_TRAPDOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.DEAD_TRAPDOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.MAGIC_TRAPDOOR, (RenderType)translucentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.UMBRAN_TRAPDOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.HELLBARK_TRAPDOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.EMPYREAL_TRAPDOOR, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_ORIGIN_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_FLOWERING_OAK_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_SNOWBLOSSOM_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_RAINBOW_BIRCH_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_FIR_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_PINE_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_RED_MAPLE_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_ORANGE_MAPLE_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_YELLOW_MAPLE_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_REDWOOD_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_MAHOGANY_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_JACARANDA_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_PALM_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_WILLOW_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_DEAD_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_MAGIC_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_UMBRAN_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_HELLBARK_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_EMPYREAL_SAPLING, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_ROSE, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_VIOLET, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_LAVENDER, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_WILDFLOWER, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_ORANGE_COSMOS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_PINK_DAFFODIL, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_PINK_HIBISCUS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_GLOWFLOWER, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_WILTED_LILY, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_BURNING_BLOSSOM, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_ENDBLOOM, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_SPROUT, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_TINY_CACTUS, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_TOADSTOOL, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.POTTED_GLOWSHROOM, (RenderType)cutoutRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.BLOOD, (RenderType)translucentRenderType);
        RenderHelper.setRenderType((Fluid)BOPFluids.BLOOD, (RenderType)translucentRenderType);
        RenderHelper.setRenderType((Fluid)BOPFluids.FLOWING_BLOOD, (RenderType)translucentRenderType);
        RenderHelper.setRenderType((Block)BOPBlocks.LIQUID_NULL, (RenderType)translucentRenderType);
        RenderHelper.setRenderType((Fluid)BOPFluids.LIQUID_NULL, (RenderType)translucentRenderType);
        RenderHelper.setRenderType((Fluid)BOPFluids.LIQUID_NULL, (RenderType)translucentRenderType);
    }

    public static void registerRenderers() {
        LayerDefinition boatLayerDefinition = BoatModel.m_246613_();
        LayerDefinition chestBoatLayerDefinition = ChestBoatModel.m_247175_();
        for (BoatBOP.ModelType type : BoatBOP.ModelType.values()) {
            RenderHelper.registerLayerDefinition((ModelLayerLocation)BoatRendererBOP.createBoatModelName(type), () -> boatLayerDefinition);
            RenderHelper.registerLayerDefinition((ModelLayerLocation)BoatRendererBOP.createChestBoatModelName(type), () -> chestBoatLayerDefinition);
        }
        RenderHelper.registerBlockEntityRenderer(BOPBlockEntities.SIGN, SignRenderer::new);
        RenderHelper.registerBlockEntityRenderer(BOPBlockEntities.HANGING_SIGN, HangingSignRenderer::new);
        RenderHelper.registerBlockEntityRenderer(BOPBlockEntities.ANOMALY, AnomalyRenderer::new);
        RenderHelper.registerEntityRenderer(BOPEntities.BOAT, context -> new BoatRendererBOP(context, false));
        RenderHelper.registerEntityRenderer(BOPEntities.CHEST_BOAT, context -> new BoatRendererBOP(context, true));
    }

    public static void registerItemColors(RegisterColorsEvent.Item event) {
        event.register((stack, tintIndex) -> {
            BlockState state = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            BlockColors blockColors = Minecraft.m_91087_().m_91298_();
            return blockColors.m_92577_(state, null, null, tintIndex);
        }, (Object[])new ItemLike[]{BOPBlocks.MOSSY_BLACK_SAND, BOPBlocks.SPROUT, BOPBlocks.BUSH, BOPBlocks.HIGH_GRASS, BOPBlocks.HIGH_GRASS_PLANT, BOPBlocks.CLOVER, BOPBlocks.HUGE_CLOVER_PETAL, BOPBlocks.HUGE_LILY_PAD, BOPBlocks.FLOWERING_OAK_LEAVES, BOPBlocks.PINE_LEAVES, BOPBlocks.MAHOGANY_LEAVES, BOPBlocks.PALM_LEAVES, BOPBlocks.WILLOW_LEAVES, BOPBlocks.WILLOW_VINE, BOPBlocks.BRAMBLE_LEAVES});
    }

    public static void registerBlockColors(RegisterColorsEvent.Block event) {
        event.register((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), (Object[])new Block[]{BOPBlocks.MOSSY_BLACK_SAND, BOPBlocks.SPROUT, BOPBlocks.HIGH_GRASS, BOPBlocks.HIGH_GRASS_PLANT, BOPBlocks.CLOVER, BOPBlocks.HUGE_CLOVER_PETAL, BOPBlocks.BARLEY, BOPBlocks.WATERGRASS, BOPBlocks.POTTED_SPROUT});
        event.register((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.m_46113_(), (Object[])new Block[]{BOPBlocks.BUSH, BOPBlocks.FLOWERING_OAK_LEAVES, BOPBlocks.PINE_LEAVES, BOPBlocks.MAHOGANY_LEAVES, BOPBlocks.PALM_LEAVES, BOPBlocks.WILLOW_LEAVES, BOPBlocks.WILLOW_VINE, BOPBlocks.BRAMBLE_LEAVES});
        event.register((state, world, pos, tintIndex) -> world != null && pos != null ? ModClient.getRainbowBirchColor(world, pos) : FoliageColor.m_46113_(), (Object[])new Block[]{BOPBlocks.RAINBOW_BIRCH_LEAVES});
        event.register((state, world, pos, tintIndex) -> {
            if (tintIndex != 0) {
                return world != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.m_276205_();
            }
            return -1;
        }, (Object[])new Block[]{BOPBlocks.WHITE_PETALS});
        event.register((state, world, pos, tintIndex) -> world != null && pos != null ? 2129968 : 7455580, (Object[])new Block[]{BOPBlocks.HUGE_LILY_PAD});
    }

    public static void registerParticleSprites(RegisterParticleSpritesEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.DRIPPING_BLOOD, DripParticleBOP.BloodHangProvider::new);
        event.registerSpriteSet((ParticleType)ModParticles.FALLING_BLOOD, DripParticleBOP.BloodFallProvider::new);
        event.registerSpriteSet((ParticleType)ModParticles.LANDING_BLOOD, DripParticleBOP.BloodLandProvider::new);
        event.registerSpriteSet((ParticleType)ModParticles.PUS, PusParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.GLOWWORM, GlowwormParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.STEAM, SteamParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.END_SPORE, EndSporeParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.WISP_BUBBLE, WispBubbleParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.NULL, NullParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.BINARY, BinaryParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.JACARANDA_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new LeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.SNOWBLOSSOM_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new LeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.RED_MAPLE_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new LargeLeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.ORANGE_MAPLE_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new LargeLeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
        event.registerSpriteSet((ParticleType)ModParticles.YELLOW_MAPLE_LEAVES, p_277215_ -> (p_277217_, p_277218_, p_277219_, p_277220_, p_277221_, p_277222_, p_277223_, p_277224_) -> new LargeLeafParticle(p_277218_, p_277219_, p_277220_, p_277221_, p_277215_));
    }

    public static void registerWoodTypes() {
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.FIR);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.PINE);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.MAPLE);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.REDWOOD);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.MAHOGANY);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.JACARANDA);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.PALM);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.WILLOW);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.DEAD);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.MAGIC);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.UMBRAN);
        SheetHelper.addWoodType((WoodType)BOPWoodTypes.HELLBARK);
    }

    public static int getRainbowBirchColor(BlockAndTintGetter world, BlockPos pos) {
        float saturation = world.m_8055_(pos.m_7494_()).m_204336_(BlockTags.f_144279_) ? 0.3f : (world.m_8055_(pos.m_6630_(2)).m_204336_(BlockTags.f_144279_) ? 0.45f : 0.6f);
        Color foliage = Color.getHSBColor(((float)pos.m_123341_() + (float)pos.m_123342_() + (float)pos.m_123343_() + Mth.m_14031_((float)(((float)pos.m_123341_() + (float)pos.m_123342_() + (float)pos.m_123343_()) / 16.0f)) * 16.0f % 100.0f) / 100.0f, saturation, 1.0f);
        return foliage.getRGB();
    }
}

