/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.forge.datagen;

import biomesoplenty.init.ModBiomes;
import biomesoplenty.init.ModDamageTypes;
import biomesoplenty.util.worldgen.BOPFeatureUtils;
import biomesoplenty.util.worldgen.BOPPlacementUtils;
import biomesoplenty.worldgen.carver.BOPConfiguredCarvers;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Cloner;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="biomesoplenty")
public class DataGenerationHandler {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_257003_, BOPConfiguredCarvers::bootstrap).m_254916_(Registries.f_256911_, BOPFeatureUtils::bootstrap).m_254916_(Registries.f_256988_, BOPPlacementUtils::bootstrap).m_254916_(Registries.f_256952_, ModBiomes::bootstrapBiomes).m_254916_(Registries.f_268580_, ModDamageTypes::bootstrap);

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new RegistriesDatapackGenerator(output, (CompletableFuture)event.getLookupProvider().thenApply(r -> DataGenerationHandler.constructRegistries(r, BUILDER)), Set.of("biomesoplenty")));
    }

    private static HolderLookup.Provider constructRegistries(HolderLookup.Provider original, RegistrySetBuilder datapackEntriesBuilder) {
        Cloner.Factory clonerFactory = new Cloner.Factory();
        HashSet builderKeys = new HashSet(datapackEntriesBuilder.getEntryKeys());
        RegistryDataLoader.f_243803_.stream().forEach(data -> {
            if (!builderKeys.contains(data.f_243794_())) {
                datapackEntriesBuilder.m_254916_(data.f_243794_(), context -> {});
            }
            data.m_305182_((arg_0, arg_1) -> ((Cloner.Factory)clonerFactory).m_304739_(arg_0, arg_1));
        });
        return datapackEntriesBuilder.m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), original, clonerFactory).f_302264_();
    }
}

