/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block.entity;

import biomesoplenty.api.block.BOPBlockEntities;
import biomesoplenty.block.AnomalyBlock;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class AnomalyBlockEntity
extends BlockEntity {
    private long lastTime = -1L;
    private BlockState lastState = null;

    public AnomalyBlockEntity(BlockPos pos, BlockState state) {
        super(BOPBlockEntities.ANOMALY, pos, state);
    }

    public BlockState getRenderState() {
        Level level = this.m_58904_();
        long time = level.m_46467_();
        if (this.lastTime == time && this.lastState != null) {
            return this.lastState;
        }
        RandomSource random = RandomSource.m_216335_((long)Mth.m_14057_((Vec3i)this.m_58899_()));
        BlockState state = this.m_58900_();
        Registry blockRegistry = level.m_9598_().m_175515_(Registries.f_256747_);
        int index = random.m_188503_(blockRegistry.m_13562_());
        switch ((AnomalyBlock.AnomalyType)((Object)state.m_61143_(AnomalyBlock.ANOMALY_TYPE))) {
            case VOLATILE: {
                index *= (int)(time / 2L);
                break;
            }
            case QUIRKY: {
                index += (int)(time / 10L);
                break;
            }
            case UNSTABLE: {
                float slowWeight = 0.98f;
                int mode = (Mth.m_14205_((double)(Mth.m_14031_((float)((float)time / 20.0f)) + 0.98f)) + 1) / 2;
                if (mode > 0) {
                    index += (int)(time / 100L);
                    break;
                }
                index += (int)time;
            }
        }
        index %= blockRegistry.m_13562_();
        BlockState renderState = Blocks.f_50016_.m_49966_();
        while (renderState.m_60799_() != RenderShape.MODEL) {
            Block renderBlock = blockRegistry.m_6579_().stream().skip(index).map(Map.Entry::getValue).findFirst().orElseThrow();
            ImmutableList possibleStates = renderBlock.m_49965_().m_61056_();
            renderState = (BlockState)possibleStates.get(random.m_188503_(possibleStates.size()));
            index = (index + 1) % blockRegistry.m_13562_();
        }
        this.lastState = renderState;
        this.lastTime = time;
        return renderState;
    }
}

