/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.registry.Registries;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntries;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public abstract class LootTableGenerator
extends ResourceGenerator {
    private final Map<ResourceLocation, LootTableBuilder> lootTables = new HashMap<ResourceLocation, LootTableBuilder>();

    public LootTableGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (LootTableBuilder lootTableBuilder : this.lootTables.values()) {
            JsonObject json = new JsonObject();
            if (lootTableBuilder.parameters != LootContextParamSets.f_81420_) {
                json.add("type", (JsonElement)LootContextParamSets.f_290720_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)lootTableBuilder.parameters).getOrThrow(false, s -> {}));
            }
            if (!lootTableBuilder.functions.isEmpty()) {
                JsonArray functionsJson = new JsonArray();
                for (LootItemFunction function : lootTableBuilder.functions) {
                    functionsJson.add((JsonElement)LootItemFunctions.f_291699_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)function).getOrThrow(false, s -> {}));
                }
                json.add("functions", (JsonElement)functionsJson);
            }
            if (!lootTableBuilder.pools.isEmpty()) {
                JsonArray poolsJson = new JsonArray();
                for (LootPoolBuilder pool : lootTableBuilder.pools) {
                    JsonObject poolJson = new JsonObject();
                    if (pool.name != null && !pool.name.isEmpty()) {
                        poolJson.addProperty("name", pool.name);
                    }
                    poolJson.add("rolls", (JsonElement)NumberProviders.f_291751_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)pool.rolls).getOrThrow(false, s -> {}));
                    if (!(pool.bonusRolls instanceof ConstantValue) || pool.bonusRolls.m_142683_(null) != 0) {
                        poolJson.add("bonus_rolls", (JsonElement)NumberProviders.f_291751_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)pool.bonusRolls).getOrThrow(false, s -> {}));
                    }
                    if (!pool.conditions.isEmpty()) {
                        JsonArray conditionsJson = new JsonArray();
                        for (LootItemCondition condition : pool.conditions) {
                            conditionsJson.add((JsonElement)LootItemConditions.f_290534_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)condition).getOrThrow(false, s -> {}));
                        }
                        poolJson.add("conditions", (JsonElement)conditionsJson);
                    }
                    if (!pool.functions.isEmpty()) {
                        JsonArray functionsJson = new JsonArray();
                        for (LootItemFunction function : pool.functions) {
                            functionsJson.add((JsonElement)LootItemFunctions.f_291699_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)function).getOrThrow(false, s -> {}));
                        }
                        poolJson.add("functions", (JsonElement)functionsJson);
                    }
                    if (pool.entries.isEmpty()) {
                        throw new RuntimeException("Loot table '" + lootTableBuilder.identifier + "' has loot pool without any entries!");
                    }
                    JsonArray entriesJson = new JsonArray();
                    for (LootPoolEntryContainer entry : pool.entries) {
                        entriesJson.add((JsonElement)LootPoolEntries.f_291877_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry).getOrThrow(false, s -> {}));
                    }
                    poolJson.add("entries", (JsonElement)entriesJson);
                    poolsJson.add((JsonElement)poolJson);
                }
                json.add("pools", (JsonElement)poolsJson);
            }
            ResourceLocation identifier = lootTableBuilder.identifier;
            this.cache.saveJsonResource(ResourceType.DATA, json, identifier.m_135827_(), "loot_tables", identifier.m_135815_());
        }
    }

    protected LootTableBuilder lootTable(ResourceLocation identifier) {
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, identifier.m_135827_(), "loot_tables", identifier.m_135815_(), ".json");
        return this.lootTables.computeIfAbsent(identifier, LootTableBuilder::new);
    }

    protected LootTableBuilder lootTable(String namespace, String path) {
        return this.lootTable(new ResourceLocation(namespace, path));
    }

    protected LootTableBuilder lootTable(Block block) {
        return this.lootTable(block.m_60589_());
    }

    protected LootTableBuilder dropSelf(Block block) {
        return this.lootTable(block).blockParameters().pool(poolBuilder -> poolBuilder.survivesExplosionCondition().itemEntry((ItemLike)block));
    }

    protected LootTableBuilder dropSelfWhenSilkTouch(Block block) {
        return this.lootTable(block).blockParameters().pool(poolBuilder -> poolBuilder.hasEnchantmentCondition(Enchantments.f_44985_).itemEntry((ItemLike)block));
    }

    @Override
    public String getName() {
        return this.modName + " Loot Table Generator";
    }

    public static class LootTableBuilder {
        protected final ResourceLocation identifier;
        private final List<LootPoolBuilder> pools = new ArrayList<LootPoolBuilder>();
        private final List<LootItemFunction> functions = new ArrayList<LootItemFunction>();
        private LootContextParamSet parameters = LootContextParamSets.f_81420_;

        protected LootTableBuilder(ResourceLocation identifier) {
            this.identifier = identifier;
        }

        public LootTableBuilder parameters(LootContextParamSet parameters) {
            if (LootContextParamSets.f_290720_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)parameters).error().isPresent()) {
                throw new IllegalArgumentException("Cannot use unregistered parameter set '" + parameters + "'!");
            }
            this.parameters = parameters;
            return this;
        }

        public LootTableBuilder blockParameters() {
            return this.parameters(LootContextParamSets.f_81421_);
        }

        public LootTableBuilder chestParameters() {
            return this.parameters(LootContextParamSets.f_81411_);
        }

        public LootTableBuilder pool(Consumer<LootPoolBuilder> poolBuilderConsumer) {
            LootPoolBuilder poolBuilder = new LootPoolBuilder();
            poolBuilderConsumer.accept(poolBuilder);
            this.pools.add(poolBuilder);
            return this;
        }

        public LootTableBuilder function(LootItemFunction function) {
            if (BuiltInRegistries.f_256753_.m_7981_((Object)function.m_7162_()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered item function '" + function + "'!");
            }
            this.functions.add(function);
            return this;
        }
    }

    public static class LootPoolBuilder {
        private final List<LootItemCondition> conditions = new ArrayList<LootItemCondition>();
        private final List<LootItemFunction> functions = new ArrayList<LootItemFunction>();
        private final List<LootPoolEntryContainer> entries = new ArrayList<LootPoolEntryContainer>();
        private NumberProvider rolls = ConstantValue.m_165692_((float)1.0f);
        private NumberProvider bonusRolls = ConstantValue.m_165692_((float)0.0f);
        private String name;

        protected LootPoolBuilder() {
        }

        public LootPoolBuilder rolls(NumberProvider provider) {
            if (BuiltInRegistries.f_257029_.m_7981_((Object)provider.m_142587_()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered number provider '" + provider + "'!");
            }
            this.rolls = provider;
            return this;
        }

        public LootPoolBuilder constantRolls(int rolls) {
            return this.rolls((NumberProvider)ConstantValue.m_165692_((float)rolls));
        }

        public LootPoolBuilder uniformRolls(int min, int max) {
            return this.rolls((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max));
        }

        public LootPoolBuilder binomialRolls(int n, int p) {
            return this.rolls((NumberProvider)BinomialDistributionGenerator.m_165659_((int)n, (float)p));
        }

        public LootPoolBuilder bonusRolls(NumberProvider provider) {
            if (BuiltInRegistries.f_257029_.m_7981_((Object)provider.m_142587_()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered number provider '" + provider + "'!");
            }
            this.bonusRolls = provider;
            return this;
        }

        public LootPoolBuilder constantBonusRolls(int rolls) {
            return this.bonusRolls((NumberProvider)ConstantValue.m_165692_((float)rolls));
        }

        public LootPoolBuilder uniformBonusRolls(int min, int max) {
            return this.bonusRolls((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max));
        }

        public LootPoolBuilder binomialBonusRolls(int n, int p) {
            return this.bonusRolls((NumberProvider)BinomialDistributionGenerator.m_165659_((int)n, (float)p));
        }

        public LootPoolBuilder name(String name) {
            this.name = name;
            return this;
        }

        public LootPoolBuilder condition(LootItemCondition condition) {
            if (BuiltInRegistries.f_256991_.m_7981_((Object)condition.m_7940_()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered loot pool condition '" + condition + "'!");
            }
            this.conditions.add(condition);
            return this;
        }

        public LootPoolBuilder survivesExplosionCondition() {
            return this.condition(ExplosionCondition.m_81661_().m_6409_());
        }

        public LootPoolBuilder hasEnchantmentCondition(Enchantment enchantment, int minLevel, int maxLevel) {
            return this.condition(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(enchantment, MinMaxBounds.Ints.m_154814_((int)minLevel, (int)maxLevel)))).m_6409_());
        }

        public LootPoolBuilder hasEnchantmentCondition(Enchantment enchantment, int minLevel) {
            return this.condition(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(enchantment, MinMaxBounds.Ints.m_55386_((int)minLevel)))).m_6409_());
        }

        public LootPoolBuilder hasEnchantmentCondition(Enchantment enchantment) {
            return this.hasEnchantmentCondition(enchantment, 1);
        }

        public LootPoolBuilder entry(LootPoolEntryContainer entry) {
            if (BuiltInRegistries.f_257035_.m_7981_((Object)entry.m_6751_()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered loot pool entry '" + entry + "'!");
            }
            this.entries.add(entry);
            return this;
        }

        private LootPoolBuilder entry(LootPoolSingletonContainer.Builder<?> entry, int weight) {
            if (weight <= 0) {
                throw new IllegalArgumentException("Loot entry weight must be greater than zero, not '" + weight + "'!");
            }
            return this.entry(entry.m_79707_(weight).m_7512_());
        }

        public LootPoolBuilder emptyEntry(int weight) {
            return this.entry(EmptyLootItem.m_79533_(), weight);
        }

        public LootPoolBuilder emptyEntry() {
            return this.emptyEntry(1);
        }

        public LootPoolBuilder itemEntry(ItemLike item, int weight) {
            return this.entry(LootItem.m_79579_((ItemLike)item), weight);
        }

        public LootPoolBuilder itemEntry(ItemLike item) {
            return this.itemEntry(item, 1);
        }

        public LootPoolBuilder itemEntry(ItemLike item, int count, int weight) {
            return this.entry(LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)count))), weight);
        }

        public LootPoolBuilder itemEntry(ItemLike item, int min, int max, int weight) {
            return this.entry(LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))), weight);
        }

        public LootPoolBuilder itemEntry(ResourceLocation item) {
            if (!Registries.ITEMS.hasIdentifier(item)) {
                throw new IllegalArgumentException("Could not find any item registered under '" + item + "'!");
            }
            return this.itemEntry((ItemLike)Registries.ITEMS.getValue(item));
        }

        public LootPoolBuilder itemEntry(String namespace, String identifier) {
            return this.itemEntry(new ResourceLocation(namespace, identifier));
        }

        public LootPoolBuilder enchantedItemEntry(ItemLike item, int levels, boolean allowCurses, int weight) {
            EnchantWithLevelsFunction.Builder builder = EnchantWithLevelsFunction.m_165196_((NumberProvider)ConstantValue.m_165692_((float)levels));
            if (allowCurses) {
                builder.m_80499_();
            }
            return this.entry(LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)builder), weight);
        }

        public LootPoolBuilder enchantedItemEntry(ItemLike item, int minLevels, int maxLevels, boolean allowCurses, int weight) {
            EnchantWithLevelsFunction.Builder builder = EnchantWithLevelsFunction.m_165196_((NumberProvider)UniformGenerator.m_165780_((float)minLevels, (float)maxLevels));
            if (allowCurses) {
                builder.m_80499_();
            }
            return this.entry(LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)builder), weight);
        }

        public LootPoolBuilder tagEntry(TagKey<Item> tagKey, int weight) {
            return this.entry(TagEntry.m_205084_(tagKey), weight);
        }

        public LootPoolBuilder tagEntry(TagKey<Item> tagKey) {
            return this.tagEntry(tagKey, 1);
        }

        public LootPoolBuilder tagEntry(ResourceLocation tag, int weight) {
            return this.tagEntry((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.ITEMS.getVanillaRegistry().m_123023_(), (ResourceLocation)tag), weight);
        }

        public LootPoolBuilder tagEntry(ResourceLocation tag) {
            return this.tagEntry((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.ITEMS.getForgeRegistry().getRegistryKey(), (ResourceLocation)tag));
        }

        public LootPoolBuilder tagEntry(String namespace, String path, int weight) {
            return this.tagEntry(new ResourceLocation(namespace, path), weight);
        }

        public LootPoolBuilder tagEntry(String namespace, String path) {
            return this.tagEntry(new ResourceLocation(namespace, path));
        }

        public LootPoolBuilder lootTableEntry(ResourceLocation lootTable, int weight) {
            return this.entry(LootTableReference.m_79776_((ResourceLocation)lootTable), weight);
        }

        public LootPoolBuilder lootTableEntry(ResourceLocation lootTable) {
            return this.lootTableEntry(lootTable, 1);
        }

        public LootPoolBuilder lootTableEntry(String namespace, String path, int weight) {
            return this.lootTableEntry(new ResourceLocation(namespace, path), weight);
        }

        public LootPoolBuilder lootTableEntry(String namespace, String path) {
            return this.lootTableEntry(new ResourceLocation(namespace, path));
        }

        public LootPoolBuilder function(LootItemFunction function) {
            if (BuiltInRegistries.f_256753_.m_7981_((Object)function.m_7162_()) == null) {
                throw new IllegalArgumentException("Cannot use unregistered item function '" + function + "'!");
            }
            this.functions.add(function);
            return this;
        }
    }
}

