/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.data.condition.ResourceCondition;
import com.supermartijn642.core.registry.Registries;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.conditions.ICondition;

public final class ConditionalRecipeSerializer
implements RecipeSerializer<Recipe<?>> {
    public static final RecipeType<DummyRecipe> DUMMY_RECIPE_TYPE = RecipeType.simple((ResourceLocation)new ResourceLocation("supermartijn642corelib:dummy"));
    private static final DummyRecipe DUMMY_RECIPE = new DummyRecipe();
    public static final ConditionalRecipeSerializer INSTANCE = new ConditionalRecipeSerializer();

    public static JsonObject wrapRecipeWithForgeConditions(JsonObject recipe, Collection<ICondition> conditions) {
        JsonObject json = new JsonObject();
        json.addProperty("type", Registries.RECIPE_SERIALIZERS.getIdentifier(INSTANCE).toString());
        JsonArray conditionsJson = new JsonArray();
        for (ICondition condition : conditions) {
            conditionsJson.add((JsonElement)ICondition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)condition).getOrThrow(false, s -> {}));
        }
        json.add("conditions", (JsonElement)conditionsJson);
        json.add("recipe", (JsonElement)recipe);
        return json;
    }

    public static JsonObject wrapRecipe(JsonObject recipe, Collection<ResourceCondition> conditions) {
        return ConditionalRecipeSerializer.wrapRecipeWithForgeConditions(recipe, conditions.stream().map(ResourceCondition::createForgeCondition).collect(Collectors.toList()));
    }

    private ConditionalRecipeSerializer() {
    }

    public static RecipeHolder<?> fromJson(ResourceLocation location, JsonObject json) {
        if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
            throw new RuntimeException("Conditional recipe '" + location + "' must have 'conditions' array!");
        }
        if (!json.has("recipe") || !json.get("recipe").isJsonObject()) {
            throw new RuntimeException("Conditional recipe '" + location + "' must have 'recipe' object!");
        }
        JsonArray conditions = json.getAsJsonArray("conditions");
        for (JsonElement conditionElement : conditions) {
            ICondition condition;
            try {
                condition = (ICondition)((Pair)ICondition.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)conditionElement).getOrThrow(false, s -> {})).getFirst();
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered exception whilst testing conditions for recipe '" + location + "'!", e);
            }
            if (condition.test(ICondition.IContext.EMPTY)) continue;
            return new RecipeHolder(location, (Recipe)DUMMY_RECIPE);
        }
        return RecipeManager.m_44045_((ResourceLocation)location, (JsonObject)json.getAsJsonObject("recipe"));
    }

    public Codec<Recipe<?>> m_292673_() {
        return Codec.unit(null);
    }

    public Recipe<?> m_8005_(FriendlyByteBuf friendlyByteBuf) {
        return new DummyRecipe();
    }

    public void m_6178_(FriendlyByteBuf friendlyByteBuf, Recipe<?> recipe) {
    }

    private static class DummyRecipe
    implements Recipe<Container> {
        private DummyRecipe() {
        }

        public boolean m_5818_(Container container, Level level) {
            return false;
        }

        public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
            return ItemStack.f_41583_;
        }

        public boolean m_8004_(int i, int j) {
            return false;
        }

        public ItemStack m_8043_(RegistryAccess registryAccess) {
            return ItemStack.f_41583_;
        }

        public RecipeSerializer<?> m_7707_() {
            return INSTANCE;
        }

        public RecipeType<?> m_6671_() {
            return DUMMY_RECIPE_TYPE;
        }

        public boolean m_142505_() {
            return true;
        }
    }
}

