/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Structure;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.factionbedrock.aerialhell.Registry.Worldgen.AerialHellStructures;
import fr.factionbedrock.aerialhell.World.Structure.AbstractAerialHellStructure;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class ShadowCatacombsStructure
extends AbstractAerialHellStructure {
    public static final Codec<ShadowCatacombsStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ShadowCatacombsStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)50).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)256).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, ShadowCatacombsStructure::new)).codec();

    public ShadowCatacombsStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config, startPool, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter, List.of());
    }

    @Override
    protected boolean isStructureChunk(Structure.GenerationContext context) {
        int checkDistance = 30;
        int highGroundCount = 0;
        BlockPos centerOfChunk = context.f_226628_().m_151394_(0);
        ImmutableList posToCheck = ImmutableList.of((Object)centerOfChunk, (Object)centerOfChunk.m_122013_(checkDistance), (Object)centerOfChunk.m_122020_(checkDistance), (Object)centerOfChunk.m_122030_(checkDistance), (Object)centerOfChunk.m_122025_(checkDistance));
        for (BlockPos pos : posToCheck) {
            int landHeight = ShadowCatacombsStructure.getTerrainHeight(context, pos.m_123341_(), pos.m_123343_());
            if (landHeight <= 50) continue;
            ++highGroundCount;
        }
        return highGroundCount > 3;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)AerialHellStructures.SHADOW_CATACOMBS_STRUCTURE.get();
    }
}

