/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.factionbedrock.aerialhell.Registry.Worldgen.AerialHellStructures;
import fr.factionbedrock.aerialhell.World.Structure.AbstractAerialHellStructure;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class MudDungeonStructure
extends AbstractAerialHellStructure {
    private static final int MIN_GEN_HEIGHT = 20;
    private static final int MAX_GEN_HEIGHT = 50;
    public static final Codec<MudDungeonStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MudDungeonStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)50).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)256).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, MudDungeonStructure::new)).codec();

    public MudDungeonStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config, startPool, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter, List.of());
    }

    @Override
    protected boolean isStructureChunk(Structure.GenerationContext context) {
        int z;
        int x = context.f_226628_().m_45608_();
        if (MudDungeonStructure.getTerrainHeight(context, x, z = context.f_226628_().m_45609_()) < 50) {
            return false;
        }
        NoiseColumn column = context.f_226622_().m_214184_(x, z, context.f_226629_(), context.f_226624_());
        return MudDungeonStructure.columnHasPercentOfNonAirBlocks(column, 0.25f);
    }

    private static boolean columnHasPercentOfNonAirBlocks(NoiseColumn column, float part) {
        int count = 0;
        for (int y = 20; y < 50; ++y) {
            if (column.m_183556_(y).m_60795_() || !((float)(++count) > 30.0f * part)) continue;
            return true;
        }
        return false;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)AerialHellStructures.MUD_DUNGEON_STRUCTURE.get();
    }
}

