/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Features;

import com.mojang.serialization.Codec;
import fr.factionbedrock.aerialhell.Block.Plants.VerticalGrowingPlantBlock;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.World.Features.Config.VerticalGrowingPlantConfig;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class VerticalGrowingPlantFeature
extends Feature<VerticalGrowingPlantConfig> {
    private Supplier<VerticalGrowingPlantBlock> block;

    public VerticalGrowingPlantFeature(Codec<VerticalGrowingPlantConfig> codec, Supplier<VerticalGrowingPlantBlock> plantBlock) {
        super(codec);
        this.block = plantBlock;
    }

    public boolean m_142674_(FeaturePlaceContext<VerticalGrowingPlantConfig> context) {
        int maxTries;
        BlockPos blockpos;
        WorldGenLevel worldgenlevel = context.m_159774_();
        if (VerticalGrowingPlantFeature.isInvalidPlacementLocation((LevelAccessor)worldgenlevel, blockpos = context.m_159777_())) {
            return false;
        }
        RandomSource random = context.m_225041_();
        VerticalGrowingPlantConfig config = (VerticalGrowingPlantConfig)context.m_159778_();
        int spreadXZ = config.spreadWidth();
        int spreadY = config.spreadHeight();
        int minHeight = config.minHeight();
        int maxHeight = config.maxHeight();
        int minTries = config.minTries();
        int tries = minTries == (maxTries = config.maxTries()) ? minTries : Mth.m_216271_((RandomSource)random, (int)minTries, (int)maxTries);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l = 0; l <= tries; ++l) {
            blockpos$mutableblockpos.m_122190_((Vec3i)blockpos).m_122184_(Mth.m_216271_((RandomSource)random, (int)(-spreadXZ), (int)spreadXZ), Mth.m_216271_((RandomSource)random, (int)(-spreadY), (int)spreadY), Mth.m_216271_((RandomSource)random, (int)(-spreadXZ), (int)spreadXZ));
            if (!VerticalGrowingPlantFeature.findFirstAirBlockAboveGround((LevelAccessor)worldgenlevel, blockpos$mutableblockpos) || VerticalGrowingPlantFeature.isInvalidPlacementLocation((LevelAccessor)worldgenlevel, (BlockPos)blockpos$mutableblockpos)) continue;
            int plantHeight = minHeight == maxHeight ? minHeight : Mth.m_216271_((RandomSource)random, (int)minHeight, (int)maxHeight);
            VerticalGrowingPlantFeature.placeVerticalGrowingPlantColumn((LevelAccessor)worldgenlevel, random, blockpos$mutableblockpos, plantHeight, 9, 14, this.block.get());
        }
        return true;
    }

    private static boolean findFirstAirBlockAboveGround(LevelAccessor level, BlockPos.MutableBlockPos mutablePos) {
        do {
            mutablePos.m_122184_(0, -1, 0);
            if (!level.m_151570_((BlockPos)mutablePos)) continue;
            return false;
        } while (level.m_8055_((BlockPos)mutablePos).m_60795_());
        mutablePos.m_122184_(0, 1, 0);
        return true;
    }

    public static void placeVerticalGrowingPlantColumn(LevelAccessor level, RandomSource rand, BlockPos.MutableBlockPos mutablePos, int height, int minAge, int maxAge, VerticalGrowingPlantBlock plantBlock) {
        for (int i = 1; i <= height; ++i) {
            if (level.m_46859_((BlockPos)mutablePos)) {
                if (i == height || !level.m_46859_(mutablePos.m_7494_())) {
                    level.m_7731_((BlockPos)mutablePos, (BlockState)((BlockState)plantBlock.m_49966_().m_61124_((Property)VerticalGrowingPlantBlock.AGE, (Comparable)Integer.valueOf(Mth.m_216271_((RandomSource)rand, (int)minAge, (int)maxAge)))).m_61124_((Property)VerticalGrowingPlantBlock.TOP, (Comparable)Boolean.valueOf(true)), 2);
                    break;
                }
                level.m_7731_((BlockPos)mutablePos, (BlockState)plantBlock.m_49966_().m_61124_((Property)VerticalGrowingPlantBlock.TOP, (Comparable)Boolean.valueOf(false)), 2);
            }
            mutablePos.m_122173_(Direction.UP);
        }
    }

    private static boolean isInvalidPlacementLocation(LevelAccessor level, BlockPos pos) {
        if (!level.m_46859_(pos)) {
            return true;
        }
        BlockState blockstate = level.m_8055_(pos.m_7495_());
        return !blockstate.m_204336_(AerialHellTags.Blocks.STELLAR_DIRT);
    }
}

