/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Features;

import com.mojang.serialization.Codec;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class StellarStoneCrystalBlobFeature
extends Feature<NoneFeatureConfiguration> {
    public Supplier<Block> crystalBlock;

    public StellarStoneCrystalBlobFeature(Supplier<Block> block, Codec<NoneFeatureConfiguration> codec) {
        super(codec);
        this.crystalBlock = block;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos pos = context.m_159777_();
        WorldGenLevel world = context.m_159774_();
        RandomSource rand = context.m_225041_();
        int x = pos.m_123341_();
        int y = 10;
        int z = pos.m_123343_();
        int ymax = 160;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        mutablePos.m_122190_((Vec3i)new BlockPos(x, y, z));
        boolean hasSupport = false;
        while (!hasSupport && y < ymax) {
            if (this.hasSupportToGenerate((BlockPos)mutablePos, world)) {
                hasSupport = true;
                continue;
            }
            mutablePos.m_122190_((Vec3i)new BlockPos(x, ++y, z));
        }
        if (y == ymax) {
            return false;
        }
        if (!this.squareHasRoof((BlockPos)mutablePos, world)) {
            return false;
        }
        pos = mutablePos;
        if (rand.m_188503_(160) < y) {
            return false;
        }
        world.m_7731_(pos, this.crystalBlock.get().m_49966_(), 2);
        for (int i = 0; i < 300; ++i) {
            BlockPos blockpos = pos.m_7918_(rand.m_188503_(2) - rand.m_188503_(2), rand.m_188503_(5), rand.m_188503_(2) - rand.m_188503_(2));
            if (!world.m_46859_(blockpos)) continue;
            int j = 0;
            for (Direction direction : Direction.values()) {
                if (world.m_8055_(blockpos.m_121945_(direction)).m_60713_(this.crystalBlock.get())) {
                    ++j;
                }
                if (j > 1) break;
            }
            if (j != true) continue;
            world.m_7731_(blockpos, this.crystalBlock.get().m_49966_(), 2);
        }
        return true;
    }

    private boolean hasSupportToGenerate(BlockPos pos, WorldGenLevel reader) {
        BlockState blockstateDown = reader.m_8055_(pos.m_7495_());
        return this.isValidFloorState(blockstateDown) && this.hasAirColumnAbove(pos, reader, 4);
    }

    private boolean isValidFloorState(BlockState state) {
        return state.m_204336_(AerialHellTags.Blocks.STELLAR_DIRT) || state.m_60713_((Block)AerialHellBlocksAndItems.SLIPPERY_SAND.get());
    }

    private boolean squareHasRoof(BlockPos pos, WorldGenLevel reader) {
        for (int x = -4; x < 5; ++x) {
            for (int z = -4; z < 5; ++z) {
                BlockPos blockpos = pos.m_7918_(x, 0, z);
                if (this.hasAnyBlockAbove(blockpos, reader)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasAnyBlockAbove(BlockPos pos, WorldGenLevel reader) {
        BlockPos blockpos = pos.m_7494_();
        while (blockpos.m_123342_() < 250) {
            if (!reader.m_46859_(blockpos)) {
                return true;
            }
            blockpos = blockpos.m_7494_();
        }
        return false;
    }

    private boolean hasAirColumnAbove(BlockPos pos, WorldGenLevel reader, int dy) {
        BlockPos blockpos = pos.m_7494_();
        while (blockpos.m_123342_() < pos.m_123342_() + dy) {
            if (!reader.m_46859_(blockpos)) {
                return false;
            }
            blockpos = blockpos.m_7494_();
        }
        return true;
    }
}

