/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.World.Features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public abstract class AbstractFloorEllipsisFeature
extends Feature<NoneFeatureConfiguration> {
    public AbstractFloorEllipsisFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    protected abstract int getEllipsisSizeX(RandomSource var1);

    protected abstract int getEllipsisSizeZ(RandomSource var1);

    protected abstract boolean canGenerate(WorldGenLevel var1, BlockPos var2);

    protected abstract boolean isFloor(BlockState var1);

    protected abstract BlockState getBlockStateForPlacement(BlockState var1, BlockPos var2, BlockPos var3, int var4, int var5, RandomSource var6);

    public boolean place(NoneFeatureConfiguration config, WorldGenLevel reader, ChunkGenerator generator, RandomSource rand, BlockPos pos) {
        if (this.canGenerate(reader, pos)) {
            int sizeX = this.getEllipsisSizeX(rand);
            int sizeZ = this.getEllipsisSizeZ(rand);
            for (int x = pos.m_123341_() - sizeX; x < pos.m_123341_() + sizeX + 1; ++x) {
                for (int z = pos.m_123343_() - sizeZ; z < pos.m_123343_() + sizeZ + 1; ++z) {
                    for (int y = pos.m_123342_() - 3; y < pos.m_123342_() + 4; ++y) {
                        BlockPos placementPos = new BlockPos(x, y, z);
                        BlockState previousBlockState = reader.m_8055_(placementPos);
                        if (!this.isFloor(previousBlockState)) continue;
                        BlockState placementBlockState = this.getBlockStateForPlacement(previousBlockState, pos, placementPos, sizeX, sizeZ, rand);
                        reader.m_7731_(placementPos, placementBlockState, 2);
                        y += 7;
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected boolean hasAnyBlockAbove(BlockPos pos, WorldGenLevel reader) {
        BlockPos blockpos1 = pos.m_7494_();
        while (blockpos1.m_123342_() < 250) {
            if (!reader.m_46859_(blockpos1)) {
                return true;
            }
            blockpos1 = blockpos1.m_7494_();
        }
        return false;
    }
}

