/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Util;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SmithingTemplateItem;

public class ItemHelper {
    public static int getItemInTagCount(Iterable<ItemStack> stuff, TagKey<Item> tag) {
        int count = 0;
        for (ItemStack item : stuff) {
            if (!item.m_204117_(tag)) continue;
            ++count;
        }
        return count;
    }

    public static int getItemMiningLevel(Item item) {
        return item instanceof DiggerItem ? ((DiggerItem)item).m_43314_().m_6604_() : 0;
    }

    public static class SmithingTemplate {
        private static final ChatFormatting DESCRIPTION_FORMAT = ChatFormatting.BLUE;
        private static final ChatFormatting TITLE_FORMAT = ChatFormatting.GRAY;
        private static final String APPLIES_TO = "applies_to";
        private static final String INGREDIENTS = "ingredients";
        private static final String BASE_SLOT_DESCRIPTION = "base_slot_description";
        private static final String ADDITIONS_SLOT_DESCRIPTION = "additions_slot_description";

        private static Component makeUpgradeTitleComponent(String materialName) {
            return Component.m_237115_((String)Util.m_137492_((String)"upgrade", (ResourceLocation)new ResourceLocation("aerialhell", materialName + "_upgrade"))).m_130940_(TITLE_FORMAT);
        }

        private static Component makeSmithingTemplateItemDescComponent(String materialName, String info, @Nullable ChatFormatting format) {
            MutableComponent returnComponent = Component.m_237115_((String)Util.m_137492_((String)"item", (ResourceLocation)new ResourceLocation("aerialhell", "smithing_template." + materialName + "_upgrade." + info)));
            return format == null ? returnComponent : returnComponent.m_130940_(format);
        }

        public static SmithingTemplateItem createUpgradeTemplate(String materialName) {
            return new SmithingTemplateItem(SmithingTemplate.makeSmithingTemplateItemDescComponent(materialName, APPLIES_TO, DESCRIPTION_FORMAT), SmithingTemplate.makeSmithingTemplateItemDescComponent(materialName, INGREDIENTS, DESCRIPTION_FORMAT), SmithingTemplate.makeUpgradeTitleComponent(materialName), SmithingTemplate.makeSmithingTemplateItemDescComponent(materialName, BASE_SLOT_DESCRIPTION, null), SmithingTemplate.makeSmithingTemplateItemDescComponent(materialName, ADDITIONS_SLOT_DESCRIPTION, null), SmithingTemplateItem.m_266257_(), SmithingTemplateItem.m_266579_());
        }
    }
}

