/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Util;

import fr.factionbedrock.aerialhell.Client.Registry.AerialHellParticleTypes;
import fr.factionbedrock.aerialhell.Entity.AbstractAerialHellSpiderEntity;
import fr.factionbedrock.aerialhell.Entity.Bosses.LilithEntity;
import fr.factionbedrock.aerialhell.Entity.Bosses.LunaticPriestEntity;
import fr.factionbedrock.aerialhell.Entity.Bosses.MudCycleMageEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.BarrelMimic.ShadowPineBarrelMimicEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ChestMimic.AerialTreeChestMimicEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.CrystalCaterpillarEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.CrystalGolemEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.CrystalSlimeEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.CrystalSpiderEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.EvilCowEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.MudGolemEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.MudSoldierEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ShadowAutomatonEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ShadowFlyingSkullEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ShadowSpiderEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ShadowTrollEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.ShroomBoomEntity;
import fr.factionbedrock.aerialhell.Entity.Monster.VerdigrisZombieEntity;
import fr.factionbedrock.aerialhell.Entity.Neutral.BoarEntity;
import fr.factionbedrock.aerialhell.Entity.Passive.GlidingTurtleEntity;
import fr.factionbedrock.aerialhell.Entity.Passive.KodamaEntity;
import fr.factionbedrock.aerialhell.Entity.Passive.SandySheepEntity;
import fr.factionbedrock.aerialhell.Entity.Projectile.LunaticProjectileEntity;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.AerialHellEnchantments;
import fr.factionbedrock.aerialhell.Registry.AerialHellMobEffects;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.Registry.Worldgen.AerialHellDimensions;
import fr.factionbedrock.aerialhell.Util.ItemHelper;
import fr.factionbedrock.aerialhell.World.AerialHellTeleporter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.util.ITeleporter;

public class EntityHelper {
    public static boolean isCreativePlayer(Entity entity) {
        Player player;
        return entity instanceof Player && (player = (Player)entity).m_7500_();
    }

    public static boolean isSpectatorPlayer(Entity entity) {
        Player player;
        return entity instanceof Player && (player = (Player)entity).m_5833_();
    }

    public static boolean isCreaOrSpecPlayer(Entity entity) {
        Player player;
        return entity instanceof Player && ((player = (Player)entity).m_7500_() || player.m_5833_());
    }

    public static boolean isLivingEntityUnderInTheCloudsEffect(LivingEntity entity) {
        return entity.m_21023_((MobEffect)AerialHellMobEffects.HEAD_IN_THE_CLOUDS.get());
    }

    public static boolean isLivingEntityShadowImmune(LivingEntity entity) {
        return entity.m_21023_((MobEffect)AerialHellMobEffects.SHADOW_IMMUNITY.get());
    }

    public static boolean isLivingEntityVulnerable(LivingEntity entity) {
        return entity.m_21023_((MobEffect)AerialHellMobEffects.VULNERABILITY.get());
    }

    public static boolean isLivingEntityATraitor(LivingEntity entity) {
        return entity.m_21023_((MobEffect)AerialHellMobEffects.TRAITOR.get());
    }

    public static boolean isLivingEntityUnderAerialHellPortalEffect(LivingEntity entity) {
        return entity.m_21023_((MobEffect)AerialHellMobEffects.AERIAL_HELL_PORTAL.get());
    }

    public static boolean isLivingEntityInAerialHellPortal(LivingEntity entity) {
        return entity.m_9236_().m_8055_(entity.m_20183_()).m_60713_((Block)AerialHellBlocksAndItems.AERIAL_HELL_PORTAL.get());
    }

    public static boolean isLivingEntityOnPortalCooldown(LivingEntity entity) {
        return entity.m_21023_((MobEffect)AerialHellMobEffects.AERIAL_HELL_PORTAL_COOLDOWN.get()) || entity.m_20092_();
    }

    public static boolean isImmuneToSomeShadowDamage(Entity entity) {
        boolean isShadowImmune = entity instanceof LivingEntity && EntityHelper.isLivingEntityShadowImmune((LivingEntity)entity);
        boolean isShadowEntity = EntityHelper.isShadowEntity(entity);
        return isShadowImmune || isShadowEntity;
    }

    public static boolean isShadowEntity(Entity entity) {
        return entity instanceof EvilCowEntity || entity instanceof ShadowAutomatonEntity || entity instanceof ShadowTrollEntity || entity instanceof ShadowFlyingSkullEntity || entity instanceof ShadowSpiderEntity || entity instanceof ShadowPineBarrelMimicEntity || entity instanceof LilithEntity || entity instanceof EnderMan;
    }

    public static boolean isLightEntity(Entity entity) {
        return entity instanceof CrystalGolemEntity || entity instanceof CrystalCaterpillarEntity || entity instanceof CrystalSlimeEntity || entity instanceof CrystalSpiderEntity || entity instanceof LunaticPriestEntity;
    }

    public static boolean isLightProjectile(Entity entity) {
        return entity instanceof LunaticProjectileEntity;
    }

    public static boolean isMudEntity(Entity entity) {
        return entity instanceof MudSoldierEntity || entity instanceof MudGolemEntity || entity instanceof MudCycleMageEntity || entity instanceof AerialTreeChestMimicEntity;
    }

    public static boolean isFeatheryEntity(Entity entity) {
        return entity instanceof Silverfish || entity instanceof FlyingMob || entity instanceof Chicken || entity instanceof Vex;
    }

    public static boolean isImmuneToBramblesDamage(Entity entity) {
        boolean isImmuneToAllBrambles;
        boolean bl = isImmuneToAllBrambles = entity instanceof SandySheepEntity || entity instanceof BoarEntity || entity instanceof GlidingTurtleEntity || entity instanceof KodamaEntity || entity instanceof ShroomBoomEntity || entity instanceof EvilCowEntity || entity instanceof AbstractAerialHellSpiderEntity || EntityHelper.isFeatheryEntity(entity) || entity instanceof VerdigrisZombieEntity;
        if (isImmuneToAllBrambles) {
            return true;
        }
        return EntityHelper.isImmuneToSomeShadowDamage(entity);
    }

    public static boolean isImmuneToSolidEtherCollision(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (EntityHelper.hasSolidEtherWalkerEnchantment(livingEntity) || EntityHelper.isLivingEntityUnderInTheCloudsEffect(livingEntity) || EntityHelper.isFeatheryEntity(entity)) {
                return false;
            }
            Iterable stuff = livingEntity.m_6168_();
            for (ItemStack armorStack : stuff) {
                if (armorStack.m_41720_() != AerialHellBlocksAndItems.MAGMATIC_GEL_BOOTS.get()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasSolidEtherWalkerEnchantment(LivingEntity entity) {
        for (ItemStack equipmentItem : entity.m_20158_()) {
            if (EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AerialHellEnchantments.SOLID_ETHER_WALKER.get()), (ItemStack)equipmentItem) <= 0) continue;
            return true;
        }
        return false;
    }

    public static void setAerialHellPortalEffect(LivingEntity entity) {
        if (!entity.m_9236_().m_5776_()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.AERIAL_HELL_PORTAL.get(), 120, 0));
        }
    }

    public static void setAfterTeleportationEffect(LivingEntity entity) {
        if (!entity.m_9236_().m_5776_()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.AERIAL_HELL_PORTAL_COOLDOWN.get(), 110, 0));
        }
    }

    public static boolean shouldLivingEntityHavePortalEffect(LivingEntity entity) {
        return !EntityHelper.isLivingEntityOnPortalCooldown(entity) && EntityHelper.isLivingEntityInAerialHellPortal(entity);
    }

    public static boolean isLivingEntityReadyToTeleport(LivingEntity entity) {
        return EntityHelper.isLivingEntityUnderAerialHellPortalEffect(entity) && entity.m_21124_((MobEffect)AerialHellMobEffects.AERIAL_HELL_PORTAL.get()).m_19557_() < 20;
    }

    public static void tryTeleportEntityWithAerialHellPortal(Entity entity, BlockPos pos) {
        Level level;
        if (!entity.m_9236_().f_46443_ && !pos.equals((Object)entity.f_19819_)) {
            entity.f_19819_ = pos.m_7949_();
        }
        if ((level = entity.m_9236_()) != null) {
            ServerLevel destinationWorld;
            ResourceKey<Level> destination;
            MinecraftServer minecraftserver = level.m_7654_();
            ResourceKey<Level> resourceKey = destination = entity.m_9236_().m_46472_() == AerialHellDimensions.AERIAL_HELL_DIMENSION ? Level.f_46428_ : AerialHellDimensions.AERIAL_HELL_DIMENSION;
            if (minecraftserver != null && (destinationWorld = minecraftserver.m_129880_(destination)) != null && minecraftserver.m_7079_() && !entity.m_20159_()) {
                entity.m_9236_().m_46473_().m_6180_("aerialhell_portal");
                entity.m_20091_();
                entity.changeDimension(destinationWorld, (ITeleporter)new AerialHellTeleporter(destinationWorld));
                entity.m_9236_().m_46473_().m_7238_();
            }
        }
    }

    public static void addBatParticle(LivingEntity entity, RandomSource rand, int number) {
        for (int i = 0; i < number; ++i) {
            entity.m_9236_().m_7106_((ParticleOptions)AerialHellParticleTypes.SHADOW_TROLL_BAT.get(), entity.m_20185_() + (double)rand.m_188501_() - 0.5, entity.m_20186_() + (double)(2.0f * rand.m_188501_()), entity.m_20189_() + (double)rand.m_188501_() - 0.5, (double)(2.0f * rand.m_188501_()) - 0.5, -0.3, 2.0 * ((double)rand.m_188501_() - 0.5));
        }
    }

    public static boolean isLivingEntityMisleadingLunar(LivingEntity entity) {
        return ItemHelper.getItemInTagCount(entity.m_6168_(), AerialHellTags.Items.LUNATIC_STUFF) >= 4 && !EntityHelper.isLivingEntityATraitor(entity);
    }

    public static boolean isLivingEntityMisleadingShadow(LivingEntity entity) {
        return ItemHelper.getItemInTagCount(entity.m_6168_(), AerialHellTags.Items.SHADOW_ARMOR) >= 4 && !EntityHelper.isLivingEntityATraitor(entity);
    }
}

