/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Item.Tools;

import fr.factionbedrock.aerialhell.Client.Registry.AerialHellParticleTypes;
import fr.factionbedrock.aerialhell.Entity.Projectile.LunaticProjectileEntity;
import fr.factionbedrock.aerialhell.Registry.AerialHellMobEffects;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class EffectToolHelper {
    public static void addParticleOnPlayer(int count, SimpleParticleType particleType, Player playerIn, Level worldIn, Random rand) {
        for (int i = 0; i < count; ++i) {
            worldIn.m_7106_((ParticleOptions)particleType, playerIn.m_20185_() + (double)(4.0f * (rand.nextFloat() - 0.5f)), playerIn.m_20186_() + (double)(4.0f * rand.nextFloat()), playerIn.m_20189_() + (double)(4.0f * (rand.nextFloat() - 0.5f)), 0.0, 0.0, 0.0);
        }
    }

    public static void setDamageAndCooldown(Item ItemIn, ItemStack heldItem, Player playerIn, int cooldown) {
        playerIn.m_36335_().m_41524_(ItemIn, cooldown);
        heldItem.m_41622_(1, (LivingEntity)playerIn, player -> player.m_21190_(playerIn.m_7655_()));
    }

    public static void applyFullVolucitePower(Item ItemIn, ItemStack heldItem, Level worldIn, Player playerIn, Random rand) {
        EffectToolHelper.addParticleOnPlayer(20, ParticleTypes.f_123796_, playerIn, worldIn, rand);
        playerIn.m_5496_(SoundEvents.f_12049_, 1.0f, 1.5f);
        if (!worldIn.m_5776_()) {
            playerIn.m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.HEAD_IN_THE_CLOUDS.get(), 100, 1));
            playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 120, 0));
        }
        EffectToolHelper.setDamageAndCooldown(ItemIn, heldItem, playerIn, 250);
    }

    public static void applyHalfVolucitePower(Item ItemIn, ItemStack heldItem, Level worldIn, Player playerIn, Random rand) {
        EffectToolHelper.addParticleOnPlayer(20, ParticleTypes.f_123796_, playerIn, worldIn, rand);
        playerIn.m_5496_(SoundEvents.f_12049_, 1.0f, 1.6f);
        if (!worldIn.m_5776_()) {
            playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 80, 0));
        }
        EffectToolHelper.setDamageAndCooldown(ItemIn, heldItem, playerIn, 250);
    }

    public static boolean tryToApplyVolucitePower(Item ItemIn, ItemStack heldItem, Level worldIn, Player playerIn, Random rand, boolean canApplyFullPower) {
        int count_volucite = 0;
        int count_heavy = 0;
        for (ItemStack armorStack : playerIn.m_6168_()) {
            if (armorStack.m_204117_(AerialHellTags.Items.VOLUCITE_STUFF)) {
                ++count_volucite;
            }
            if (!armorStack.m_204117_(AerialHellTags.Items.OBSIDIAN_STUFF) && !armorStack.m_204117_(AerialHellTags.Items.ARSONIST_STUFF)) continue;
            ++count_heavy;
        }
        if (canApplyFullPower && count_volucite >= 4) {
            EffectToolHelper.applyFullVolucitePower(ItemIn, heldItem, worldIn, playerIn, rand);
            return true;
        }
        if (count_heavy == 0 || count_volucite > 0) {
            EffectToolHelper.applyHalfVolucitePower(ItemIn, heldItem, worldIn, playerIn, rand);
            return true;
        }
        return false;
    }

    public static void applyNinjaEffect(Item ItemIn, ItemStack heldItem, Level worldIn, Player playerIn, Random rand, int cooldown) {
        EffectToolHelper.addParticleOnPlayer(20, ParticleTypes.f_123796_, playerIn, worldIn, rand);
        playerIn.m_5496_(SoundEvents.f_12049_, 1.0f, 1.6f);
        if (!worldIn.m_5776_()) {
            playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 200, 0));
            playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 120, 0));
        }
        EffectToolHelper.setDamageAndCooldown(ItemIn, heldItem, playerIn, cooldown);
    }

    public static void applyReaperWalkEffect(Item ItemIn, ItemStack heldItem, Level worldIn, Player playerIn, Random rand, int cooldown) {
        EffectToolHelper.addParticleOnPlayer(20, (SimpleParticleType)AerialHellParticleTypes.SHADOW_LIGHT.get(), playerIn, worldIn, rand);
        playerIn.m_5496_(SoundEvents.f_12049_, 1.0f, 1.6f);
        if (!worldIn.m_5776_()) {
            playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 200, 0));
            playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 120, 0));
            playerIn.m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.SHADOW_IMMUNITY.get(), 120, 0));
        }
        EffectToolHelper.setDamageAndCooldown(ItemIn, heldItem, playerIn, cooldown);
    }

    public static void applyRandomEffect(Item ItemIn, ItemStack heldItem, Level worldIn, Player playerIn, Random rand) {
        EffectToolHelper.addParticleOnPlayer(20, ParticleTypes.f_123809_, playerIn, worldIn, rand);
        playerIn.m_5496_(SoundEvents.f_11887_, 1.0f, 1.5f);
        if (!worldIn.m_5776_()) {
            if ((double)rand.nextFloat() < 0.25) {
                playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 750, 0));
            } else if ((double)rand.nextFloat() < 0.3333) {
                playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 750, 0));
            } else if ((double)rand.nextFloat() < 0.5) {
                playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 750, 0));
            } else {
                playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19590_, 750, 0));
                playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60, 0));
            }
        }
        EffectToolHelper.setDamageAndCooldown(ItemIn, heldItem, playerIn, 900);
    }

    public static void applyLunaticLight(Item ItemIn, ItemStack heldItem, Level worldIn, Player playerIn, Random rand, int baseCooldown) {
        int cooldown;
        int count = 0;
        for (ItemStack armorStack : playerIn.m_6168_()) {
            if (!armorStack.m_204117_(AerialHellTags.Items.LUNATIC_STUFF)) continue;
            ++count;
        }
        int n = cooldown = count == 4 ? baseCooldown / 2 : baseCooldown;
        if (!worldIn.m_5776_()) {
            LunaticProjectileEntity lunaticProjectileEntity = new LunaticProjectileEntity(worldIn, (LivingEntity)playerIn, playerIn.m_20154_().f_82479_, playerIn.m_20154_().f_82480_, playerIn.m_20154_().f_82481_, 0.7f, 0.0f);
            lunaticProjectileEntity.m_6034_(playerIn.m_20185_(), playerIn.m_20227_(0.5) + 0.5, playerIn.m_20189_());
            worldIn.m_7967_((Entity)lunaticProjectileEntity);
            playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19613_, cooldown / 2, 2));
        }
        EffectToolHelper.setDamageAndCooldown(ItemIn, heldItem, playerIn, cooldown);
    }

    public static boolean tryRemovingPoisonAndWitherEffect(Item ItemIn, ItemStack heldItem, Level worldIn, Player playerIn, Random rand) {
        boolean playerHasPoison = playerIn.m_21023_(MobEffects.f_19614_);
        boolean playerHasWither = playerIn.m_21023_(MobEffects.f_19615_);
        if (!playerHasPoison && !playerHasWither) {
            return false;
        }
        playerIn.m_5496_(SoundEvents.f_11911_, 1.0f, 1.5f + 0.4f * rand.nextFloat());
        if (playerHasPoison) {
            playerIn.m_21195_(MobEffects.f_19614_);
        }
        if (playerHasWither) {
            playerIn.m_21195_(MobEffects.f_19615_);
        }
        EffectToolHelper.setDamageAndCooldown(ItemIn, heldItem, playerIn, 900);
        return true;
    }

    public static boolean tryEatingTool(Item ItemIn, ItemStack heldItem, Level worldIn, Player playerIn, Random rand) {
        if (playerIn.m_36391_(false)) {
            playerIn.m_5496_(SoundEvents.f_11912_, 1.0f, 0.5f + rand.nextFloat());
            if (!worldIn.m_5776_()) {
                playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19618_, 1, 0));
                playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 40, 0));
            }
            EffectToolHelper.setDamageAndCooldown(ItemIn, heldItem, playerIn, 20);
            return true;
        }
        return false;
    }

    public static void PlayerLiftoff(Item ItemIn, ItemStack heldItem, Level worldIn, Player playerIn, Random rand) {
        int cooldown;
        EffectToolHelper.addParticleOnPlayer(20, ParticleTypes.f_123813_, playerIn, worldIn, rand);
        playerIn.m_5496_(SoundEvents.f_11913_, 1.0f, 0.5f + rand.nextFloat());
        if (playerIn.m_6144_()) {
            if (!worldIn.m_5776_()) {
                playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 1));
                playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 0));
            }
            cooldown = 400;
        } else {
            if (worldIn.m_5776_()) {
                playerIn.m_20256_(playerIn.m_20184_().m_82520_(0.0, 2.0, 0.0));
            } else {
                playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 200, 2));
            }
            cooldown = 600;
        }
        EffectToolHelper.setDamageAndCooldown(ItemIn, heldItem, playerIn, cooldown);
    }

    public static void applyFireResistanceEffect(Item ItemIn, ItemStack heldItem, Level worldIn, Player playerIn, Random rand, int duration, int base_cooldown) {
        EffectToolHelper.addParticleOnPlayer(20, ParticleTypes.f_123744_, playerIn, worldIn, rand);
        playerIn.m_5496_(SoundEvents.f_11914_, 1.0f, 0.5f + rand.nextFloat());
        int cooldown = base_cooldown;
        int count = 0;
        for (ItemStack armorStack : playerIn.m_6168_()) {
            if (!armorStack.m_204117_(AerialHellTags.Items.ARSONIST_STUFF)) continue;
            ++count;
        }
        if (count >= 4) {
            cooldown /= 2;
        }
        if (!worldIn.m_5776_()) {
            playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19607_, duration, 0));
        }
        EffectToolHelper.setDamageAndCooldown(ItemIn, heldItem, playerIn, cooldown);
    }

    public static void applyJumpBoostEffect(Item ItemIn, ItemStack heldItem, Level worldIn, Player playerIn, Random rand, int duration, int amplifier) {
        EffectToolHelper.addParticleOnPlayer(20, ParticleTypes.f_123784_, playerIn, worldIn, rand);
        playerIn.m_5496_(SoundEvents.f_12258_, 1.0f, 0.5f + rand.nextFloat());
        if (!worldIn.m_5776_()) {
            playerIn.m_7292_(new MobEffectInstance(MobEffects.f_19603_, duration, amplifier));
        }
        EffectToolHelper.setDamageAndCooldown(ItemIn, heldItem, playerIn, 400);
    }

    public static class PassiveEffects {
        public static void applyMagmaCubeEffect(LivingEntity entityIn) {
            entityIn.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 400, 0));
        }

        public static void applyGodEffect(LivingEntity entityIn) {
            entityIn.m_7292_(new MobEffectInstance((MobEffect)AerialHellMobEffects.GOD.get(), 400, 0));
        }
    }
}

