/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Item.Tools;

import fr.factionbedrock.aerialhell.Item.Tools.EffectAxeItem;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BerserkAxeItem
extends EffectAxeItem {
    private int weight_ticks = 0;

    public BerserkAxeItem(Tier tier, float attackDamageIn, float attackSpeedIn, float movementSpeedIn, float maxHealthIn, Item.Properties builderIn) {
        super(tier, attackDamageIn, attackSpeedIn, movementSpeedIn, maxHealthIn, builderIn);
    }

    public int getStatus() {
        if (this.weight_ticks == 0) {
            return 0;
        }
        if (this.weight_ticks <= 200) {
            return 1;
        }
        if (this.weight_ticks <= 600) {
            return 2;
        }
        if (this.weight_ticks <= 800) {
            return 3;
        }
        return 4;
    }

    protected void increaseWeight() {
        if (this.weight_ticks <= 200) {
            this.weight_ticks += 100;
        } else if (this.weight_ticks <= 1200) {
            this.weight_ticks += 200;
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldItem = playerIn.m_21120_(handIn);
        Random rand = new Random();
        int cooldown = Math.min(this.getStatus() + 1, 3) * 200;
        this.weight_ticks = this.weight_ticks >= 200 ? (this.weight_ticks -= 200) : 0;
        for (int i = 0; i < 20; ++i) {
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123762_, playerIn.m_20185_() + (double)(4.0f * (rand.nextFloat() - 0.5f)), playerIn.m_20186_() + (double)(4.0f * rand.nextFloat()), playerIn.m_20189_() + (double)(4.0f * (rand.nextFloat() - 0.5f)), 0.0, 0.0, 0.0);
        }
        playerIn.m_5496_(SoundEvents.f_12363_, 1.0f, 0.5f + rand.nextFloat());
        if (worldIn.m_5776_()) {
            Vec3 forward = playerIn.m_20156_().m_82542_(1.7, 1.3, 1.7);
            if (forward.f_82480_ < 1.0) {
                forward = new Vec3(forward.f_82479_, 1.0, forward.f_82481_);
            }
            playerIn.m_20256_(playerIn.m_20184_().m_82549_(forward));
        }
        playerIn.m_36335_().m_41524_((Item)this, cooldown);
        heldItem.m_41622_(1, (LivingEntity)playerIn, player -> player.m_21190_(playerIn.m_7655_()));
        return InteractionResultHolder.m_19096_((Object)heldItem);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.increaseWeight();
        return super.m_7579_(stack, target, attacker);
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this.weight_ticks > 800) {
            --this.weight_ticks;
        } else if (this.weight_ticks > 0) {
            this.weight_ticks -= 2;
        }
        if (isSelected) {
            this.giveEntityEffect(worldIn, entityIn);
        }
    }

    private void giveEntityEffect(Level worldIn, Entity entityIn) {
        if (!worldIn.m_5776_() && entityIn instanceof LivingEntity) {
            LivingEntity livingEntityIn = (LivingEntity)entityIn;
            int weight = this.getStatus();
            if (weight == 0) {
                livingEntityIn.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 22, 1, false, false));
                livingEntityIn.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 22, 1, false, false));
                livingEntityIn.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 22, 1, false, false));
            } else if (weight == 1) {
                livingEntityIn.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 22, 0, false, false));
                livingEntityIn.m_7292_(new MobEffectInstance(MobEffects.f_19598_, 22, 0, false, false));
            } else if (weight == 2) {
                livingEntityIn.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 22, 0, false, false));
            } else if (weight == 3) {
                livingEntityIn.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 22, 0, false, false));
                livingEntityIn.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 22, 1, false, false));
            } else {
                livingEntityIn.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 22, 0, false, false));
                livingEntityIn.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 22, 1, false, false));
                livingEntityIn.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 22, 3, false, false));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)this.getDescription().m_130946_(Integer.toString(this.getStatus())).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getDescription() {
        return Component.m_237115_((String)(this.m_5524_() + ".desc"));
    }
}

