/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Event.Listeners;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fr.factionbedrock.aerialhell.Block.DungeonCores.DungeonCoreBlock;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.Registry.Worldgen.AerialHellDimensions;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber
public class BlockEventListener {
    private static final ResourceLocation TEXTURE_WHITE_SOLID_ETHER = new ResourceLocation("aerialhell", "textures/block/white_solid_ether.png");
    private static final ResourceLocation TEXTURE_BLUE_SOLID_ETHER = new ResourceLocation("aerialhell", "textures/block/blue_solid_ether.png");
    private static final ResourceLocation TEXTURE_GOLDEN_SOLID_ETHER = new ResourceLocation("aerialhell", "textures/block/golden_solid_ether.png");
    private static final ResourceLocation TEXTURE_GREEN_SOLID_ETHER = new ResourceLocation("aerialhell", "textures/block/green_solid_ether.png");
    private static final ResourceLocation TEXTURE_PURPLE_SOLID_ETHER = new ResourceLocation("aerialhell", "textures/block/purple_solid_ether.png");

    @SubscribeEvent
    public static void onBlockEvent(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level world = (Level)levelAccessor;
            BlockPos pos = event.getPos();
            FluidState fluidstate = world.m_6425_(pos);
            BlockState blockstate = world.m_8055_(pos);
            if (world.m_46472_() == AerialHellDimensions.AERIAL_HELL_DIMENSION) {
                if (fluidstate.m_76152_().m_205067_(AerialHellTags.Fluids.CRYSTALLIZABLE)) {
                    world.m_46597_(pos, ((Block)AerialHellBlocksAndItems.CRYSTAL_BLOCK.get()).m_49966_());
                    world.m_5594_(null, event.getPos(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    event.setCanceled(true);
                } else if (blockstate.m_60734_().equals(Blocks.f_50450_)) {
                    world.m_46597_(pos, ((Block)AerialHellBlocksAndItems.MAGMATIC_GEL_ORE.get()).m_49966_());
                    world.m_5594_(null, event.getPos(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    event.setCanceled(true);
                } else if (blockstate.m_60734_().equals(Blocks.f_50083_) || blockstate.m_60734_().equals(Blocks.f_50084_)) {
                    world.m_46597_(pos, ((Block)AerialHellBlocksAndItems.CRYSTALLIZED_FIRE.get()).m_49966_());
                    world.m_5594_(null, event.getPos(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (world.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50016_) {
                        world.m_46961_(pos, true);
                    }
                    event.setCanceled(true);
                } else if (blockstate.m_60734_().equals(Blocks.f_50081_) || blockstate.m_60734_().equals(Blocks.f_50082_) || blockstate.m_204336_(AerialHellTags.Blocks.OVERWORLD_LANTERN)) {
                    world.m_46961_(pos, true);
                    world.m_5594_(null, event.getPos(), SoundEvents.f_11937_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockEvent(BlockEvent.EntityPlaceEvent event) {
        BlockPos pos;
        Level world;
        BlockState blockstate;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level && (blockstate = (world = (Level)levelAccessor).m_8055_(pos = event.getPos())).m_204336_(AerialHellTags.Blocks.DUNGEON_CORES)) {
            ((DungeonCoreBlock)blockstate.m_60734_()).setAreaProtected(world, pos, true);
            world.m_5594_(null, event.getPos(), SoundEvents.f_11736_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onOverlay(RenderBlockScreenEffectEvent event) {
        if (event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.BLOCK) {
            Player player = event.getPlayer();
            PoseStack matrixStack = event.getPoseStack();
            if (event.getBlockState().m_204336_(AerialHellTags.Blocks.SOLID_ETHER)) {
                event.setCanceled(true);
                if (event.getBlockState().m_60713_((Block)AerialHellBlocksAndItems.WHITE_SOLID_ETHER.get())) {
                    BlockEventListener.renderEther(player, matrixStack, TEXTURE_WHITE_SOLID_ETHER);
                } else if (event.getBlockState().m_60713_((Block)AerialHellBlocksAndItems.BLUE_SOLID_ETHER.get())) {
                    BlockEventListener.renderEther(player, matrixStack, TEXTURE_BLUE_SOLID_ETHER);
                } else if (event.getBlockState().m_60713_((Block)AerialHellBlocksAndItems.GOLDEN_SOLID_ETHER.get())) {
                    BlockEventListener.renderEther(player, matrixStack, TEXTURE_GOLDEN_SOLID_ETHER);
                } else if (event.getBlockState().m_60713_((Block)AerialHellBlocksAndItems.GREEN_SOLID_ETHER.get())) {
                    BlockEventListener.renderEther(player, matrixStack, TEXTURE_GREEN_SOLID_ETHER);
                } else if (event.getBlockState().m_60713_((Block)AerialHellBlocksAndItems.PURPLE_SOLID_ETHER.get())) {
                    BlockEventListener.renderEther(player, matrixStack, TEXTURE_PURPLE_SOLID_ETHER);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderEther(Player player, PoseStack matrixStackIn, ResourceLocation texture) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        BlockPos blockpos = BlockPos.m_274561_((double)player.m_20185_(), (double)player.m_20188_(), (double)player.m_20189_());
        float brightness = LightTexture.m_234316_((DimensionType)player.m_9236_().m_6042_(), (int)player.m_9236_().m_46803_(blockpos));
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        float yaw = -player.m_146908_() / 64.0f;
        float pitch = player.m_146909_() / 64.0f;
        Matrix4f matrix4f = matrixStackIn.m_85850_().m_252922_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_252986_(matrix4f, -1.0f, -1.0f, -0.5f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(4.0f + yaw, 4.0f + pitch).m_5752_();
        bufferbuilder.m_252986_(matrix4f, 1.0f, -1.0f, -0.5f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(0.0f + yaw, 4.0f + pitch).m_5752_();
        bufferbuilder.m_252986_(matrix4f, 1.0f, 1.0f, -0.5f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(0.0f + yaw, 0.0f + pitch).m_5752_();
        bufferbuilder.m_252986_(matrix4f, -1.0f, 1.0f, -0.5f).m_85950_(brightness, brightness, brightness, 1.0f).m_7421_(4.0f + yaw, 0.0f + pitch).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }
}

