/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.Passive;

import com.google.common.collect.Lists;
import fr.factionbedrock.aerialhell.Client.Registry.AerialHellParticleTypes;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class FatPhantomEntity
extends Phantom
implements Enemy {
    public List<Player> attackingPlayers = Lists.newArrayList();
    private Vec3 orbitOffset = Vec3.f_82478_;
    private BlockPos orbitPosition = BlockPos.f_121853_;
    private AttackPhase attackPhase = AttackPhase.CIRCLE;
    public static final EntityDataAccessor<Boolean> DISAPPEARING = SynchedEntityData.m_135353_(FatPhantomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int timeDisappearing;

    public FatPhantomEntity(EntityType<? extends FatPhantomEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 5;
        this.f_21342_ = new MoveHelperController((Mob)this);
        this.f_21365_ = new LookHelperController((Mob)this);
    }

    public static boolean canSpawn(EntityType<FatPhantomEntity> type, ServerLevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.m_46791_() != Difficulty.PEACEFUL && worldIn.m_6018_().m_46461_() && randomIn.m_188503_(120) == 0 && FatPhantomEntity.m_217057_(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    protected BodyRotationControl m_7560_() {
        return new BodyHelperController((Mob)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PickAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new SweepAttackGoal());
        this.f_21345_.m_25352_(3, (Goal)new OrbitPointGoal());
        this.f_21346_.m_25352_(1, (Goal)new AttackAttackingPlayerGoal());
    }

    protected boolean m_8028_() {
        return false;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return FlyingMob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22281_, 18.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 64.0);
    }

    public boolean m_7327_(Entity entityIn) {
        Player playerIn;
        if (entityIn instanceof Player && !this.attackingPlayers.isEmpty() && this.attackingPlayers.contains(playerIn = (Player)entityIn)) {
            this.attackingPlayers.remove(playerIn);
        }
        return super.m_7327_(entityIn);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!source.m_276093_(DamageTypes.f_268515_)) {
            List targetable_players;
            if (source.m_7640_() instanceof Player) {
                Player player = (Player)source.m_7640_();
                this.attackingPlayers.add(player);
            } else if (source.m_7640_() instanceof Projectile && !(targetable_players = this.m_9236_().m_45955_(TargetingConditions.m_148352_().m_26883_(64.0), (LivingEntity)this, this.m_20191_().m_82377_(16.0, 64.0, 16.0))).isEmpty()) {
                for (Player player : targetable_players) {
                    this.attackingPlayers.add(player);
                }
            }
        }
        return super.m_6469_(source, amount);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DISAPPEARING, (Object)false);
    }

    public int getDefaultFatPhantomSize() {
        return 12;
    }

    private void updatePhantomSize() {
        this.m_6210_();
        this.m_21051_(Attributes.f_22281_).m_22100_((double)Math.max(16 + this.m_33172_() - this.getDefaultFatPhantomSize(), 16));
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.35f;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (f_33095_.equals(key)) {
            this.updatePhantomSize();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            float f = Mth.m_14089_((float)((float)(this.m_19879_() * 3 + this.f_19797_) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            float f1 = Mth.m_14089_((float)((float)(this.m_19879_() * 3 + this.f_19797_ + 1) * 7.448451f * ((float)Math.PI / 180) + (float)Math.PI));
            if (f > 0.0f && f1 <= 0.0f) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12230_, this.m_5720_(), 0.95f + this.f_19796_.m_188501_() * 0.05f, 0.95f + this.f_19796_.m_188501_() * 0.05f, false);
            }
            int i = this.m_33172_();
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float f4 = (0.3f + f * 0.45f) * ((float)i * 0.2f + 1.0f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() + (double)f2, this.m_20186_() + (double)f4, this.m_20189_() + (double)f3, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() - (double)f2, this.m_20186_() + (double)f4, this.m_20189_() - (double)f3, 0.0, 0.0, 0.0);
        }
        if (this.isDisappearing()) {
            if (this.timeDisappearing < 190) {
                this.addFatPhantomParticle(1);
            } else if (this.timeDisappearing < 200) {
                this.addFatPhantomParticle(10);
            } else {
                this.m_146870_();
            }
            ++this.timeDisappearing;
        }
    }

    private void addFatPhantomParticle(int number) {
        for (int i = 0; i < number; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)AerialHellParticleTypes.FAT_PHANTOM_SMOKE.get(), this.m_20185_() + (double)this.f_19796_.m_188501_() - 0.5, this.m_20186_() + (double)(2.0f * this.f_19796_.m_188501_()), this.m_20189_() + (double)this.f_19796_.m_188501_() - 0.5, (double)this.f_19796_.m_188501_() - 0.5, (double)this.f_19796_.m_188501_() - 0.5, (double)this.f_19796_.m_188501_() - 0.5);
        }
    }

    public boolean m_5825_() {
        return false;
    }

    protected boolean m_21527_() {
        return false;
    }

    public void m_8107_() {
        if (!this.m_9236_().m_46461_() && !this.isDisappearing()) {
            this.timeDisappearing = 0;
            this.setDisappearing(true);
        }
        super.m_8107_();
    }

    public boolean isDisappearing() {
        return (Boolean)this.f_19804_.m_135370_(DISAPPEARING);
    }

    public void setDisappearing(boolean flag) {
        this.f_19804_.m_135381_(DISAPPEARING, (Object)flag);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.orbitPosition = this.m_20183_().m_6630_(6);
        this.m_33108_(10 + this.f_19796_.m_188503_(6));
        if (worldIn.m_8055_(this.m_20183_().m_7494_()).m_60734_() == Blocks.f_50016_) {
            this.m_20219_(new Vec3((double)this.m_20183_().m_7494_().m_123341_(), (double)this.m_20183_().m_7494_().m_123342_(), (double)this.m_20183_().m_7494_().m_123343_()));
        }
        this.timeDisappearing = 0;
        this.setDisappearing(false);
        return data;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("AX")) {
            this.orbitPosition = new BlockPos(compound.m_128451_("AX"), compound.m_128451_("AY"), compound.m_128451_("AZ"));
        }
        this.setDisappearing(compound.m_128471_("Disappearing"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("AX", this.orbitPosition.m_123341_());
        compound.m_128405_("AY", this.orbitPosition.m_123342_());
        compound.m_128405_("AZ", this.orbitPosition.m_123343_());
        compound.m_128379_("Disappearing", this.isDisappearing());
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        int i = this.m_33172_();
        EntityDimensions entitysize = super.m_6972_(poseIn);
        float f = (entitysize.f_20377_ + 0.2f * (float)i) / entitysize.f_20377_;
        return entitysize.m_20388_(f);
    }

    static enum AttackPhase {
        CIRCLE,
        SWOOP;

    }

    class MoveHelperController
    extends MoveControl {
        private float speedFactor;

        public MoveHelperController(Mob entityIn) {
            super(entityIn);
            this.speedFactor = 0.1f;
        }

        public void m_8126_() {
            if (FatPhantomEntity.this.f_19862_) {
                FatPhantomEntity.this.m_146922_(FatPhantomEntity.this.m_146908_() + 180.0f);
                this.speedFactor = 0.1f;
            }
            double d0 = FatPhantomEntity.this.orbitOffset.f_82479_ - FatPhantomEntity.this.m_20185_();
            double d1 = FatPhantomEntity.this.orbitOffset.f_82480_ - FatPhantomEntity.this.m_20186_();
            double d2 = FatPhantomEntity.this.orbitOffset.f_82481_ - FatPhantomEntity.this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            if (Math.abs(d3) > (double)1.0E-5f) {
                double d4 = 1.0 - Math.abs(d1 * (double)0.7f) / d3;
                d3 = Math.sqrt((d0 *= d4) * d0 + (d2 *= d4) * d2);
                double d5 = Math.sqrt(d0 * d0 + d2 * d2 + d1 * d1);
                float f = FatPhantomEntity.this.m_146908_();
                float f1 = (float)Mth.m_14136_((double)d2, (double)d0);
                float f2 = Mth.m_14177_((float)(FatPhantomEntity.this.m_146908_() + 90.0f));
                float f3 = Mth.m_14177_((float)(f1 * 57.295776f));
                FatPhantomEntity.this.m_146922_(Mth.m_14148_((float)f2, (float)f3, (float)4.0f) - 90.0f);
                FatPhantomEntity.this.f_20883_ = FatPhantomEntity.this.m_146908_();
                this.speedFactor = Mth.m_14145_((float)f, (float)FatPhantomEntity.this.m_146908_()) < 3.0f ? Mth.m_14121_((float)this.speedFactor, (float)1.8f, (float)(0.005f * (1.8f / this.speedFactor))) : Mth.m_14121_((float)this.speedFactor, (float)0.2f, (float)0.025f);
                float f4 = (float)(-(Mth.m_14136_((double)(-d1), (double)d3) * 57.2957763671875));
                FatPhantomEntity.this.m_146926_(f4);
                float f5 = FatPhantomEntity.this.m_146908_() + 90.0f;
                double d6 = (double)(this.speedFactor * Mth.m_14089_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d0 / d5);
                double d7 = (double)(this.speedFactor * Mth.m_14031_((float)(f5 * ((float)Math.PI / 180)))) * Math.abs(d2 / d5);
                double d8 = (double)(this.speedFactor * Mth.m_14031_((float)(f4 * ((float)Math.PI / 180)))) * Math.abs(d1 / d5);
                Vec3 vec3 = FatPhantomEntity.this.m_20184_();
                FatPhantomEntity.this.m_20256_(vec3.m_82549_(new Vec3(d6, d8, d7).m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    class LookHelperController
    extends LookControl {
        public LookHelperController(Mob entityIn) {
            super(entityIn);
        }

        public void m_8128_() {
        }
    }

    class BodyHelperController
    extends BodyRotationControl {
        public BodyHelperController(Mob mob) {
            super(mob);
        }

        public void m_8121_() {
            FatPhantomEntity.this.f_20885_ = FatPhantomEntity.this.f_20883_;
            FatPhantomEntity.this.f_20883_ = FatPhantomEntity.this.m_146908_();
        }
    }

    class PickAttackGoal
    extends Goal {
        private int nextSweepTick;

        PickAttackGoal() {
        }

        public boolean m_8036_() {
            LivingEntity livingentity = FatPhantomEntity.this.m_5448_();
            return livingentity != null ? FatPhantomEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }

        public void m_8056_() {
            this.nextSweepTick = this.m_183277_(10);
            FatPhantomEntity.this.attackPhase = AttackPhase.CIRCLE;
            this.setAnchorAboveTarget();
        }

        public void m_8041_() {
            FatPhantomEntity.this.orbitPosition = FatPhantomEntity.this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, FatPhantomEntity.this.orbitPosition).m_6630_(10 + FatPhantomEntity.this.f_19796_.m_188503_(20));
        }

        public void m_8037_() {
            if (FatPhantomEntity.this.attackPhase == AttackPhase.CIRCLE) {
                --this.nextSweepTick;
                if (this.nextSweepTick <= 0) {
                    FatPhantomEntity.this.attackPhase = AttackPhase.SWOOP;
                    this.setAnchorAboveTarget();
                    this.nextSweepTick = this.m_183277_((8 + FatPhantomEntity.this.f_19796_.m_188503_(4)) * 20);
                    FatPhantomEntity.this.m_5496_(SoundEvents.f_12232_, 10.0f, 0.95f + FatPhantomEntity.this.f_19796_.m_188501_() * 0.1f);
                }
            }
        }

        private void setAnchorAboveTarget() {
            FatPhantomEntity.this.orbitPosition = FatPhantomEntity.this.m_5448_().m_20183_().m_6630_(20 + FatPhantomEntity.this.f_19796_.m_188503_(20));
            if (FatPhantomEntity.this.orbitPosition.m_123342_() < FatPhantomEntity.this.m_9236_().m_5736_()) {
                FatPhantomEntity.this.orbitPosition = new BlockPos(FatPhantomEntity.this.orbitPosition.m_123341_(), FatPhantomEntity.this.m_9236_().m_5736_() + 1, FatPhantomEntity.this.orbitPosition.m_123343_());
            }
        }
    }

    class SweepAttackGoal
    extends MoveGoal {
        private SweepAttackGoal() {
        }

        public boolean m_8036_() {
            return FatPhantomEntity.this.m_5448_() != null && FatPhantomEntity.this.attackPhase == AttackPhase.SWOOP;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = FatPhantomEntity.this.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!(livingentity instanceof Player) || !((Player)livingentity).m_5833_() && !((Player)livingentity).m_7500_()) {
                return this.m_8036_();
            }
            return false;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
            FatPhantomEntity.this.m_6710_(null);
            FatPhantomEntity.this.attackPhase = AttackPhase.CIRCLE;
        }

        public void m_8037_() {
            LivingEntity livingentity = FatPhantomEntity.this.m_5448_();
            FatPhantomEntity.this.orbitOffset = new Vec3(livingentity.m_20185_(), livingentity.m_20227_(0.5), livingentity.m_20189_());
            if (FatPhantomEntity.this.m_20191_().m_82400_((double)0.2f).m_82381_(livingentity.m_20191_())) {
                FatPhantomEntity.this.m_7327_((Entity)livingentity);
                FatPhantomEntity.this.attackPhase = AttackPhase.CIRCLE;
                if (!FatPhantomEntity.this.m_20067_()) {
                    FatPhantomEntity.this.m_9236_().m_46796_(1039, FatPhantomEntity.this.m_20183_(), 0);
                }
            } else if (FatPhantomEntity.this.f_19862_ || FatPhantomEntity.this.f_20916_ > 0) {
                FatPhantomEntity.this.attackPhase = AttackPhase.CIRCLE;
            }
        }
    }

    class OrbitPointGoal
    extends MoveGoal {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        OrbitPointGoal() {
        }

        public boolean m_8036_() {
            return FatPhantomEntity.this.m_5448_() == null || FatPhantomEntity.this.attackPhase == AttackPhase.CIRCLE;
        }

        public void m_8056_() {
            this.distance = 5.0f + FatPhantomEntity.this.f_19796_.m_188501_() * 10.0f;
            this.height = -4.0f + FatPhantomEntity.this.f_19796_.m_188501_() * 9.0f;
            this.clockwise = FatPhantomEntity.this.f_19796_.m_188499_() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void m_8037_() {
            if (FatPhantomEntity.this.f_19796_.m_188503_(this.m_183277_(350)) == 0) {
                this.height = -4.0f + FatPhantomEntity.this.f_19796_.m_188501_() * 9.0f;
            }
            if (FatPhantomEntity.this.f_19796_.m_188503_(this.m_183277_(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (FatPhantomEntity.this.f_19796_.m_188503_(this.m_183277_(450)) == 0) {
                this.angle = FatPhantomEntity.this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (FatPhantomEntity.this.orbitOffset.f_82480_ < FatPhantomEntity.this.m_20186_() && !FatPhantomEntity.this.m_9236_().m_46859_(FatPhantomEntity.this.m_20183_().m_6625_(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (FatPhantomEntity.this.orbitOffset.f_82480_ > FatPhantomEntity.this.m_20186_() && !FatPhantomEntity.this.m_9236_().m_46859_(FatPhantomEntity.this.m_20183_().m_6630_(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (BlockPos.f_121853_.equals((Object)FatPhantomEntity.this.orbitPosition)) {
                FatPhantomEntity.this.orbitPosition = FatPhantomEntity.this.m_20183_();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            FatPhantomEntity.this.orbitOffset = Vec3.m_82528_((Vec3i)FatPhantomEntity.this.orbitPosition).m_82520_((double)(this.distance * Mth.m_14089_((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * Mth.m_14031_((float)this.angle)));
        }
    }

    class AttackAttackingPlayerGoal
    extends Goal {
        private final TargetingConditions attackTargeting = TargetingConditions.m_148352_().m_26883_(64.0);
        private int tickDelay = 20;

        private AttackAttackingPlayerGoal() {
        }

        public boolean m_8036_() {
            if (this.tickDelay > 0) {
                --this.tickDelay;
                return false;
            }
            this.tickDelay = 60;
            List list = FatPhantomEntity.this.m_9236_().m_45955_(this.attackTargeting, (LivingEntity)FatPhantomEntity.this, FatPhantomEntity.this.m_20191_().m_82377_(16.0, 64.0, 16.0));
            if (!FatPhantomEntity.this.attackingPlayers.isEmpty() && !list.isEmpty()) {
                list.sort(Comparator.comparing(Entity::m_20186_).reversed());
                for (Player player : list) {
                    if (!FatPhantomEntity.this.m_21040_((LivingEntity)player, TargetingConditions.f_26872_) || !FatPhantomEntity.this.attackingPlayers.contains(player)) continue;
                    FatPhantomEntity.this.m_6710_((LivingEntity)player);
                    return true;
                }
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = FatPhantomEntity.this.m_5448_();
            return livingentity != null ? FatPhantomEntity.this.m_21040_(livingentity, TargetingConditions.f_26872_) : false;
        }
    }

    abstract class MoveGoal
    extends Goal {
        public MoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected boolean touchingTarget() {
            return FatPhantomEntity.this.orbitOffset.m_82531_(FatPhantomEntity.this.m_20185_(), FatPhantomEntity.this.m_20186_(), FatPhantomEntity.this.m_20189_()) < 4.0;
        }
    }
}

