/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.Bosses;

import fr.factionbedrock.aerialhell.Client.Registry.AerialHellParticleTypes;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveLeapAtTargetGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveMeleeAttackGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveNearestAttackableTargetGoal;
import fr.factionbedrock.aerialhell.Entity.AI.ActiveWaterAvoidingRandomWalkingGoal;
import fr.factionbedrock.aerialhell.Entity.AI.GhastLikeGoals;
import fr.factionbedrock.aerialhell.Entity.AbstractBossEntity;
import fr.factionbedrock.aerialhell.Entity.Bosses.MudCycleMageEntity;
import fr.factionbedrock.aerialhell.Entity.Projectile.ChainedGodFireballEntity;
import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.AerialHellSoundEvents;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellTags;
import fr.factionbedrock.aerialhell.Util.EntityHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class ChainedGodEntity
extends AbstractBossEntity {
    public int attackTimer = 0;
    private static final EntityDataAccessor<Boolean> IMPLODING = SynchedEntityData.m_135353_(ChainedGodEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> UNCHAINING = SynchedEntityData.m_135353_(ChainedGodEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> UNCHAINED = SynchedEntityData.m_135353_(ChainedGodEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public ChainedGodEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
        this.f_20916_ = 0;
        this.bossInfo.m_6451_(BossEvent.BossBarColor.RED);
        this.bossInfo.m_5648_(BossEvent.BossBarOverlay.NOTCHED_6);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(2, new ActiveNearestAttackableTargetGoal<Player>(this, Player.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(0, (Goal)new UnchainHimselfGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new ChainedGodRandomFireballAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ChainedGodImplodeGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ChainedGodFireballAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ChainedGodMeleeAttackGoal(this, 1.25, false));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(5, (Goal)new ChainedGodWaterAvoidingRandomWalkingGoal(this, 0.6));
        this.f_21345_.m_25352_(6, (Goal)new ChainedGodLeapAtTargetGoal(this, 0.7f));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, MudCycleMageEntity.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1400.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 0.2).m_22268_(Attributes.f_22282_, 6.0).m_22268_(Attributes.f_22281_, 25.0);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Entity immediateSourceEntity = source.m_7640_();
        Entity trueSourceEntity = source.m_7639_();
        if ((this.isImploding() || this.isUnchaining()) && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        if (!this.isHealthMatchToGetProjectileDamages() && immediateSourceEntity instanceof AbstractArrow) {
            return false;
        }
        boolean flag = super.m_6469_(source, amount);
        if (!(!flag || !(trueSourceEntity instanceof LivingEntity) || immediateSourceEntity instanceof AbstractArrow || trueSourceEntity instanceof Player && ((Player)trueSourceEntity).m_7500_())) {
            this.m_6710_((LivingEntity)trueSourceEntity);
        }
        return flag;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IMPLODING, (Object)false);
        this.f_19804_.m_135372_(UNCHAINING, (Object)false);
        this.f_19804_.m_135372_(UNCHAINED, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Imploding", this.isImploding());
        compound.m_128379_("Unchaining", this.isUnchaining());
        if (this.isUnchained()) {
            compound.m_128379_("Unchained", true);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setImploding(compound.m_128471_("Imploding"));
        this.setUnchaining(compound.m_128471_("Unchaining"));
        this.setUnchained(compound.m_128471_("Unchained"));
    }

    public boolean isImploding() {
        return (Boolean)this.f_19804_.m_135370_(IMPLODING);
    }

    public void setImploding(boolean isImploding) {
        this.f_19804_.m_135381_(IMPLODING, (Object)isImploding);
    }

    public boolean isUnchaining() {
        return (Boolean)this.f_19804_.m_135370_(UNCHAINING);
    }

    public void setUnchaining(boolean isUnchaining) {
        this.f_19804_.m_135381_(UNCHAINING, (Object)isUnchaining);
    }

    public boolean isUnchained() {
        return (Boolean)this.f_19804_.m_135370_(UNCHAINED);
    }

    public void setUnchained(boolean isUnchained) {
        this.f_19804_.m_135381_(UNCHAINED, (Object)isUnchained);
    }

    public boolean m_5825_() {
        return true;
    }

    public boolean m_6051_() {
        return false;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    @Override
    public void m_8119_() {
        if ((double)this.f_19796_.m_188501_() > 0.5 && this.m_9236_().m_5776_()) {
            this.spawnParticles((SimpleParticleType)AerialHellParticleTypes.GOD_FLAME.get(), 1, -0.06);
        }
        if (this.isImploding() || this.isUnchaining()) {
            this.runRoarEffects(this.isImploding());
        }
        this.destroyObstacles();
        super.m_8119_();
    }

    @Override
    public Item getTrophy() {
        return (Item)AerialHellBlocksAndItems.CHAINED_GOD_TROPHY_ITEM.get();
    }

    protected void runRoarEffects(boolean dragEntities) {
        if (dragEntities) {
            this.dragEntities();
        }
        if (this.m_9236_().m_5776_()) {
            this.spawnParticles(ParticleTypes.f_123756_, 5, 0.5);
        }
    }

    protected void dragEntities() {
        List nearbyEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(20.0), EntitySelector.m_20410_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)15.0));
        for (Entity entity : nearbyEntities) {
            if (!(entity instanceof LivingEntity) || EntityHelper.isCreaOrSpecPlayer(entity)) continue;
            this.dragEntity(entity);
        }
    }

    protected void dragEntity(Entity entityIn) {
        double factor = 0.8 / (double)Math.max(5.0f, this.m_20270_(entityIn));
        Vec3 toGod = new Vec3(this.m_20185_() - entityIn.m_20185_(), this.m_20186_() - entityIn.m_20186_(), this.m_20189_() - entityIn.m_20189_()).m_82542_(factor, factor, factor);
        entityIn.m_20256_(entityIn.m_20184_().m_82549_(toGod.m_82542_(factor, factor, factor)));
    }

    private void spawnParticles(SimpleParticleType type, int number, double dy) {
        for (int i = 0; i < number; ++i) {
            double rand = this.f_19796_.m_188501_() * 2.0f;
            double x = this.m_20185_() + (double)(this.f_19796_.m_188501_() - 0.5f) * rand;
            double y = this.m_20191_().f_82289_ + rand + 0.5;
            double z = this.m_20189_() + (double)(this.f_19796_.m_188501_() - 0.5f) * rand;
            double dx = (this.f_19796_.m_188501_() - 0.5f) / 10.0f;
            double dz = (this.f_19796_.m_188501_() - 0.5f) / 10.0f;
            this.m_9236_().m_7106_((ParticleOptions)type, x, y, z, dx, dy, dz);
        }
    }

    private void destroyObstacles() {
        BlockPos pos = this.m_20183_().m_7494_();
        int xzRadius = 3;
        int yRadius = 3;
        for (int x = -xzRadius; x <= xzRadius; ++x) {
            for (int y = -yRadius; y <= yRadius; ++y) {
                for (int z = -xzRadius; z <= xzRadius; ++z) {
                    if (!this.m_9236_().m_8055_(pos.m_7918_(x, y, z)).m_204336_(AerialHellTags.Blocks.CHAINED_GOD_CAN_WALK_DESTROY)) continue;
                    this.m_9236_().m_46961_(pos.m_7918_(x, y, z), this.f_19796_.m_188503_(3) > 1);
                }
            }
        }
    }

    public void m_8107_() {
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        super.m_8107_();
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_7327_(Entity attackedEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float amount = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.m_188503_((int)f) : f;
        float kb = (float)this.m_21133_(Attributes.f_22282_);
        boolean flag = attackedEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), amount);
        if (flag) {
            ((LivingEntity)attackedEntity).m_147240_((double)(kb * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
            attackedEntity.m_20334_(attackedEntity.m_20184_().f_82479_, (double)0.8f, attackedEntity.m_20184_().f_82481_);
            this.m_19970_((LivingEntity)this, attackedEntity);
        }
        this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        return flag;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.m_5496_(SoundEvents.f_12057_, 1.0f, 1.0f);
        } else {
            super.m_7822_(id);
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_CHAINED_GOD_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_CHAINED_GOD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AerialHellSoundEvents.ENTITY_CHAINED_GOD_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        if (!blockIn.m_278721_()) {
            this.m_5496_((SoundEvent)AerialHellSoundEvents.ENTITY_CHAINED_GOD_STEP.get(), 0.5f, 0.8f + 0.5f * this.f_19796_.m_188501_());
        }
    }

    public boolean isHealthMatchToGetProjectileDamages() {
        return this.m_21223_() * 3.0f > this.m_21233_();
    }

    public boolean isHealthMatchToShootFireballs() {
        return this.m_21223_() * 2.0f < this.m_21233_();
    }

    public boolean isHealthMatchToImplode() {
        return this.m_21223_() * 2.0f < this.m_21233_();
    }

    public static class UnchainHimselfGoal
    extends Goal {
        private final ChainedGodEntity goalOwner;
        public int timeSinceUnchaining;

        public UnchainHimselfGoal(ChainedGodEntity entity) {
            this.goalOwner = entity;
        }

        public boolean m_8036_() {
            return !this.goalOwner.isUnchained() && this.goalOwner.isActive();
        }

        public void m_8056_() {
            this.resetTask();
        }

        public void m_8041_() {
            this.resetTask();
        }

        public void m_8037_() {
            if (!this.goalOwner.isUnchaining()) {
                this.startUnchaining();
            } else {
                this.playUnchainingEffect();
                ++this.timeSinceUnchaining;
                if (this.canUnchain()) {
                    this.finishUnchaining();
                }
            }
        }

        protected void startUnchaining() {
            this.immobilizeGoalOwner();
            this.goalOwner.setUnchaining(true);
            this.playStartUnchainingEffect();
        }

        protected void finishUnchaining() {
            this.goalOwner.setUnchained(true);
            this.goalOwner.setUnchaining(false);
        }

        public void playStartUnchainingEffect() {
            this.goalOwner.m_5496_((SoundEvent)AerialHellSoundEvents.ENTITY_CHAINED_GOD_ROAR.get(), 5.0f, 1.6f);
            this.goalOwner.m_5496_((SoundEvent)AerialHellSoundEvents.ENTITY_CHAINED_GOD_UNCHAIN.get(), 5.0f, 0.8f);
        }

        public void playUnchainingEffect() {
        }

        private void immobilizeGoalOwner() {
            if (!this.goalOwner.m_9236_().m_5776_()) {
                this.goalOwner.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19597_, this.getTimeToUnchain() * 2, 10, true, false)));
            }
        }

        public int getTimeToUnchain() {
            return 38;
        }

        protected boolean canUnchain() {
            return this.timeSinceUnchaining > this.getTimeToUnchain();
        }

        protected void resetTask() {
            this.timeSinceUnchaining = 0;
            this.goalOwner.setUnchaining(false);
        }
    }

    public static class ChainedGodRandomFireballAttackGoal
    extends GhastLikeGoals.ShootProjectileGoal {
        public ChainedGodRandomFireballAttackGoal(ChainedGodEntity entity) {
            super((Mob)entity);
        }

        private ChainedGodEntity getChainedGodGoalOwner() {
            return (ChainedGodEntity)this.getParentEntity();
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.getChainedGodGoalOwner().isUnchaining();
        }

        @Override
        public Projectile createProjectile(Level level, LivingEntity shooter, double accX, double accY, double accZ) {
            RandomSource rand = this.getParentEntity().m_217043_();
            ChainedGodFireballEntity projectile = new ChainedGodFireballEntity(level, shooter, rand.m_188503_(7) - 3, rand.m_188503_(5) - 2, rand.m_188503_(7) - 3);
            projectile.m_6034_(projectile.m_20185_(), projectile.m_20186_() + 1.0, projectile.m_20189_());
            return projectile;
        }

        @Override
        public int getShootTimeInterval() {
            return 2;
        }

        @Override
        public int getShootDelay() {
            return 0;
        }

        @Override
        public boolean doesShootTimeDecreaseWhenTargetOutOfSight() {
            return false;
        }

        @Override
        public double getYProjectileOffset() {
            return 0.0;
        }

        @Override
        protected void setAttacking(boolean bool) {
        }

        @Override
        public SoundEvent getShootSound() {
            return null;
        }
    }

    public static class ChainedGodImplodeGoal
    extends Goal {
        private final ChainedGodEntity goalOwner;
        public int implodeTimer;
        public int timeSinceImploding;

        public ChainedGodImplodeGoal(ChainedGodEntity entity) {
            this.goalOwner = entity;
        }

        public boolean m_8036_() {
            return this.goalOwner.isActive() && this.goalOwner.isUnchained() && this.goalOwner.isHealthMatchToImplode();
        }

        public void m_8056_() {
            this.resetTask();
        }

        public void m_8041_() {
            this.resetTask();
            this.goalOwner.setImploding(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            ++this.implodeTimer;
            if (this.willStartImplodingSoon()) {
                this.playStartImplodingSound();
                this.immobilizeGoalOwner();
            }
            if (this.shouldStartImploding()) {
                this.startImploding();
            }
            if (this.goalOwner.isImploding()) {
                ++this.timeSinceImploding;
                if (this.shouldFinishImploding()) {
                    this.finishImploding();
                }
            }
        }

        protected void startImploding() {
            this.goalOwner.setImploding(true);
            this.timeSinceImploding = 0;
        }

        protected void finishImploding() {
            this.implode();
            this.resetTask();
            this.goalOwner.setImploding(false);
        }

        protected void implode() {
            Level level = this.goalOwner.m_9236_();
            if (!level.m_5776_()) {
                Level.ExplosionInteraction explosionInteraction = ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)this.goalOwner) ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
                level.m_254849_((Entity)this.goalOwner, this.goalOwner.m_20185_(), this.goalOwner.m_20186_(), this.goalOwner.m_20189_(), 5.0f, explosionInteraction);
            }
            this.spawnImplosionParticle();
        }

        public void spawnImplosionParticle() {
            Level level = this.goalOwner.m_9236_();
            if (level.m_5776_()) {
                for (int i = 0; i < 30; ++i) {
                    RandomSource rand = this.goalOwner.m_217043_();
                    double d0 = rand.m_188583_() * 0.02;
                    double d1 = rand.m_188583_() * 0.02;
                    double d2 = rand.m_188583_() * 0.02;
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.goalOwner.m_20208_(1.0) - d0 * 10.0, this.goalOwner.m_20187_() - d1 * 10.0, this.goalOwner.m_20262_(1.0) - d2 * 10.0, 2.0 * d0, d1, 2.0 * d2);
                }
            } else {
                level.m_7605_((Entity)this.goalOwner, (byte)20);
            }
        }

        protected void playStartImplodingSound() {
            this.goalOwner.m_5496_((SoundEvent)AerialHellSoundEvents.ENTITY_CHAINED_GOD_ROAR.get(), 5.0f, 1.0f);
        }

        private void immobilizeGoalOwner() {
            if (!this.goalOwner.m_9236_().m_5776_()) {
                this.goalOwner.m_7292_(new MobEffectInstance(new MobEffectInstance(MobEffects.f_19597_, 20, 10, true, false)));
            }
        }

        public int getSoundOffset() {
            return 12;
        }

        public int getImplodeTimerTargetValue() {
            return 600;
        }

        public int getImplosionCastDuration() {
            return 126;
        }

        protected boolean shouldStartImploding() {
            return !this.goalOwner.isImploding() && this.implodeTimer >= this.getImplodeTimerTargetValue();
        }

        protected boolean shouldFinishImploding() {
            return this.timeSinceImploding >= this.getImplosionCastDuration();
        }

        protected boolean willStartImplodingSoon() {
            return this.implodeTimer == this.getImplodeTimerTargetValue() - this.getSoundOffset();
        }

        protected void resetTask() {
            this.implodeTimer = 0;
            this.timeSinceImploding = 0;
        }
    }

    public static class ChainedGodFireballAttackGoal
    extends GhastLikeGoals.ShootProjectileFlurryGoal {
        public ChainedGodFireballAttackGoal(ChainedGodEntity entity) {
            super((Mob)entity);
        }

        @Override
        public boolean m_8036_() {
            ChainedGodEntity chainedGod = (ChainedGodEntity)this.getParentEntity();
            if (!chainedGod.isActive() || chainedGod.isImploding()) {
                return false;
            }
            LivingEntity target = chainedGod.m_5448_();
            double DistanceToTarget = 0.0;
            if (target != null) {
                DistanceToTarget = chainedGod.m_20270_((Entity)target);
            }
            return chainedGod.isHealthMatchToShootFireballs() && target != null && target.m_6084_() && chainedGod.m_6779_(target) && DistanceToTarget < 16.0;
        }

        @Override
        public Projectile createProjectile(Level level, LivingEntity shooter, double accX, double accY, double accZ) {
            RandomSource rand = this.getParentEntity().m_217043_();
            double halfDistanceToTarget = this.getParentEntity().m_20270_((Entity)this.getParentEntity().m_5448_()) / 2.0f;
            return new ChainedGodFireballEntity(level, shooter, accX + 0.5 * rand.m_188583_() * halfDistanceToTarget, accY, accZ + 0.5 * rand.m_188583_() * halfDistanceToTarget);
        }

        @Override
        public int getShootTimeInterval() {
            return 50 - ((ChainedGodEntity)this.getParentEntity()).getDifficulty() * 2;
        }

        @Override
        public int getShootDelay() {
            return 0;
        }

        @Override
        public boolean doesShootTimeDecreaseWhenTargetOutOfSight() {
            return false;
        }

        @Override
        public double getYProjectileOffset() {
            return 0.5;
        }

        @Override
        protected void setAttacking(boolean bool) {
        }

        @Override
        public SoundEvent getShootSound() {
            return null;
        }

        @Override
        public int getProjectileNumber() {
            return 3;
        }

        @Override
        public int getShootInvervalWithinBurst() {
            return 4;
        }
    }

    public static class ChainedGodMeleeAttackGoal
    extends ActiveMeleeAttackGoal {
        public ChainedGodMeleeAttackGoal(ChainedGodEntity godIn, double speedIn, boolean useLongMemory) {
            super(godIn, speedIn, useLongMemory);
        }

        @Override
        public boolean m_8036_() {
            return !((ChainedGodEntity)this.activableGoalOwner).isImploding() && !((ChainedGodEntity)this.activableGoalOwner).isUnchaining() && super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            return !((ChainedGodEntity)this.activableGoalOwner).isImploding() && !((ChainedGodEntity)this.activableGoalOwner).isUnchaining() && super.m_8045_();
        }
    }

    public static class ChainedGodWaterAvoidingRandomWalkingGoal
    extends ActiveWaterAvoidingRandomWalkingGoal {
        public ChainedGodWaterAvoidingRandomWalkingGoal(ChainedGodEntity god, double speedIn) {
            super(god, speedIn);
        }

        @Override
        public boolean m_8036_() {
            return !((ChainedGodEntity)this.activableGoalOwner).isImploding() && !((ChainedGodEntity)this.activableGoalOwner).isUnchaining() && super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            return !((ChainedGodEntity)this.activableGoalOwner).isImploding() && !((ChainedGodEntity)this.activableGoalOwner).isUnchaining() && super.m_8045_();
        }
    }

    public static class ChainedGodLeapAtTargetGoal
    extends ActiveLeapAtTargetGoal {
        public ChainedGodLeapAtTargetGoal(ChainedGodEntity godIn, float leapMotionYIn) {
            super(godIn, leapMotionYIn);
        }

        @Override
        public boolean m_8036_() {
            return !((ChainedGodEntity)this.activableGoalOwner).isImploding() && !((ChainedGodEntity)this.activableGoalOwner).isUnchaining() && super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            return !((ChainedGodEntity)this.activableGoalOwner).isImploding() && !((ChainedGodEntity)this.activableGoalOwner).isUnchaining() && super.m_8045_();
        }
    }
}

