/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity;

import fr.factionbedrock.aerialhell.Registry.AerialHellBlocksAndItems;
import fr.factionbedrock.aerialhell.Registry.Entities.AerialHellEntities;
import fr.factionbedrock.aerialhell.Registry.Misc.AerialHellPaintingVariants;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AerialHellPaintingEntity
extends HangingEntity
implements VariantHolder<Holder<PaintingVariant>> {
    public static final EntityDataAccessor<Holder<PaintingVariant>> DATA_PAINTING_VARIANT_ID = SynchedEntityData.m_135353_(AerialHellPaintingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_238116_);
    private static final ResourceKey<PaintingVariant> DEFAULT_VARIANT = PaintingVariants.f_218914_;
    public static final String VARIANT_TAG = "variant";

    public AerialHellPaintingEntity(EntityType<? extends AerialHellPaintingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    private AerialHellPaintingEntity(Level level, BlockPos pos) {
        super((EntityType)AerialHellEntities.AERIAL_HELL_PAINTING.get(), level, pos);
    }

    public AerialHellPaintingEntity(Level level, BlockPos pos, Direction direction, Holder<PaintingVariant> variant) {
        this(level, pos);
        this.setVariant(variant);
        this.m_6022_(direction);
    }

    private static Holder<PaintingVariant> getDefaultVariant() {
        return (Holder)AerialHellPaintingVariants.SPOOKY_ISLANDS.getHolder().get();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_PAINTING_VARIANT_ID, AerialHellPaintingEntity.getDefaultVariant());
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (DATA_PAINTING_VARIANT_ID.equals(dataAccessor)) {
            this.m_7087_();
        }
    }

    public Holder<PaintingVariant> getVariant() {
        return (Holder)this.f_19804_.m_135370_(DATA_PAINTING_VARIANT_ID);
    }

    public void setVariant(Holder<PaintingVariant> variant) {
        this.f_19804_.m_135381_(DATA_PAINTING_VARIANT_ID, variant);
    }

    public static Optional<AerialHellPaintingEntity> create(Level level, BlockPos pos, Direction direction) {
        AerialHellPaintingEntity painting = new AerialHellPaintingEntity(level, pos);
        List<Holder<PaintingVariant>> list = AerialHellPaintingVariants.getAerialHellPaintingVariantList();
        if (list.isEmpty()) {
            return Optional.empty();
        }
        painting.m_6022_(direction);
        list.removeIf(variant -> {
            painting.setVariant((Holder<PaintingVariant>)variant);
            return !painting.m_7088_();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int i = list.stream().mapToInt(AerialHellPaintingEntity::variantArea).max().orElse(0);
        list.removeIf(variant -> AerialHellPaintingEntity.variantArea((Holder<PaintingVariant>)variant) < i);
        Optional optional = Util.m_214676_(list, (RandomSource)painting.f_19796_);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        painting.setVariant((Holder<PaintingVariant>)((Holder)optional.get()));
        painting.m_6022_(direction);
        return Optional.of(painting);
    }

    private static int variantArea(Holder<PaintingVariant> variant) {
        return ((PaintingVariant)variant.m_203334_()).m_218908_() * ((PaintingVariant)variant.m_203334_()).m_218909_();
    }

    public void m_7380_(CompoundTag tag) {
        AerialHellPaintingEntity.storeVariant(tag, this.getVariant());
        tag.m_128344_("facing", (byte)this.f_31699_.m_122416_());
        super.m_7380_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        Holder holder = AerialHellPaintingEntity.loadVariant(tag).orElseGet(AerialHellPaintingEntity::getDefaultVariant);
        this.setVariant((Holder<PaintingVariant>)holder);
        this.f_31699_ = Direction.m_122407_((int)tag.m_128445_("facing"));
        super.m_7378_(tag);
        this.m_6022_(this.f_31699_);
    }

    public static void storeVariant(CompoundTag tag, Holder<PaintingVariant> variant) {
        tag.m_128359_(VARIANT_TAG, variant.m_203543_().orElse(DEFAULT_VARIANT).m_135782_().toString());
    }

    public static Optional<Holder<PaintingVariant>> loadVariant(CompoundTag tag) {
        return Optional.ofNullable(ResourceLocation.m_135820_((String)tag.m_128461_(VARIANT_TAG))).map(resourceLocation -> ResourceKey.m_135785_((ResourceKey)Registries.f_256836_, (ResourceLocation)resourceLocation)).flatMap(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257051_).m_203636_(arg_0));
    }

    public int m_7076_() {
        return ((PaintingVariant)this.getVariant().m_203334_()).m_218908_();
    }

    public int m_7068_() {
        return ((PaintingVariant)this.getVariant().m_203334_()).m_218909_();
    }

    public void m_5553_(@Nullable Entity entity) {
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_150110_().f_35937_) {
                    return;
                }
            }
            this.m_19998_((ItemLike)AerialHellBlocksAndItems.AERIAL_HELL_PAINTING.get());
        }
    }

    public void m_7084_() {
        this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
    }

    public void m_7678_(double x, double y, double z, float yrot, float xrot) {
        this.m_6034_(x, y, z);
    }

    public void m_6453_(double x, double y, double z, float yrot, float xrot, int lerpSteps) {
        this.m_6034_(x, y, z);
    }

    public Vec3 m_213870_() {
        return Vec3.m_82528_((Vec3i)this.f_31698_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, this.f_31699_.m_122411_(), this.m_31748_());
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.m_6022_(Direction.m_122376_((int)packet.m_131509_()));
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)AerialHellBlocksAndItems.AERIAL_HELL_PAINTING.get());
    }
}

