/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity;

import fr.factionbedrock.aerialhell.Entity.AbstractActivableEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class AbstractBossEntity
extends AbstractActivableEntity {
    protected final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);
    public static final EntityDataAccessor<Integer> BOSS_DIFFICULTY = SynchedEntityData.m_135353_(AbstractBossEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public AbstractBossEntity(EntityType<? extends Monster> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOSS_DIFFICULTY, (Object)0);
    }

    public void setDifficulty(int difficulty) {
        this.f_19804_.m_135381_(BOSS_DIFFICULTY, (Object)difficulty);
    }

    public int getDifficulty() {
        return (Integer)this.f_19804_.m_135370_(BOSS_DIFFICULTY);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isActive() && this.f_19797_ % 900 == 0) {
            this.updateBossDifficulty();
            this.adaptBossDifficulty();
        }
        this.bossInfo.m_8321_(this.isActive());
    }

    @Override
    public void setActive(boolean isActive) {
        super.setActive(isActive);
        this.updateBossDifficulty();
        this.adaptBossDifficulty();
    }

    private void updateBossDifficulty() {
        List nearbyEntities = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(30.0), EntitySelector.m_20410_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)15.0));
        int playerCount = 0;
        for (Entity entity : nearbyEntities) {
            Player player;
            if (!(entity instanceof Player) || (player = (Player)entity).m_7500_() || player.m_5833_()) continue;
            ++playerCount;
        }
        this.setDifficulty(Math.min(playerCount, 6));
    }

    protected void adaptBossDifficulty() {
        int amplifier;
        if (this.m_21023_(MobEffects.f_19606_)) {
            this.m_21195_(MobEffects.f_19606_);
        }
        if (this.m_21023_(MobEffects.f_19600_)) {
            this.m_21195_(MobEffects.f_19600_);
        }
        if ((amplifier = this.getDifficulty() - 1) > 0) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 54000, Math.min(3, (int)Math.ceil((float)amplifier / 2.0f)), false, false));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 54000, Math.min(3, amplifier - 1), false, false));
        }
    }

    protected void m_7472_(DamageSource p_33574_, int p_33575_, boolean p_33576_) {
        if (this.getTrophy() != null && this.m_217043_().m_188503_(10) == 0) {
            this.m_19998_((ItemLike)this.getTrophy());
        }
    }

    @Nullable
    public abstract Item getTrophy();

    @Override
    public int getMinTimeToActivate() {
        return 5;
    }

    @Override
    public double getMinDistanceToActivate() {
        return 8.0;
    }

    @Override
    public double getMinDistanceToDeactivate() {
        return 48.0;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }
}

