/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.AI;

import fr.factionbedrock.aerialhell.Entity.Passive.GlidingTurtleEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class GlideGoal
extends Goal {
    private final GlidingTurtleEntity goalOwner;
    private int jumpTimer;
    private int randomTimerBonus;

    public GlideGoal(GlidingTurtleEntity entity) {
        this.goalOwner = entity;
    }

    public boolean m_8036_() {
        return true;
    }

    public void m_8056_() {
        this.resetTask();
    }

    public void m_8041_() {
        this.goalOwner.setGliding(false);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.goalOwner.isGliding()) {
            this.setGlidingMotion();
        } else if (this.shouldStartGliding()) {
            this.goalOwner.setGliding(true);
        }
        if (this.shouldJump()) {
            this.glideJump();
            this.resetTask();
        }
        if (this.shouldIncrementJumpTimer()) {
            this.incrementJumpTimer();
        }
        if (this.shouldPanicBonusIncrementJumpTimer()) {
            for (int i = 0; i < 3; ++i) {
                this.incrementJumpTimer();
            }
        }
        if (this.shouldStopGliding()) {
            this.goalOwner.setGliding(false);
        }
    }

    private void setGlidingMotion() {
        if (this.goalOwner.m_20184_().f_82480_ < 0.0) {
            Vec3 forward = Vec3.m_82503_((Vec2)this.goalOwner.m_20155_());
            if (this.hasBlockUnder(this.goalOwner.m_20183_().m_7918_((int)(2.5 * forward.f_82479_), (int)forward.f_82480_, (int)(2.5 * forward.f_82481_)), 20)) {
                this.glideForward(forward);
            } else if (this.hasBlockUnder(this.goalOwner.m_20183_(), 25)) {
                this.slowDownMovement();
            } else {
                this.speedUpMovement(forward);
            }
        }
    }

    private void glideForward(Vec3 forward) {
        this.goalOwner.m_20256_(this.goalOwner.m_20184_().m_82542_(1.0, 0.6, 1.0).m_82520_(forward.f_82479_ / 100.0, 0.0, forward.f_82481_ / 100.0));
    }

    private void slowDownMovement() {
        this.goalOwner.m_20256_(this.goalOwner.m_20184_().m_82542_(0.9, 0.6, 0.9));
    }

    private void speedUpMovement(Vec3 direction) {
        this.goalOwner.m_20256_(this.goalOwner.m_20184_().m_82542_(1.0, 0.5, 1.0).m_82520_(direction.f_82479_ / 70.0, 0.0, direction.f_82481_ / 70.0));
    }

    protected boolean hasBlockUnder(BlockPos pos, int yBlocksDistance) {
        for (int dy = 0; dy < yBlocksDistance; ++dy) {
            if (this.goalOwner.m_9236_().m_46859_(pos.m_6625_(dy))) continue;
            return true;
        }
        return false;
    }

    public void glideJump() {
        double jumpPower = this.goalOwner.m_6162_() ? 1.1 : 1.5;
        this.goalOwner.m_20256_(this.goalOwner.m_20184_().m_82520_(0.0, jumpPower, 0.0));
    }

    protected boolean shouldJump() {
        return this.jumpTimer > this.getJumpTimerTargetValue() && !this.goalOwner.isGliding() && this.goalOwner.m_20096_();
    }

    protected boolean shouldStartGliding() {
        return this.goalOwner.m_20184_().f_82480_ < -0.3;
    }

    protected boolean shouldStopGliding() {
        return this.goalOwner.isGliding() && this.goalOwner.m_20096_() && this.goalOwner.m_20184_().f_82480_ >= (double)-0.1f;
    }

    protected boolean shouldIncrementJumpTimer() {
        return this.goalOwner.m_20096_() && !this.goalOwner.isGliding();
    }

    protected boolean shouldPanicBonusIncrementJumpTimer() {
        return this.goalOwner.m_21188_() != null && this.goalOwner.f_19797_ - this.goalOwner.m_21213_() < 40;
    }

    protected void incrementJumpTimer() {
        this.jumpTimer += 1 + this.goalOwner.m_217043_().m_188503_(this.randomTimerBonus);
    }

    protected int getJumpTimerTargetValue() {
        return 1200;
    }

    protected void resetTask() {
        this.jumpTimer = 0;
        this.randomTimerBonus = 1 + this.goalOwner.m_217043_().m_188503_(10);
    }
}

