/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.AI;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GhastLikeGoals {

    public static abstract class ShootProjectileFlurryGoal
    extends ShootProjectileGoal {
        private int shotProjectileCount;

        public ShootProjectileFlurryGoal(Mob mob) {
            super(mob);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.shotProjectileCount = 0;
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.shotProjectileCount = 0;
        }

        @Override
        protected void resetTask() {
            super.resetTask();
            this.shotProjectileCount = 0;
        }

        @Override
        protected boolean tryShooting(LivingEntity target) {
            boolean shouldShootAnotherProjectileNow;
            boolean isNotFirstProjectileToBeShot = this.shotProjectileCount > 0;
            boolean bl = shouldShootAnotherProjectileNow = isNotFirstProjectileToBeShot && this.shootTimer > this.getShootDelay() && this.shootTimer - this.shotProjectileCount * this.getShootInvervalWithinBurst() >= this.getShootDelay();
            if (this.shootTimer == this.getShootDelay() || shouldShootAnotherProjectileNow) {
                this.getParentEntity().m_9236_().m_7967_((Entity)this.createProjectile(target));
                return ++this.shotProjectileCount >= this.getProjectileNumber();
            }
            return false;
        }

        public abstract int getProjectileNumber();

        public abstract int getShootInvervalWithinBurst();
    }

    public static abstract class ShootProjectileGoal
    extends Goal {
        private final Mob parentEntity;
        public int shootTimer;

        public ShootProjectileGoal(Mob mob) {
            this.parentEntity = mob;
        }

        public Mob getParentEntity() {
            return this.parentEntity;
        }

        public boolean m_8036_() {
            return this.parentEntity.m_5448_() != null;
        }

        public void m_8056_() {
            this.resetTask();
        }

        public void m_8041_() {
            this.resetTask();
            this.setAttacking(false);
        }

        public void m_8037_() {
            LivingEntity target = this.parentEntity.m_5448_();
            if (target.m_20280_((Entity)this.parentEntity) < 4096.0 && this.parentEntity.m_142582_((Entity)target)) {
                ++this.shootTimer;
                if (this.tryPlayingShootSound()) {
                    // empty if block
                }
                if (this.tryShooting(target)) {
                    this.resetTask();
                }
            } else if (this.doesShootTimeDecreaseWhenTargetOutOfSight() && this.shootTimer > -this.getShootTimeInterval()) {
                --this.shootTimer;
            }
            this.setAttacking(this.shootTimer > 0);
        }

        protected void resetTask() {
            this.shootTimer = -this.getShootTimeInterval();
        }

        protected boolean tryPlayingShootSound() {
            if (this.shootTimer == 0 && this.getShootSound() != null) {
                this.parentEntity.m_5496_(this.getShootSound(), 3.0f, (this.parentEntity.m_9236_().f_46441_.m_188501_() - this.parentEntity.m_9236_().f_46441_.m_188501_()) * 0.2f + 1.0f);
                return true;
            }
            return false;
        }

        protected boolean tryShooting(LivingEntity target) {
            if (this.shootTimer >= this.getShootDelay()) {
                this.parentEntity.m_9236_().m_7967_((Entity)this.createProjectile(target));
                return true;
            }
            return false;
        }

        public Projectile createProjectile(LivingEntity target) {
            double Xdistance = target.m_20185_() - this.parentEntity.m_20185_();
            double Ydistance = target.m_20227_(0.5) - this.parentEntity.m_20227_(0.5);
            double Zdistance = target.m_20189_() - this.parentEntity.m_20189_();
            Projectile projectile = this.createProjectile(this.parentEntity.m_9236_(), (LivingEntity)this.parentEntity, Xdistance, Ydistance, Zdistance);
            projectile.m_6034_(this.parentEntity.m_20185_(), this.parentEntity.m_20227_(0.5) + this.getYProjectileOffset(), this.parentEntity.m_20189_());
            return projectile;
        }

        public abstract double getYProjectileOffset();

        public abstract int getShootDelay();

        public abstract int getShootTimeInterval();

        public abstract boolean doesShootTimeDecreaseWhenTargetOutOfSight();

        public abstract Projectile createProjectile(Level var1, LivingEntity var2, double var3, double var5, double var7);

        protected abstract void setAttacking(boolean var1);

        @Nullable
        public abstract SoundEvent getShootSound();
    }

    public static class MoveHelperController
    extends MoveControl {
        private final Mob parentEntity;
        private int courseChangeCooldown;

        public MoveHelperController(Mob flyingMob) {
            super(flyingMob);
            this.parentEntity = flyingMob;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                this.courseChangeCooldown += this.parentEntity.m_217043_().m_188503_(5) + 2;
                Vec3 vec = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vec.m_82553_();
                if (this.canReach(vec = vec.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vec.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 pos, int distance) {
            AABB boundingBox = this.parentEntity.m_20191_();
            for (int i = 1; i < distance; ++i) {
                boundingBox = boundingBox.m_82383_(pos);
                if (this.parentEntity.m_9236_().m_45756_((Entity)this.parentEntity, boundingBox)) continue;
                return false;
            }
            return true;
        }
    }

    public static class RandomFlyGoal
    extends Goal {
        private final Mob parentEntity;

        public RandomFlyGoal(Mob flyingMob) {
            this.parentEntity = flyingMob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public Mob getParentEntity() {
            return this.parentEntity;
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl movementcontroller = this.parentEntity.m_21566_();
            if (!movementcontroller.m_24995_()) {
                return true;
            }
            double d0 = movementcontroller.m_25000_() - this.parentEntity.m_20185_();
            double d3 = d0 * d0 + (d1 = movementcontroller.m_25001_() - this.parentEntity.m_20186_()) * d1 + (d2 = movementcontroller.m_25002_() - this.parentEntity.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.parentEntity.m_217043_();
            double d0 = this.parentEntity.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.parentEntity.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.parentEntity.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.parentEntity.m_21566_().m_6849_(d0, d1, d2, 1.0);
        }
    }

    public static class LookAroundGoal
    extends Goal {
        private final Mob parentEntity;

        public LookAroundGoal(Mob flyingMob) {
            this.parentEntity = flyingMob;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.parentEntity.m_5448_() == null) {
                Vec3 vec = this.parentEntity.m_20184_();
                this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)vec.f_82479_, (double)vec.f_82481_)) * 57.295776f);
                this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
            } else {
                LivingEntity livingentity = this.parentEntity.m_5448_();
                if (livingentity.m_20280_((Entity)this.parentEntity) < 4096.0) {
                    double x = livingentity.m_20185_() - this.parentEntity.m_20185_();
                    double z = livingentity.m_20189_() - this.parentEntity.m_20189_();
                    this.parentEntity.m_146922_(-((float)Mth.m_14136_((double)x, (double)z)) * 57.295776f);
                    this.parentEntity.f_20883_ = this.parentEntity.m_146908_();
                }
            }
        }
    }
}

