/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Entity.AI;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class FleeBlockGoal<T extends Block>
extends Goal {
    private static final int BOX_TO_CHECK_SIZE_XZ = 5;
    private static final int BOX_TO_CHECK_SIZE_Y = 2;
    protected Path path;
    protected BlockPos posToAvoid;
    protected Vec3 fleePos;
    List<T> blocksToAvoid;
    private final PathfinderMob goalOwner;
    protected final PathNavigation navigator;
    private final double nearSpeed;
    private final double farSpeed;

    public FleeBlockGoal(PathfinderMob entity, List<T> blocks, double farSpeedIn, double nearSpeedIn) {
        this.goalOwner = entity;
        this.navigator = entity.m_21573_();
        this.blocksToAvoid = blocks;
        this.nearSpeed = nearSpeedIn;
        this.farSpeed = farSpeedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Vec3i goalOwnerPos = new Vec3i((int)this.goalOwner.m_20185_(), (int)this.goalOwner.m_20186_(), (int)this.goalOwner.m_20189_());
        this.posToAvoid = this.getPosToAvoid();
        if (this.posToAvoid == null) {
            return false;
        }
        Vec3 posToAvoidVector = new Vec3((double)this.posToAvoid.m_123341_(), (double)this.posToAvoid.m_123342_(), (double)this.posToAvoid.m_123343_());
        this.fleePos = DefaultRandomPos.m_148407_((PathfinderMob)this.goalOwner, (int)16, (int)7, (Vec3)posToAvoidVector);
        if (this.fleePos == null) {
            return false;
        }
        Vec3i vec3i = new Vec3i((int)this.fleePos.f_82479_, (int)this.fleePos.f_82480_, (int)this.fleePos.f_82481_);
        if (this.posToAvoid.m_123331_(vec3i) < this.posToAvoid.m_123331_(goalOwnerPos)) {
            return false;
        }
        this.path = this.navigator.m_26524_(this.fleePos.f_82479_, this.fleePos.f_82480_, this.fleePos.f_82481_, 0);
        return this.path != null;
    }

    public void m_8056_() {
        this.navigator.m_26536_(this.path, this.farSpeed);
    }

    public boolean m_8045_() {
        return !this.navigator.m_26571_() && this.posToAvoid != null;
    }

    public void m_8041_() {
        this.posToAvoid = null;
        this.fleePos = null;
    }

    public void m_8037_() {
        if (this.goalOwner.m_20275_((double)this.posToAvoid.m_123341_(), (double)this.posToAvoid.m_123342_(), (double)this.posToAvoid.m_123343_()) < 49.0) {
            this.navigator.m_26517_(this.nearSpeed);
        } else {
            this.navigator.m_26517_(this.farSpeed);
        }
    }

    @Nullable
    protected BlockPos getPosToAvoid() {
        int x = (int)this.goalOwner.m_20185_();
        int y = (int)this.goalOwner.m_20186_();
        int z = (int)this.goalOwner.m_20189_();
        for (int dx = -5; dx <= 5; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -5; dz <= 5; ++dz) {
                    BlockPos currentPos = new BlockPos(x + dx, y + dy, z + dz);
                    Block currentBlock = this.goalOwner.m_9236_().m_8055_(currentPos).m_60734_();
                    for (Block block : this.blocksToAvoid) {
                        if (currentBlock != block) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }
}

