/*
 * Decompiled with CFR 0.152.
 */
package fr.factionbedrock.aerialhell.Client.EntityModels;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fr.factionbedrock.aerialhell.Entity.Passive.KodamaEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class KodamaModel<T extends KodamaEntity>
extends EntityModel<T> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart face_1;
    private final ModelPart face_2;
    private final ModelPart face_3;
    private final ModelPart face_4;
    private final ModelPart face_5;
    private final ModelPart face_6;
    private final ModelPart face_7;
    private final ModelPart arm0;
    private final ModelPart arm1;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private boolean isEmpty;
    private int faceId;
    private long dayTime;
    private float forcedAlphaBonus;

    public KodamaModel(ModelPart root, boolean isEmpty) {
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.face_1 = root.m_171324_("face_1");
        this.face_2 = root.m_171324_("face_2");
        this.face_3 = root.m_171324_("face_3");
        this.face_4 = root.m_171324_("face_4");
        this.face_5 = root.m_171324_("face_5");
        this.face_6 = root.m_171324_("face_6");
        this.face_7 = root.m_171324_("face_7");
        this.arm0 = root.m_171324_("arm0");
        this.arm1 = root.m_171324_("arm1");
        this.leg0 = root.m_171324_("leg0");
        this.leg1 = root.m_171324_("leg1");
        this.isEmpty = isEmpty;
        this.forcedAlphaBonus = 0.0f;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(9, 18).m_171480_().m_171488_(-3.5f, 15.0f, -1.0f, 7.0f, 9.0f, 2.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-4.9444f, -9.5f, -3.6111f, 10.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.0556f, (float)7.5f, (float)-0.3889f));
        PartDefinition face_1 = partdefinition.m_171599_("face_1", CubeListBuilder.m_171558_().m_171514_(50, 27).m_171480_().m_171488_(1.0556f, -6.0f, -4.6111f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(50, 27).m_171480_().m_171488_(-3.9444f, -7.5f, -4.6111f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(49, 25).m_171480_().m_171488_(-1.9444f, -2.5f, -4.6111f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.0556f, (float)7.5f, (float)-0.3889f));
        PartDefinition face_2 = partdefinition.m_171599_("face_2", CubeListBuilder.m_171558_().m_171514_(49, 26).m_171480_().m_171488_(1.5556f, -8.0f, -4.6111f, 2.5f, 2.5f, 2.5f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(50, 27).m_171480_().m_171488_(-2.9444f, -5.5f, -4.6111f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(49, 25).m_171480_().m_171488_(3.0556f, -2.5f, -4.6111f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.0556f, (float)7.5f, (float)-0.3889f));
        PartDefinition face_3 = partdefinition.m_171599_("face_3", CubeListBuilder.m_171558_().m_171514_(49, 26).m_171480_().m_171488_(1.5556f, -8.0f, -5.1111f, 2.5f, 2.5f, 2.5f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(52, 22).m_171480_().m_171488_(-4.4444f, -8.0f, -4.6111f, 2.5f, 2.5f, 2.5f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(52, 25).m_171480_().m_171488_(-1.9444f, -4.5f, -4.6111f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.0556f, (float)7.5f, (float)-0.3889f));
        PartDefinition face_4 = partdefinition.m_171599_("face_4", CubeListBuilder.m_171558_().m_171514_(50, 27).m_171480_().m_171488_(1.0556f, -7.5f, -4.6111f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(52, 22).m_171480_().m_171488_(-4.4444f, -8.0f, -5.1111f, 2.5f, 2.5f, 2.5f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(49, 25).m_171480_().m_171488_(-3.9444f, -2.5f, -4.6111f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.0556f, (float)7.5f, (float)-0.3889f));
        PartDefinition face_5 = partdefinition.m_171599_("face_5", CubeListBuilder.m_171558_().m_171514_(50, 27).m_171480_().m_171488_(1.0556f, -5.5f, -4.6111f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(52, 22).m_171480_().m_171488_(-4.4444f, -8.0f, -5.1111f, 2.5f, 2.5f, 2.5f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(49, 25).m_171480_().m_171488_(0.0556f, -2.5f, -4.6111f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.0556f, (float)7.5f, (float)-0.3889f));
        PartDefinition face_6 = partdefinition.m_171599_("face_6", CubeListBuilder.m_171558_().m_171514_(50, 27).m_171480_().m_171488_(2.0556f, -7.5f, -4.6111f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(52, 22).m_171480_().m_171488_(-3.4444f, -8.5f, -4.6111f, 2.5f, 2.5f, 2.5f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(49, 25).m_171480_().m_171488_(-1.4444f, -3.5f, -4.6111f, 1.5f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.0556f, (float)7.5f, (float)-0.3889f));
        PartDefinition face_7 = partdefinition.m_171599_("face_7", CubeListBuilder.m_171558_().m_171514_(52, 22).m_171480_().m_171488_(1.5556f, -7.0f, -4.6111f, 2.5f, 2.5f, 2.5f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(52, 22).m_171480_().m_171488_(-3.9444f, -8.0f, -4.6111f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(47, 23).m_171480_().m_171488_(0.5556f, -2.5f, -4.6111f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-0.0556f, (float)7.5f, (float)-0.3889f));
        PartDefinition arm0 = partdefinition.m_171599_("arm0", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171480_().m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)4.0f, (float)8.5f, (float)0.0f));
        PartDefinition arm1 = partdefinition.m_171599_("arm1", CubeListBuilder.m_171558_().m_171514_(56, 0).m_171480_().m_171488_(-2.0f, 0.0f, -1.0f, 2.0f, 10.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)8.5f, (float)0.0f));
        PartDefinition leg0 = partdefinition.m_171599_("leg0", CubeListBuilder.m_171558_().m_171514_(29, 19).m_171480_().m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)17.0f, (float)0.0f));
        PartDefinition leg1 = partdefinition.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(37, 19).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)17.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.faceId = ((KodamaEntity)((Object)entity)).getFaceId();
        this.dayTime = entity.m_9236_().m_46468_() % 24000L;
        this.forcedAlphaBonus = this.getForcedAlphaBonus(entity);
        this.setHeadRot(netHeadYaw, headPitch, this.getZRotAngleFromEntityTiltAngle(entity));
        this.arm0.f_104205_ = -0.1f;
        this.arm1.f_104205_ = 0.1f;
        this.arm0.f_104203_ = (-0.2f + 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * limbSwingAmount * 0.6f;
        this.arm1.f_104203_ = (-0.2f - 1.5f * Mth.m_14156_((float)limbSwing, (float)13.0f)) * limbSwingAmount * 0.6f;
        this.leg0.f_104203_ = -1.0f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.leg1.f_104203_ = 1.0f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
    }

    private void setHeadRot(float netHeadYaw, float headPitch, float zRot) {
        this.setHeadXRot(headPitch / 57.3f);
        this.setHeadYRot(netHeadYaw / 57.3f);
        this.setHeadZRot(zRot);
    }

    private void setHeadXRot(float xrot) {
        this.head.f_104203_ = xrot;
        this.face_1.f_104203_ = xrot;
        this.face_2.f_104203_ = xrot;
        this.face_3.f_104203_ = xrot;
        this.face_4.f_104203_ = xrot;
        this.face_5.f_104203_ = xrot;
        this.face_6.f_104203_ = xrot;
        this.face_7.f_104203_ = xrot;
    }

    private void setHeadYRot(float yrot) {
        this.head.f_104204_ = yrot;
        this.face_1.f_104204_ = yrot;
        this.face_2.f_104204_ = yrot;
        this.face_3.f_104204_ = yrot;
        this.face_4.f_104204_ = yrot;
        this.face_5.f_104204_ = yrot;
        this.face_6.f_104204_ = yrot;
        this.face_7.f_104204_ = yrot;
    }

    private void setHeadZRot(float zrot) {
        this.head.f_104205_ = zrot;
        this.face_1.f_104205_ = zrot;
        this.face_2.f_104205_ = zrot;
        this.face_3.f_104205_ = zrot;
        this.face_4.f_104205_ = zrot;
        this.face_5.f_104205_ = zrot;
        this.face_6.f_104205_ = zrot;
        this.face_7.f_104205_ = zrot;
    }

    private float getMaxHeadZRot(T entity) {
        return ((KodamaEntity)((Object)entity)).rattleHeadRotZAmplitude;
    }

    private float getZRotAngleFromEntityTiltAngle(T entity) {
        return this.getMaxHeadZRot(entity) * (float)((KodamaEntity)((Object)entity)).getRattlingTiltAngle() / (float)((KodamaEntity)((Object)entity)).getMaxRattlingTiltAngle();
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!this.isEmpty) {
            float a;
            float f = a = this.forcedAlphaBonus > 0.0f ? alpha - this.forcedAlphaBonus : alpha - this.getAlphaBonus();
            if (this.faceId == 1) {
                this.face_1.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, a);
            } else if (this.faceId == 2) {
                this.face_2.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, a);
            } else if (this.faceId == 3) {
                this.face_3.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, a);
            } else if (this.faceId == 4) {
                this.face_4.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, a);
            } else if (this.faceId == 5) {
                this.face_5.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, a);
            } else if (this.faceId == 6) {
                this.face_6.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, a);
            } else if (this.faceId == 7) {
                this.face_7.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, a);
            }
            float r = red;
            float g = green;
            float b = blue;
            this.body.m_104306_(poseStack, vertexConsumer, 255, packedOverlay, r -= this.getBlueBonus(), g -= this.getBlueBonus() / 10.0f, b, a);
            this.head.m_104306_(poseStack, vertexConsumer, 255, packedOverlay, r, g, b, a);
            this.arm0.m_104306_(poseStack, vertexConsumer, 255, packedOverlay, r, g, b, a);
            this.arm1.m_104306_(poseStack, vertexConsumer, 255, packedOverlay, r, g, b, a);
            this.leg0.m_104306_(poseStack, vertexConsumer, 255, packedOverlay, r, g, b, a);
            this.leg1.m_104306_(poseStack, vertexConsumer, 255, packedOverlay, r, g, b, a);
        }
    }

    private float getBlueBonus() {
        if (this.dayTime > 13000L) {
            float blueBonus;
            if (this.dayTime < 18000L) {
                long tickBonus = this.dayTime - 13000L;
                blueBonus = (float)tickBonus / 5000.0f;
            } else {
                long tickBonus = 24000L - this.dayTime;
                blueBonus = (float)tickBonus / 6000.0f;
            }
            return blueBonus / 2.0f;
        }
        return 0.0f;
    }

    private float getAlphaBonus() {
        if (this.dayTime <= 13000L) {
            if (this.dayTime < 1000L) {
                return (float)this.dayTime / 1000.0f;
            }
            if (this.dayTime >= 1000L && this.dayTime <= 12000L) {
                return 1.0f;
            }
            return (13000.0f - (float)this.dayTime) / 1000.0f;
        }
        return 0.0f;
    }

    private float getForcedAlphaBonus(T entity) {
        if (((KodamaEntity)((Object)entity)).timeForceInvisible > 0) {
            int transitionTime = ((KodamaEntity)((Object)entity)).getMaxTimeForceInvisible() / 10;
            if (((KodamaEntity)((Object)entity)).timeForceInvisible > ((KodamaEntity)((Object)entity)).getMaxTimeForceInvisible() - transitionTime) {
                return (float)(((KodamaEntity)((Object)entity)).getMaxTimeForceInvisible() - ((KodamaEntity)((Object)entity)).timeForceInvisible) / (float)transitionTime;
            }
            if (((KodamaEntity)((Object)entity)).timeForceInvisible > transitionTime) {
                return 1.0f;
            }
            return (float)((KodamaEntity)((Object)entity)).timeForceInvisible / (float)transitionTime;
        }
        return 0.0f;
    }
}

